/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.engine.ui.commons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gemoc.xdsmlframework.api.core.IRunConfiguration;
import org.eclipse.gemoc.xdsmlframework.api.extensions.engine_addon.EngineAddonSpecificationExtension;
import org.eclipse.gemoc.xdsmlframework.api.extensions.engine_addon.EngineAddonSpecificationExtensionPoint;

public class RunConfiguration
implements IRunConfiguration {
    protected ILaunchConfiguration _launchConfiguration;
    private int _animationDelay = 0;
    private URI _modelURI;
    private String _melangeQuery = "";
    private URI _animatorURI;
    private int _deadlockDetectionDepth = 0;
    private HashMap<EngineAddonSpecificationExtension, Boolean> _engineAddonExtensions = new HashMap();
    private String _methodEntryPoint;
    private String _modelEntryPoint;
    private String _languageName;
    private String _modelInitializationMethod;
    private String _modelInitializationArguments;
    private boolean _breakStart;
    private String _debugModelID;

    public RunConfiguration(ILaunchConfiguration launchConfiguration) throws CoreException {
        this._launchConfiguration = launchConfiguration;
        this.extractInformation();
    }

    protected void extractInformation() throws CoreException {
        this._languageName = this.getAttribute("GEMOC_LAUNCH_SELECTED_LANGUAGE", "");
        this._modelURI = URI.createPlatformResourceURI((String)this.getAttribute("Resource", ""), (boolean)true);
        String animatorURIAsString = this.getAttribute("airdResource", "");
        if (animatorURIAsString != null && !animatorURIAsString.equals("")) {
            this._animatorURI = URI.createPlatformResourceURI((String)animatorURIAsString, (boolean)true);
            this._animationDelay = this.getAttribute("GEMOC_ANIMATE_DELAY", 0);
        }
        this._deadlockDetectionDepth = this.getAttribute("GEMOC_LAUNCH_DEADLOCK_DETECTION_DEPTH", 10);
        this._methodEntryPoint = this.getAttribute("LAUNCH_METHOD_ENTRY_POINT", "");
        this._modelEntryPoint = this.getAttribute("LAUNCH_MODEL_ENTRY_POINT", "");
        this._modelInitializationMethod = this.getAttribute("GEMOC_LAUNCH_INITIALIZATION_METHOD", "");
        this._modelInitializationArguments = this.getAttribute("GEMOC_LAUNCH_INITIALIZATION_ARGUMENTS", "");
        this._melangeQuery = this.getAttribute("GEMOC_LAUNCH_MELANGE_QUERY", "");
        for (EngineAddonSpecificationExtension extension : EngineAddonSpecificationExtensionPoint.getSpecifications()) {
            this._engineAddonExtensions.put(extension, this.getAttribute(extension.getName(), false));
        }
        this._breakStart = this.getAttribute("GEMOC_LAUNCH_BREAK_START", Boolean.FALSE);
        this._debugModelID = this.getAttribute("GEMOC_DEBUG_MODEL_ID", ".debugModel");
    }

    protected String getAttribute(String attributeName, String defaultValue) throws CoreException {
        return this._launchConfiguration.getAttribute(attributeName, defaultValue);
    }

    protected Integer getAttribute(String attributeName, Integer defaultValue) throws CoreException {
        return this._launchConfiguration.getAttribute(attributeName, defaultValue.intValue());
    }

    protected Boolean getAttribute(String attributeName, Boolean defaultValue) throws CoreException {
        return this._launchConfiguration.getAttribute(attributeName, defaultValue.booleanValue());
    }

    public int getAnimationDelay() {
        return this._animationDelay;
    }

    public URI getExecutedModelURI() {
        return this._modelURI;
    }

    public String getMelangeQuery() {
        return this._melangeQuery;
    }

    public URI getExecutedModelAsMelangeURI() {
        if (this._melangeQuery.isEmpty()) {
            return this._modelURI;
        }
        String melangeURIString = String.valueOf(this._modelURI.toString().replace("platform:/", "melange:/")) + this._melangeQuery;
        return URI.createURI((String)melangeURIString);
    }

    public URI getAnimatorURI() {
        return this._animatorURI;
    }

    public int getDeadlockDetectionDepth() {
        return this._deadlockDetectionDepth;
    }

    public Collection<EngineAddonSpecificationExtension> getEngineAddonExtensions() {
        ArrayList<EngineAddonSpecificationExtension> result = new ArrayList<EngineAddonSpecificationExtension>();
        for (Map.Entry<EngineAddonSpecificationExtension, Boolean> e : this._engineAddonExtensions.entrySet()) {
            if (!e.getValue().booleanValue()) continue;
            result.add(e.getKey());
        }
        return result;
    }

    public String getExecutionEntryPoint() {
        return this._methodEntryPoint;
    }

    public String getModelEntryPoint() {
        return this._modelEntryPoint;
    }

    public String getLanguageName() {
        return this._languageName;
    }

    public String getModelInitializationMethod() {
        return this._modelInitializationMethod;
    }

    public String getModelInitializationArguments() {
        return this._modelInitializationArguments;
    }

    public boolean getBreakStart() {
        return this._breakStart;
    }

    public String getDebugModelID() {
        return this._debugModelID;
    }
}

