/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.refresh;

import com.google.common.base.Predicate;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.EndOfLife;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.util.BendpointsHelper;
import org.eclipse.sirius.diagram.ui.tools.internal.util.NotificationQuery;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class RefreshLayoutScope
implements Predicate<Notification> {
    private final Predicate<Notification> isLayoutConstraintNotationChange = new Predicate<Notification>(){
        Object[] features = new Object[]{NotationPackage.eINSTANCE.getRelativeBendpoints_Points(), NotationPackage.eINSTANCE.getLocation_Y(), NotationPackage.eINSTANCE.getLocation_X(), NotationPackage.eINSTANCE.getSize_Width(), NotationPackage.eINSTANCE.getSize_Height()};

        public boolean apply(Notification input) {
            boolean isLayout = false;
            Object feature = input.getFeature();
            Object[] objectArray = this.features;
            int n = this.features.length;
            int n2 = 0;
            while (n2 < n) {
                Object feature2 = objectArray[n2];
                if (feature == feature2) {
                    isLayout = true;
                    break;
                }
                ++n2;
            }
            return isLayout;
        }
    };
    private final Predicate<Notification> isSructuralNotationChange = new Predicate<Notification>(){
        int[] types = new int[]{3, 5, 7, 4, 6};

        public boolean apply(Notification input) {
            return this.isStructural(input.getEventType());
        }

        private boolean isStructural(int eventType) {
            int[] nArray = this.types;
            int n = this.types.length;
            int n2 = 0;
            while (n2 < n) {
                int type = nArray[n2];
                if (eventType == type) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    };

    public boolean apply(Notification input) {
        return !input.isTouch() && this.needLayout(input);
    }

    private boolean needLayout(Notification notification) {
        if (this.isSequenceChange(notification)) {
            return !this.isLayoutTouch(notification) && (this.containsStructuralNotationChanges(notification) || this.containsLayoutConstraintNotationChanges(notification));
        }
        return this.containsSetWkpImgApplication(notification);
    }

    private boolean isSequenceChange(Notification input) {
        return new NotificationQuery(input).isNotationChange() && this.isSequenceElementChange(input);
    }

    private boolean isSequenceElementChange(Notification notification) {
        Object value;
        boolean isSequenceElement = false;
        Object notifier = notification.getNotifier();
        View view = this.getView(notifier);
        boolean bl = isSequenceElement = view != null && ISequenceElementAccessor.isPartOfSequenceElement(view);
        if (isSequenceElement && (value = this.getValue(notification)) != null) {
            boolean valueIsSequenceElt = false;
            if (value instanceof EObject) {
                view = this.getView(value);
                valueIsSequenceElt = view == null || ISequenceElementAccessor.isPartOfSequenceElement(view);
            } else if (value instanceof Collection) {
                Collection values = (Collection)value;
                for (Object val : values) {
                    view = this.getView(val);
                    if (view != null && !ISequenceElementAccessor.isPartOfSequenceElement(view)) continue;
                    valueIsSequenceElt = true;
                    break;
                }
            }
            isSequenceElement = valueIsSequenceElt;
        }
        return isSequenceElement;
    }

    private Object getValue(Notification notification) {
        Object value = null;
        Object newValue = notification.getNewValue();
        if (newValue instanceof EObject || newValue instanceof Collection) {
            value = newValue;
        } else {
            Object oldValue = notification.getOldValue();
            if (oldValue instanceof EObject || oldValue instanceof Collection) {
                value = oldValue;
            }
        }
        return value;
    }

    private View getView(Object notifier) {
        View view = null;
        if (notifier instanceof EObject) {
            if (notifier instanceof View) {
                view = (View)notifier;
            } else if (((EObject)notifier).eContainer() instanceof View) {
                view = (View)((EObject)notifier).eContainer();
            }
        }
        return view;
    }

    private boolean containsLayoutConstraintNotationChanges(Notification notification) {
        return this.isLayoutConstraintNotationChange.apply((Object)notification);
    }

    private boolean containsStructuralNotationChanges(Notification notification) {
        return this.isSructuralNotationChange.apply((Object)notification);
    }

    private boolean isLayoutTouch(Notification notification) {
        boolean isLayoutTouch = false;
        if (NotationPackage.eINSTANCE.getRelativeBendpoints_Points().equals(notification.getFeature())) {
            isLayoutTouch = BendpointsHelper.areSameBendpoints(notification.getOldValue(), notification.getNewValue());
        }
        return isLayoutTouch;
    }

    private boolean containsSetWkpImgApplication(Notification notification) {
        boolean newStyle = false;
        boolean wkpImageCustomization = false;
        boolean wkpImageDeCustomization = false;
        if (notification.getEventType() == 1 && DiagramPackage.eINSTANCE.getDNode_OwnedStyle().equals(notification.getFeature()) && this.hasSequenceMapping(notification.getNotifier())) {
            newStyle = true;
        } else if (ViewpointPackage.eINSTANCE.getCustomizable_CustomFeatures().equals(notification.getFeature()) && notification.getNotifier() instanceof WorkspaceImage) {
            WorkspaceImage workspaceImage = (WorkspaceImage)notification.getNotifier();
            wkpImageCustomization = !workspaceImage.getCustomFeatures().isEmpty();
            boolean bl = wkpImageDeCustomization = !wkpImageCustomization;
        }
        return newStyle && (wkpImageCustomization || wkpImageDeCustomization);
    }

    private boolean hasSequenceMapping(Object notifier) {
        if (notifier instanceof DDiagramElement) {
            DDiagramElement dde = (DDiagramElement)notifier;
            return AbstractNodeEvent.viewpointElementPredicate().apply((Object)dde) || EndOfLife.viewpointElementPredicate().apply((Object)dde) || InstanceRole.viewpointElementPredicate().apply((Object)dde);
        }
        return false;
    }
}

