/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.engine.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gemoc.executionframework.engine.Activator;
import org.eclipse.gemoc.executionframework.engine.core.AbstractExecutionEngine;
import org.eclipse.gemoc.executionframework.event.manager.EventManager;
import org.eclipse.gemoc.executionframework.event.manager.IEventManager;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericSequentialStep;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenerictraceFactory;
import org.eclipse.gemoc.trace.commons.model.trace.GenericMSE;
import org.eclipse.gemoc.trace.commons.model.trace.MSE;
import org.eclipse.gemoc.trace.commons.model.trace.MSEModel;
import org.eclipse.gemoc.trace.commons.model.trace.MSEOccurrence;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.commons.model.trace.TraceFactory;
import org.eclipse.gemoc.trace.gemoc.api.IMultiDimensionalTraceAddon;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionContext;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;

public abstract class AbstractSequentialExecutionEngine
extends AbstractExecutionEngine
implements IExecutionEngine {
    private MSEModel _actionModel;
    private IMultiDimensionalTraceAddon<?, ?, ?, ?, ?> traceAddon;
    private IEventManager eventManager;

    protected abstract void executeEntryPoint();

    protected abstract void initializeModel();

    protected abstract void prepareEntryPoint(IExecutionContext var1);

    protected abstract void prepareInitializeModel(IExecutionContext var1);

    @Override
    public final void performInitialize(IExecutionContext executionContext) {
        Set<IMultiDimensionalTraceAddon> traceManagers = this.getAddonsTypedBy(IMultiDimensionalTraceAddon.class);
        if (!traceManagers.isEmpty()) {
            this.traceAddon = traceManagers.iterator().next();
        }
        this.eventManager = new EventManager();
        this.getExecutionContext().getExecutionPlatform().addEngineAddon((IEngineAddon)this.eventManager);
        this.prepareEntryPoint(executionContext);
        this.prepareInitializeModel(executionContext);
    }

    @Override
    protected final void performStart() {
        this.initializeModel();
        this.notifyEngineInitialized();
        this.executeEntryPoint();
        Activator.getDefault().info("Execution finished");
    }

    private void manageEvents() {
        if (this.eventManager != null) {
            this.eventManager.processEvents();
        }
    }

    @Override
    protected final void afterExecutionStep() {
        this.manageEvents();
        super.afterExecutionStep();
    }

    protected final void beforeExecutionStep(Object caller, String className, String operationName) {
        RecordingCommand rc = new RecordingCommand((TransactionalEditingDomain)this.editingDomain){

            protected void doExecute() {
            }
        };
        this.beforeExecutionStep(caller, className, operationName, rc);
        rc.execute();
    }

    protected final void beforeExecutionStep(Object caller, String className, String operationName, RecordingCommand rc) {
        if (caller != null && caller instanceof EObject && this.editingDomain != null) {
            EObject callerCast = (EObject)caller;
            Step<?> step = this.createStep(callerCast, className, operationName);
            this.manageEvents();
            this.beforeExecutionStep(step, rc);
        }
    }

    private Step<?> createStep(EObject caller, String className, String methodName) {
        Step result;
        MSE mse = this.findOrCreateMSE(caller, className, methodName);
        if (this.traceAddon == null) {
            GenericSequentialStep step = GenerictraceFactory.eINSTANCE.createGenericSequentialStep();
            MSEOccurrence occurrence = null;
            occurrence = TraceFactory.eINSTANCE.createMSEOccurrence();
            step.setMseoccurrence(occurrence);
            occurrence.setMse(mse);
            result = step;
        } else {
            result = this.traceAddon.getFactory().createStep(mse, new ArrayList(), new ArrayList());
        }
        return result;
    }

    private EOperation findOperation(EObject object, String className, String methodName) {
        for (EOperation operation : object.eClass().getEAllOperations()) {
            if (!operation.getName().equalsIgnoreCase(methodName)) continue;
            return operation;
        }
        EClass containingEClass = null;
        if (object.eClass().getName().equalsIgnoreCase(className)) {
            containingEClass = object.eClass();
        } else {
            for (EClass candidate : object.eClass().getEAllSuperTypes()) {
                if (!candidate.getName().equalsIgnoreCase(className)) continue;
                containingEClass = candidate;
            }
        }
        EOperation operation = EcoreFactory.eINSTANCE.createEOperation();
        if (containingEClass != null) {
            containingEClass.getEOperations().add((Object)operation);
        }
        operation.setName(methodName);
        return operation;
    }

    public final MSE findOrCreateMSE(EObject caller, String className, String methodName) {
        EOperation operation = this.findOperation(caller, className, methodName);
        if (this._actionModel == null) {
            this._actionModel = TraceFactory.eINSTANCE.createMSEModel();
        }
        if (this._actionModel != null) {
            for (MSE existingMSE : this._actionModel.getOwnedMSEs()) {
                if (!existingMSE.getCaller().equals(caller) || (existingMSE.getAction() == null || !existingMSE.getAction().equals(operation)) && (existingMSE.getAction() != null || operation != null)) continue;
                return existingMSE;
            }
        }
        final GenericMSE mse = TraceFactory.eINSTANCE.createGenericMSE();
        mse.setCallerReference(caller);
        mse.setActionReference(operation);
        if (operation != null) {
            mse.setName("MSE_" + caller.getClass().getSimpleName() + "_" + operation.getName());
        } else {
            mse.setName("MSE_" + caller.getClass().getSimpleName() + "_" + methodName);
        }
        if (this._actionModel != null) {
            if (this._actionModel.eResource() != null) {
                TransactionUtil.getEditingDomain((Resource)this._actionModel.eResource());
                RecordingCommand command = new RecordingCommand(TransactionUtil.getEditingDomain((Resource)this._actionModel.eResource()), "Saving new MSE "){

                    protected void doExecute() {
                        AbstractSequentialExecutionEngine.this._actionModel.getOwnedMSEs().add((Object)mse);
                        try {
                            AbstractSequentialExecutionEngine.this._actionModel.eResource().save(null);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                };
                TransactionUtil.getEditingDomain((Resource)this._actionModel.eResource()).getCommandStack().execute((Command)command);
            }
        } else {
            this._actionModel.getOwnedMSEs().add((Object)mse);
        }
        return mse;
    }

    @Override
    protected void beforeStart() {
    }

    @Override
    protected void performStop() {
    }

    @Override
    protected void finishDispose() {
    }
}

