/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.provisional.search;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.pde.api.tools.internal.AntFilterStore;
import org.eclipse.pde.api.tools.internal.builder.ReferenceResolver;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiTypeContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiScope;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchReporter;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchRequestor;
import org.eclipse.pde.api.tools.internal.search.SearchMessages;

public final class ApiSearchEngine {
    public static final IReference[] NO_REFERENCES = new IReference[0];
    private String fRequestorContext = null;

    List<IReference> getResolvedReferences(IApiSearchRequestor requestor, IApiType type, IProgressMonitor monitor) throws CoreException {
        String name = type.getSimpleName() == null ? SearchMessages.ApiSearchEngine_anonymous_type : type.getSimpleName();
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format((String)SearchMessages.ApiSearchEngine_extracting_refs_from, (Object[])new Object[]{name}), (int)2);
        List<IReference> refs = type.extractReferences(requestor.getReferenceKinds(), (IProgressMonitor)localmonitor.split(1));
        ReferenceResolver.resolveReferences(refs, (IProgressMonitor)localmonitor.split(1));
        return refs;
    }

    List<IReference> acceptReferences(IApiSearchRequestor requestor, IApiType type, List<IReference> references, IProgressMonitor monitor) throws CoreException {
        ArrayList<IReference> refs = new ArrayList<IReference>();
        IReference ref = null;
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)references.size());
        IApiMember member = null;
        Iterator<IReference> iter = references.iterator();
        while (iter.hasNext()) {
            if (localmonitor.isCanceled()) {
                return Collections.EMPTY_LIST;
            }
            ref = iter.next();
            member = ref.getResolvedReference();
            if (member == null) continue;
            localmonitor.setTaskName(MessageFormat.format((String)SearchMessages.ApiSearchEngine_searching_for_use_from, (Object[])new Object[]{this.fRequestorContext, type.getName()}));
            if (requestor.acceptReference(ref)) {
                refs.add(ref);
            }
            localmonitor.worked(1);
        }
        return refs;
    }

    private void searchReferences(IApiSearchRequestor requestor, IApiElement element, IApiSearchReporter reporter, IProgressMonitor monitor) throws CoreException {
        List<IReference> refs = null;
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        try {
            switch (element.getType()) {
                case 2: {
                    if (localmonitor.isCanceled()) {
                        reporter.reportResults(element, NO_REFERENCES);
                    }
                    IApiType type = (IApiType)element;
                    refs = this.acceptReferences(requestor, type, this.getResolvedReferences(requestor, type, (IProgressMonitor)localmonitor.split(1)), (IProgressMonitor)localmonitor.split(1));
                    reporter.reportResults(element, refs.toArray(new IReference[refs.size()]));
                    break;
                }
                case 1: {
                    if (localmonitor.isCanceled()) {
                        reporter.reportResults(element, NO_REFERENCES);
                    }
                    ReferenceExtractor visitor = new ReferenceExtractor(requestor, reporter, element, (IProgressMonitor)localmonitor.split(1));
                    IApiComponent comp = (IApiComponent)element;
                    comp.accept(visitor);
                    comp.close();
                    localmonitor.split(1);
                    break;
                }
                case 5: 
                case 6: {
                    IApiMember member;
                    IApiType type;
                    if (localmonitor.isCanceled()) {
                        reporter.reportResults(element, NO_REFERENCES);
                    }
                    if ((type = (member = (IApiMember)element).getEnclosingType()) != null) {
                        refs = this.acceptReferences(requestor, type, this.getResolvedReferences(requestor, type, (IProgressMonitor)localmonitor.split(1)), (IProgressMonitor)localmonitor.split(1));
                    }
                    if (refs == null) break;
                    reporter.reportResults(element, refs.toArray(new IReference[refs.size()]));
                    break;
                }
            }
            localmonitor.split(1);
        }
        finally {
            localmonitor.done();
        }
    }

    public void search(IApiBaseline baseline, IApiSearchRequestor requestor, IApiSearchReporter reporter, IProgressMonitor monitor) throws CoreException {
        if (baseline == null || reporter == null || requestor == null) {
            return;
        }
        IApiScope scope = requestor.getScope();
        if (scope == null) {
            return;
        }
        AntFilterStore.filteredAPIProblems.clear();
        this.fRequestorContext = this.computeContext(requestor);
        IApiElement[] scopeelements = scope.getApiElements();
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format((String)SearchMessages.ApiSearchEngine_searching_projects, (Object[])new Object[]{this.fRequestorContext}), (int)(scopeelements.length * 2 + 1));
        try {
            long start = System.currentTimeMillis();
            long loopstart = 0L;
            String taskname = null;
            MultiStatus mstatus = null;
            int i = 0;
            while (i < scopeelements.length) {
                block15: {
                    taskname = MessageFormat.format((String)SearchMessages.ApiSearchEngine_searching_project, (Object[])new Object[]{scopeelements[i].getApiComponent().getSymbolicName(), this.fRequestorContext});
                    localmonitor.setTaskName(taskname);
                    if (ApiPlugin.DEBUG_SEARCH_ENGINE) {
                        loopstart = System.currentTimeMillis();
                        System.out.println("Searching " + scopeelements[i].getApiComponent().getSymbolicName() + "...");
                    }
                    this.searchReferences(requestor, scopeelements[i], reporter, (IProgressMonitor)localmonitor.split(1));
                    localmonitor.setTaskName(taskname);
                    if (!localmonitor.isCanceled()) break block15;
                    reporter.reportResults(scopeelements[i], NO_REFERENCES);
                    return;
                }
                try {
                    localmonitor.worked(1);
                    if (ApiPlugin.DEBUG_SEARCH_ENGINE) {
                        System.out.println(String.valueOf(Math.round((float)(i + 1) / (float)scopeelements.length * 100.0f)) + "% done in " + (System.currentTimeMillis() - loopstart) + " ms");
                    }
                }
                catch (CoreException ce) {
                    if (mstatus == null) {
                        mstatus = new MultiStatus("org.eclipse.pde.api.tools", 4, null, null);
                    }
                    mstatus.add((IStatus)new Status(4, "org.eclipse.pde.api.tools", ce.getMessage(), (Throwable)ce));
                }
                ++i;
            }
            if (ApiPlugin.DEBUG_SEARCH_ENGINE) {
                System.out.println("Total Search Time: " + (System.currentTimeMillis() - start) / 1000L + " seconds");
            }
            if (mstatus != null) {
                throw new CoreException(mstatus);
            }
        }
        finally {
            localmonitor.done();
        }
    }

    String computeContext(IApiSearchRequestor requestor) {
        String context = SearchMessages.ApiSearchEngine_api_internal;
        if (requestor.includesAPI()) {
            if (requestor.includesInternal()) {
                if (requestor.includesIllegalUse()) {
                    return context;
                }
                context = SearchMessages.ApiSearchEngine_api_and_internal;
            } else {
                context = !requestor.includesIllegalUse() ? SearchMessages.ApiSearchEngine_api : SearchMessages.ApiSearchEngine_api_and_illegal;
            }
        } else if (requestor.includesInternal()) {
            context = requestor.includesIllegalUse() ? SearchMessages.ApiSearchEngine_internal_and_illegal : SearchMessages.ApiSearchEngine_internal;
        } else if (requestor.includesIllegalUse()) {
            context = SearchMessages.ApiSearchEngine_illegal;
        }
        return context;
    }

    class ReferenceExtractor
    extends ApiTypeContainerVisitor {
        static final int COLLECTOR_MAX = 2500;
        private List<IReference> collector = new ArrayList<IReference>();
        private IApiSearchRequestor requestor = null;
        private IApiSearchReporter reporter = null;
        IApiElement element = null;
        private SubMonitor monitor = null;

        public ReferenceExtractor(IApiSearchRequestor requestor, IApiSearchReporter reporter, IApiElement element, IProgressMonitor monitor) {
            this.requestor = requestor;
            this.reporter = reporter;
            this.element = element;
            this.monitor = SubMonitor.convert((IProgressMonitor)monitor);
        }

        @Override
        public boolean visit(IApiTypeContainer container) {
            return this.requestor.acceptContainer(container);
        }

        @Override
        public void visit(String packageName, IApiTypeRoot typeroot) {
            if (this.monitor.isCanceled()) {
                return;
            }
            try {
                IApiType type = typeroot.getStructure();
                if (type == null || !this.requestor.acceptMember(type)) {
                    return;
                }
                this.collector.addAll(ApiSearchEngine.this.acceptReferences(this.requestor, type, ApiSearchEngine.this.getResolvedReferences(this.requestor, type, (IProgressMonitor)this.monitor.split(1)), (IProgressMonitor)this.monitor.split(1)));
            }
            catch (CoreException ce) {
                ApiPlugin.log(ce);
            }
        }

        @Override
        public void end(String packageName, IApiTypeRoot typeroot) {
            if (this.collector.size() >= 2500) {
                this.reportResults();
            }
        }

        @Override
        public boolean visit(IApiComponent component) {
            return this.requestor.acceptComponent(component);
        }

        @Override
        public void endVisitPackage(String packageName) {
            this.reportResults();
        }

        private void reportResults() {
            this.reporter.reportResults(this.element, this.collector.toArray(new IReference[this.collector.size()]));
            this.collector.clear();
        }
    }
}

