/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.opsemanticsview.gen.k3;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Set;
import opsemanticsview.ExecutionToASEntry;
import opsemanticsview.OperationalSemanticsView;
import opsemanticsview.OpsemanticsviewFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gemoc.xdsmlframework.commons.DynamicAnnotationHelper;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.Pure;

@SuppressWarnings("all")
public class K3DynamicElementsFinder {
  private final EPackage abstractSyntax;
  
  private final EPackage executionMetamodel;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  private OperationalSemanticsView view;
  
  public K3DynamicElementsFinder(final EPackage abstractSyntax, final EPackage executionMetamodel, final OperationalSemanticsView view) {
    this.abstractSyntax = abstractSyntax;
    this.executionMetamodel = executionMetamodel;
    this.view = view;
  }
  
  public void find() {
    this.findDynamicParts();
    boolean _notEquals = (!Objects.equal(this.abstractSyntax, null));
    if (_notEquals) {
      this.findMappingAsToExe();
    }
  }
  
  private void findDynamicParts() {
    TreeIterator<EObject> _eAllContents = this.executionMetamodel.eAllContents();
    Iterator<EClass> _filter = Iterators.<EClass>filter(_eAllContents, EClass.class);
    Set<EClass> _set = IteratorExtensions.<EClass>toSet(_filter);
    for (final EClass c : _set) {
      boolean _isDynamic = DynamicAnnotationHelper.isDynamic(c);
      boolean _not = (!_isDynamic);
      if (_not) {
        EList<EStructuralFeature> _eStructuralFeatures = c.getEStructuralFeatures();
        final Function1<EStructuralFeature, Boolean> _function = new Function1<EStructuralFeature, Boolean>() {
          @Override
          public Boolean apply(final EStructuralFeature p) {
            return Boolean.valueOf(DynamicAnnotationHelper.isDynamic(p));
          }
        };
        final Iterable<EStructuralFeature> mutableProperties = IterableExtensions.<EStructuralFeature>filter(_eStructuralFeatures, _function);
        if (((!Objects.equal(mutableProperties, null)) && (!IterableExtensions.isEmpty(mutableProperties)))) {
          for (final EStructuralFeature p : mutableProperties) {
            EList<EStructuralFeature> _dynamicProperties = this.view.getDynamicProperties();
            _dynamicProperties.add(p);
          }
        }
      } else {
        EList<EClass> _dynamicClasses = this.view.getDynamicClasses();
        _dynamicClasses.add(c);
        EList<EStructuralFeature> _eStructuralFeatures_1 = c.getEStructuralFeatures();
        for (final EStructuralFeature p_1 : _eStructuralFeatures_1) {
          EList<EStructuralFeature> _dynamicProperties_1 = this.view.getDynamicProperties();
          _dynamicProperties_1.add(p_1);
        }
      }
    }
  }
  
  private void findMappingAsToExe() {
    this.explorePackageRecursively(this.abstractSyntax, this.executionMetamodel);
  }
  
  private void explorePackageRecursively(final EPackage asPackage, final EPackage exePackage) {
    EList<EClassifier> _eClassifiers = asPackage.getEClassifiers();
    Iterable<EClass> _filter = Iterables.<EClass>filter(_eClassifiers, EClass.class);
    for (final EClass asClass : _filter) {
      {
        EList<EClassifier> _eClassifiers_1 = exePackage.getEClassifiers();
        Iterable<EClass> _filter_1 = Iterables.<EClass>filter(_eClassifiers_1, EClass.class);
        final Function1<EClass, Boolean> _function = new Function1<EClass, Boolean>() {
          @Override
          public Boolean apply(final EClass exeC) {
            String _name = asClass.getName();
            String _name_1 = exeC.getName();
            return Boolean.valueOf(_name.equals(_name_1));
          }
        };
        final EClass exeClass = IterableExtensions.<EClass>findFirst(_filter_1, _function);
        ExecutionToASEntry _createExecutionToASEntry = OpsemanticsviewFactory.eINSTANCE.createExecutionToASEntry();
        final Procedure1<ExecutionToASEntry> _function_1 = new Procedure1<ExecutionToASEntry>() {
          @Override
          public void apply(final ExecutionToASEntry it) {
            it.setASclass(asClass);
            it.setExecutionClass(exeClass);
          }
        };
        final ExecutionToASEntry mappingEntry = ObjectExtensions.<ExecutionToASEntry>operator_doubleArrow(_createExecutionToASEntry, _function_1);
        EList<ExecutionToASEntry> _executionToASmapping = this.view.getExecutionToASmapping();
        _executionToASmapping.add(mappingEntry);
      }
    }
    EList<EPackage> _eSubpackages = asPackage.getESubpackages();
    for (final EPackage asSubPackage : _eSubpackages) {
      {
        EList<EPackage> _eSubpackages_1 = asPackage.getESubpackages();
        final Function1<EPackage, Boolean> _function = new Function1<EPackage, Boolean>() {
          @Override
          public Boolean apply(final EPackage p) {
            String _name = p.getName();
            String _name_1 = asSubPackage.getName();
            return Boolean.valueOf(_name.equals(_name_1));
          }
        };
        final EPackage exeSubPackage = IterableExtensions.<EPackage>findFirst(_eSubpackages_1, _function);
        this.explorePackageRecursively(asSubPackage, exeSubPackage);
      }
    }
  }
  
  @Pure
  public OperationalSemanticsView getView() {
    return this.view;
  }
  
  protected void setView(final OperationalSemanticsView view) {
    this.view = view;
  }
}
