/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TitleBarStyle implements Enumerator
{
    TITLE_BAR(0, "TITLE_BAR", "TITLE_BAR"),
    SHORT_TITLE_BAR(1, "SHORT_TITLE_BAR", "SHORT_TITLE_BAR"),
    NO_TITLE(2, "NO_TITLE", "NO_TITLE");

    public static final int TITLE_BAR_VALUE = 0;
    public static final int SHORT_TITLE_BAR_VALUE = 1;
    public static final int NO_TITLE_VALUE = 2;
    private static final TitleBarStyle[] VALUES_ARRAY;
    public static final List<TitleBarStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TitleBarStyle[]{TITLE_BAR, SHORT_TITLE_BAR, NO_TITLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TitleBarStyle get(String literal) {
        TitleBarStyle[] titleBarStyleArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            TitleBarStyle result = titleBarStyleArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static TitleBarStyle getByName(String name) {
        TitleBarStyle[] titleBarStyleArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            TitleBarStyle result = titleBarStyleArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static TitleBarStyle get(int value) {
        switch (value) {
            case 0: {
                return TITLE_BAR;
            }
            case 1: {
                return SHORT_TITLE_BAR;
            }
            case 2: {
                return NO_TITLE;
            }
        }
        return null;
    }

    private TitleBarStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

