/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.Arrays;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.registry.EditorRegistry;

class MockMapping
implements IFileEditorMapping {
    private IContentType contentType;
    private String extension;
    private String filename;

    MockMapping(IContentType type, String name, String ext) {
        this.contentType = type;
        this.filename = name;
        this.extension = ext;
    }

    @Override
    public IEditorDescriptor getDefaultEditor() {
        IEditorDescriptor[] candidates = ((EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry()).getEditorsForContentType(this.contentType);
        if (candidates.length == 0 || WorkbenchActivityHelper.restrictUseOf(candidates[0])) {
            return null;
        }
        return candidates[0];
    }

    @Override
    public IEditorDescriptor[] getEditors() {
        Object[] editorsForContentType = ((EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry()).getEditorsForContentType(this.contentType);
        return (IEditorDescriptor[])WorkbenchActivityHelper.restrictArray(editorsForContentType);
    }

    @Override
    public IEditorDescriptor[] getDeletedEditors() {
        return new IEditorDescriptor[0];
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        IEditorDescriptor editor = this.getDefaultEditor();
        if (editor == null) {
            return WorkbenchImages.getImageDescriptor("IMG_OBJ_FILE");
        }
        return editor.getImageDescriptor();
    }

    @Override
    public String getLabel() {
        return String.valueOf(this.filename) + '.' + this.extension;
    }

    @Override
    public String getName() {
        return this.filename;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MockMapping)) {
            return false;
        }
        MockMapping mapping = (MockMapping)obj;
        return this.filename.equals(mapping.filename) && this.extension.equals(mapping.extension) && Arrays.equals(this.getEditors(), mapping.getEditors()) && Arrays.equals(this.getDeletedEditors(), mapping.getDeletedEditors());
    }
}

