/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.timeline.editpart;

import java.util.List;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gemoc.timeline.layout.LineLayout;
import org.eclipse.gemoc.timeline.model.Branch;
import org.eclipse.gemoc.timeline.model.Choice;
import org.eclipse.gemoc.timeline.model.ITimelineWindowListener;
import org.eclipse.gemoc.timeline.model.PossibleStep;
import org.eclipse.gemoc.timeline.model.TimelineWindow;
import org.eclipse.gemoc.timeline.view.ITimelineProvider;
import org.eclipse.swt.widgets.Display;

public class TimelineWindowEditPart
extends AbstractGraphicalEditPart
implements ITimelineWindowListener {
    public static final int SPACING = 10;
    public static final int MARGIN = 10;

    protected IFigure createFigure() {
        LineLayout layout = new LineLayout();
        layout.setHorizontal(false);
        layout.setMajorAlignment(1);
        layout.setMinorAlignment(1);
        layout.setMinorSpacing(10);
        layout.setMargin(10);
        FreeformLayer res = new FreeformLayer();
        res.setLayoutManager((LayoutManager)layout);
        return res;
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.getModel().addTimelineWindowListener(this);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new XYLayoutEditPolicy(){

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        });
    }

    public List<Branch> getModelChildren() {
        return this.getModel().getBranches();
    }

    public TimelineWindow getModel() {
        return (TimelineWindow)super.getModel();
    }

    @Override
    public void startChanged(int branch, int start) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TimelineWindowEditPart.this.deepRefresh();
            }
        });
    }

    @Override
    public void endChanged(int branch, int numberOfChoices) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TimelineWindowEditPart.this.deepRefresh();
            }
        });
    }

    @Override
    public void textAtChanged(final int branch, String text) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                EditPart editPart = (EditPart)TimelineWindowEditPart.this.getViewer().getEditPartRegistry().get(new Branch(TimelineWindowEditPart.this.getModel(), branch));
                editPart.refresh();
            }
        });
    }

    @Override
    public void numberOfPossibleStepsAtChanged(int branch, int index, int numberOfPossibleStep) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TimelineWindowEditPart.this.deepRefresh();
            }
        });
    }

    @Override
    public void textAtChanged(final int branch, final int index, String text) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                EditPart editPart = (EditPart)TimelineWindowEditPart.this.getViewer().getEditPartRegistry().get(new Choice(TimelineWindowEditPart.this.getModel(), branch, index));
                editPart.refresh();
            }
        });
    }

    @Override
    public void atChanged(final int branch, final int index, final int possibleStep, Object object) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                EditPart editPart = (EditPart)TimelineWindowEditPart.this.getViewer().getEditPartRegistry().get(new PossibleStep(TimelineWindowEditPart.this.getModel(), branch, index, possibleStep));
                if (editPart.equals(TimelineWindowEditPart.this.getViewer().getSelectedEditParts())) {
                    TimelineWindowEditPart.this.getViewer().getSelectionManager().deselect(editPart);
                    TimelineWindowEditPart.this.getViewer().getSelectionManager().appendSelection(editPart);
                }
            }
        });
    }

    @Override
    public void isSelectedChanged(int branch, int index, int possibleStep, boolean selected) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TimelineWindowEditPart.this.deepRefresh();
            }
        });
    }

    @Override
    public void textAtChanged(final int branch, final int index, final int possibleStep, String text) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                EditPart editPart = (EditPart)TimelineWindowEditPart.this.getViewer().getEditPartRegistry().get(new PossibleStep(TimelineWindowEditPart.this.getModel(), branch, index, possibleStep));
                editPart.refresh();
            }
        });
    }

    @Override
    public void followingsChanged(int branch, int index, int possibleStep, int[][] followings) {
    }

    @Override
    public void precedingsChanged(int branch, int index, int possibleStep, int[][] precedings) {
    }

    @Override
    public synchronized void startChanged(int start) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TimelineWindowEditPart.this.deepRefresh();
            }
        });
    }

    @Override
    public synchronized void lengthChanged(int length) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TimelineWindowEditPart.this.deepRefresh();
            }
        });
    }

    @Override
    public void providerChanged(ITimelineProvider provider) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TimelineWindowEditPart.this.deepRefresh();
            }
        });
    }

    private void deepRefresh() {
        this.refresh();
        for (Branch branch : this.getModelChildren()) {
            EditPart branchEditPart = (EditPart)this.getViewer().getEditPartRegistry().get(branch);
            branchEditPart.refresh();
            for (Choice choice : branch.getChoices()) {
                EditPart choiceEditPart = (EditPart)this.getViewer().getEditPartRegistry().get(choice);
                choiceEditPart.refresh();
                for (PossibleStep possibleStep : choice.getPossibleSteps()) {
                    EditPart possibleStepEditPart = (EditPart)this.getViewer().getEditPartRegistry().get(possibleStep);
                    possibleStepEditPart.refresh();
                }
            }
        }
    }
}

