/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.engine.ui.launcher.tabs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.gemoc.executionframework.engine.core.RunConfiguration;
import org.eclipse.gemoc.executionframework.engine.ui.Activator;
import org.eclipse.gemoc.executionframework.engine.ui.launcher.tabs.AbstractLaunchConfigurationTab;
import org.eclipse.gemoc.executionframework.engine.ui.launcher.tabs.EngineAddonLaunchConfigWidget;
import org.eclipse.gemoc.executionframework.engine.ui.launcher.tabs.ILaunchLanguageSelectionListener;
import org.eclipse.gemoc.executionframework.engine.ui.launcher.tabs.LaunchConfUtils;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;
import org.eclipse.gemoc.xdsmlframework.api.extensions.engine_addon.EngineAddonSpecificationExtension;
import org.eclipse.gemoc.xdsmlframework.api.extensions.engine_addon_group.EngineAddonGroupSpecificationExtension;
import org.eclipse.gemoc.xdsmlframework.api.extensions.languages.LanguageDefinitionExtension;
import org.eclipse.gemoc.xdsmlframework.api.extensions.languages.LanguageDefinitionExtensionPoint;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractLaunchConfigurationDataProcessingTab
extends AbstractLaunchConfigurationTab
implements ILaunchLanguageSelectionListener {
    private HashMap<EngineAddonSpecificationExtension, EngineAddonLaunchConfigWidget> _components = new HashMap();
    private HashMap<EngineAddonSpecificationExtension, EngineAddonLaunchConfigWidget> _languageSpecificComponents = new HashMap();
    protected String _currentLanguageName;
    protected Group _languageSpecificGroup;
    protected Composite groupParent;

    protected AbstractLaunchConfigurationDataProcessingTab() {
        for (EngineAddonSpecificationExtension extension : this.getExtensionSpecifications()) {
            this._components.put(extension, null);
        }
    }

    protected abstract Collection<EngineAddonSpecificationExtension> getExtensionSpecifications();

    protected abstract Collection<EngineAddonGroupSpecificationExtension> getGroupExtensionSpecifications();

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        content.setLayout((Layout)gl);
        content.layout();
        this.setControl((Control)content);
        this.createLayout(content);
    }

    private void createLayout(Composite parent) {
        HashMap<String, Group> groupmap = new HashMap<String, Group>();
        for (EngineAddonGroupSpecificationExtension engineAddonGroupSpecificationExtension : this.getGroupExtensionSpecifications()) {
            String gname = engineAddonGroupSpecificationExtension.getName() != null ? engineAddonGroupSpecificationExtension.getName() : engineAddonGroupSpecificationExtension.getId();
            groupmap.put(engineAddonGroupSpecificationExtension.getId(), LaunchConfUtils.createGroup(parent, gname, 2));
        }
        this.groupParent = parent;
        groupmap.put("", LaunchConfUtils.createGroup(this.groupParent, "", 2));
        for (EngineAddonSpecificationExtension engineAddonSpecificationExtension : this._components.keySet()) {
            Group parentGroup = (Group)groupmap.get("");
            String addonGroupId = engineAddonSpecificationExtension.getAddonGroupId();
            if (addonGroupId != null && (parentGroup = (Group)groupmap.get(engineAddonSpecificationExtension.getAddonGroupId())) == null) {
                parentGroup = (Group)groupmap.get("");
            }
            EngineAddonLaunchConfigWidget addonWidget = new EngineAddonLaunchConfigWidget(this, (Composite)parentGroup, engineAddonSpecificationExtension);
            this._components.put(engineAddonSpecificationExtension, addonWidget);
        }
        this.createLanguageSpecificGroup(this.groupParent);
        for (Group group : groupmap.values()) {
            if (group.getChildren().length != 0) continue;
            group.dispose();
            parent.layout(true);
        }
    }

    protected void createLanguageSpecificGroup(Composite parent) {
        if (this._languageSpecificGroup == null && this._currentLanguageName != null && !this._currentLanguageName.isEmpty()) {
            this._languageSpecificGroup = LaunchConfUtils.createGroup(parent, this._currentLanguageName, 2);
            LanguageDefinitionExtension langDefExtension = LanguageDefinitionExtensionPoint.findDefinition((String)this._currentLanguageName);
            if (langDefExtension != null) {
                for (EngineAddonSpecificationExtension extension : langDefExtension.getLanguageSpecificEngineAddonSpecificationExtensions()) {
                    EngineAddonLaunchConfigWidget addonWidget = new EngineAddonLaunchConfigWidget(this, (Composite)this._languageSpecificGroup, extension);
                    this._languageSpecificComponents.put(extension, addonWidget);
                }
            }
            if (this._languageSpecificGroup.getChildren().length == 0) {
                this._languageSpecificGroup.dispose();
                parent.layout(true);
                this._languageSpecificGroup = null;
            }
        }
    }

    protected Button createComponentForExtension(Composite parentGroup, EngineAddonSpecificationExtension extension) {
        if (extension.getAddonBooleanOptionsIds().isEmpty()) {
            extension.getAddonStringOptionsIds().isEmpty();
        }
        Button checkbox = this.createCheckButton(parentGroup, String.valueOf(extension.getName()) + ":");
        checkbox.setToolTipText(String.valueOf(extension.getId()) + " contributed by " + extension.getContributorName());
        checkbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractLaunchConfigurationDataProcessingTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        String desc = extension.getShortDescription() != null ? extension.getShortDescription() : "";
        LaunchConfUtils.createTextLabelLayout(parentGroup, desc, "contributed by " + extension.getContributorName());
        return checkbox;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        String extensionName;
        for (EngineAddonSpecificationExtension entry : this._components.keySet()) {
            extensionName = entry.getName() != null ? entry.getName() : entry.getId();
            configuration.setAttribute(extensionName, (Object)entry.getDefaultActivationValue());
        }
        for (EngineAddonSpecificationExtension entry : this._languageSpecificComponents.keySet()) {
            extensionName = entry.getName() != null ? entry.getName() : entry.getId();
            configuration.setAttribute(extensionName, (Object)entry.getDefaultActivationValue());
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        for (EngineAddonSpecificationExtension extension : this._components.keySet()) {
            try {
                String extensionName = extension.getName() != null ? extension.getName() : extension.getId();
                boolean value = configuration.getAttribute(extensionName, false);
                EngineAddonLaunchConfigWidget configWidget = this._components.get(extension);
                Button checkbox = configWidget.mainCheckButton;
                checkbox.setSelection(value);
                configWidget.setOptionsEnabled(value);
                configWidget.optionInitializeFrom(configuration);
            }
            catch (CoreException e) {
                Activator.error(e.getMessage(), e);
            }
        }
        try {
            RunConfiguration gemocRunConf = new RunConfiguration(configuration);
            this._currentLanguageName = gemocRunConf.getLanguageName();
            this.createLanguageSpecificGroup(this.groupParent);
            Set<EngineAddonSpecificationExtension> languageSpecificEngineAddonSpecificationExtensions = this._languageSpecificComponents.keySet();
            for (EngineAddonSpecificationExtension extension : languageSpecificEngineAddonSpecificationExtensions) {
                try {
                    String extensionName = extension.getName() != null ? extension.getName() : extension.getId();
                    boolean value = configuration.getAttribute(extensionName, extension.getDefaultActivationValue().booleanValue());
                    EngineAddonLaunchConfigWidget configWidget = this._languageSpecificComponents.get(extension);
                    Button checkbox = configWidget.mainCheckButton;
                    checkbox.setSelection(value);
                    configWidget.setOptionsEnabled(value);
                    configWidget.optionInitializeFrom(configuration);
                }
                catch (CoreException e) {
                    Activator.error(e.getMessage(), e);
                }
            }
        }
        catch (CoreException e) {
            Activator.error(e.getMessage(), e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String extensionName;
        for (Map.Entry<EngineAddonSpecificationExtension, EngineAddonLaunchConfigWidget> entry : this._components.entrySet()) {
            extensionName = entry.getKey().getName() != null ? entry.getKey().getName() : entry.getKey().getId();
            configuration.setAttribute(extensionName, entry.getValue().mainCheckButton.getSelection());
            entry.getValue().optionsPerformApply(configuration);
        }
        for (Map.Entry<EngineAddonSpecificationExtension, EngineAddonLaunchConfigWidget> entry : this._languageSpecificComponents.entrySet()) {
            extensionName = entry.getKey().getName() != null ? entry.getKey().getName() : entry.getKey().getId();
            configuration.setAttribute(extensionName, entry.getValue().mainCheckButton.getSelection());
            entry.getValue().optionsPerformApply(configuration);
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        try {
            ArrayList<IEngineAddon> addons = new ArrayList<IEngineAddon>();
            for (Map.Entry<EngineAddonSpecificationExtension, EngineAddonLaunchConfigWidget> entry : this._components.entrySet()) {
                if (!entry.getValue().mainCheckButton.getSelection()) continue;
                addons.add(entry.getKey().instanciateComponent());
            }
            for (Map.Entry<EngineAddonSpecificationExtension, EngineAddonLaunchConfigWidget> entry : this._languageSpecificComponents.entrySet()) {
                if (!entry.getValue().mainCheckButton.getSelection()) continue;
                addons.add(entry.getKey().instanciateComponent());
            }
            ArrayList errors = new ArrayList();
            for (IEngineAddon iEngineAddon : addons) {
                errors.addAll(iEngineAddon.validate(addons));
            }
            if (!errors.isEmpty()) {
                for (String msg : errors) {
                    this.setErrorMessage(msg);
                }
                return false;
            }
        }
        catch (Exception e) {
            Activator.error(e.getMessage(), e);
        }
        this.setErrorMessage(null);
        return true;
    }

    @Override
    public void languageChanged(String newLanguageName) {
        if (this._currentLanguageName != null && !this._currentLanguageName.equals(newLanguageName) && newLanguageName != null && !newLanguageName.isEmpty()) {
            if (this._languageSpecificGroup != null) {
                this._languageSpecificGroup.dispose();
                this.groupParent.layout(true);
                this._languageSpecificGroup = null;
            }
            this._languageSpecificComponents.clear();
            this._currentLanguageName = newLanguageName;
            this.createLanguageSpecificGroup(this.groupParent);
            this.groupParent.layout(true);
        }
    }

    public void updateTab() {
        this.updateLaunchConfigurationDialog();
    }
}

