/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.editor.properties.ViewpointPropertySheetPage;
import org.eclipse.sirius.editor.properties.sections.common.AbstractViewpointPropertySection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractCheckBoxGroupPropertySection
extends AbstractViewpointPropertySection {
    protected Button[] button;
    protected CLabel nameLabel;
    protected Composite composite;
    protected boolean buttonGroup = true;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        FormData data;
        String buttonText;
        Iterator<?> iterator;
        if (aTabbedPropertySheetPage instanceof ViewpointPropertySheetPage) {
            super.createControls(parent, (ViewpointPropertySheetPage)aTabbedPropertySheetPage);
        } else {
            super.createControls(parent, aTabbedPropertySheetPage);
        }
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        List<?> values = this.getChoiceOfValues();
        this.button = new Button[values.size()];
        int index = 0;
        if (this.buttonGroup) {
            Group group = this.getWidgetFactory().createGroup(this.composite, this.getLabelText());
            group.setLayout((Layout)new RowLayout(256));
            iterator = values.iterator();
            while (iterator.hasNext()) {
                buttonText = iterator.next().toString();
                this.button[index] = this.getWidgetFactory().createButton((Composite)group, buttonText, 32);
                ++index;
            }
            data = new FormData();
            data.left = new FormAttachment(0, 232);
            group.setLayoutData((Object)data);
        } else {
            int buttonWidthPercentage = 100 / (values.size() + 1);
            iterator = values.iterator();
            while (iterator.hasNext()) {
                buttonText = iterator.next().toString();
                this.button[index] = this.getWidgetFactory().createButton(this.composite, buttonText, 32);
                data = new FormData();
                if (index == 0) {
                    data.left = new FormAttachment(buttonWidthPercentage, 0);
                    data.right = new FormAttachment(2 * buttonWidthPercentage, -20);
                    data.top = new FormAttachment(0, 4);
                } else {
                    data.left = new FormAttachment((Control)this.button[index - 1], 0);
                    data.right = new FormAttachment((index + 2) * buttonWidthPercentage, -20);
                    data.top = new FormAttachment((Control)this.button[index - 1], 0, 0x1000000);
                }
                this.button[index].setLayoutData((Object)data);
                ++index;
            }
            this.nameLabel = this.getWidgetFactory().createCLabel(this.composite, this.getLabelText());
            data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment((Control)this.button[0], -5);
            data.top = new FormAttachment((Control)this.button[0], 0, 0x1000000);
            this.nameLabel.setLayoutData((Object)data);
        }
        int i = 0;
        while (i < this.button.length) {
            int buttonIndex = i++;
            this.button[buttonIndex].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractCheckBoxGroupPropertySection.this.handleSelectionChanged();
                }
            });
        }
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "org.eclipse.sirius." + this.eObject.eClass().getName());
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.nameLabel.setText(this.getLabelText());
    }

    public void handleSelectionChanged() {
        boolean equals = this.isEqual(this.getSelectedValues());
        if (!equals) {
            EditingDomain editingDomain = ((IEditingDomainProvider)this.getPart()).getEditingDomain();
            List<?> value = this.getSelectedValues();
            if (this.eObjectList.size() == 1) {
                editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)this.eObject, (Object)this.getFeature(), value));
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (EObject nextObject : this.eObjectList) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)this.getFeature(), value));
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    protected List<?> getSelectedValues() {
        List<?> possibleValues = this.getChoiceOfValues();
        ArrayList selectedValues = new ArrayList();
        int i = 0;
        while (i < this.button.length) {
            if (this.button[i].getSelection()) {
                selectedValues.add(possibleValues.get(i));
            }
            ++i;
        }
        return selectedValues;
    }

    public void refresh() {
        Object[] values = this.getFeatureAsText().split(", ");
        Arrays.sort(values);
        Button[] buttonArray = this.button;
        int n = this.button.length;
        int n2 = 0;
        while (n2 < n) {
            Button element = buttonArray[n2];
            if (Arrays.binarySearch(values, element.getText()) >= 0) {
                element.setSelection(true);
            } else {
                element.setSelection(false);
            }
            ++n2;
        }
    }

    protected abstract boolean isEqual(List<?> var1);

    protected abstract List<?> getChoiceOfValues();

    @Override
    protected abstract EStructuralFeature getFeature();

    protected String getDefaultFeatureAsText() {
        String value = new String();
        if (this.eObject.eGet(this.getFeature()) != null) {
            value = this.eObject.eGet(this.getFeature()).toString();
        }
        return value;
    }

    protected String getFeatureAsText() {
        EStructuralFeature eFeature = this.getFeature();
        IItemPropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(eFeature);
        if (propertyDescriptor != null) {
            return propertyDescriptor.getLabelProvider((Object)this.eObject).getText(this.eObject.eGet(eFeature));
        }
        return this.getDefaultFeatureAsText();
    }

    protected abstract String getDefaultLabelText();

    protected String getLabelText() {
        EStructuralFeature eFeature;
        IItemPropertyDescriptor propertyDescriptor;
        if (this.eObject != null && (propertyDescriptor = this.getPropertyDescriptor(eFeature = this.getFeature())) != null) {
            return propertyDescriptor.getDisplayName((Object)this.eObject);
        }
        return this.getDefaultLabelText();
    }

    @Override
    protected void makeReadonly() {
        Button[] buttonArray = this.button;
        int n = this.button.length;
        int n2 = 0;
        while (n2 < n) {
            Button element = buttonArray[n2];
            element.setEnabled(false);
            ++n2;
        }
    }

    @Override
    protected void makeWrittable() {
        Button[] buttonArray = this.button;
        int n = this.button.length;
        int n2 = 0;
        while (n2 < n) {
            Button element = buttonArray[n2];
            element.setEnabled(true);
            ++n2;
        }
    }
}

