/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.operations;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.business.internal.metamodel.operations.DDiagramElementSpecOperations;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DragAndDropTargetDescription;
import org.eclipse.sirius.diagram.description.NodeMapping;

public final class DDiagramElementContainerOperations {
    private DDiagramElementContainerOperations() {
    }

    public static Collection<AbstractDNode> getNodes(DDiagramElementContainer container) {
        ArrayList<AbstractDNode> result = new ArrayList<AbstractDNode>();
        for (DDiagramElement elem : container.getElements()) {
            if (elem instanceof DNode) {
                result.add((DNode)elem);
                DNode node = (DNode)elem;
                for (DNode borderNode : node.getOwnedBorderedNodes()) {
                    result.add(borderNode);
                }
            } else if (elem instanceof DNodeListElement) {
                result.add((DNodeListElement)elem);
            }
            if (!(elem instanceof DDiagramElementContainer)) continue;
            DDiagramElementContainerOperations.addViewNodes((DDiagramElementContainer)elem, result);
        }
        return result;
    }

    private static void addViewNodes(DDiagramElementContainer elem, Collection<AbstractDNode> result) {
        block5: {
            block4: {
                if (!(elem instanceof DNodeContainer)) break block4;
                DNodeContainer container = (DNodeContainer)elem;
                result.addAll((Collection<AbstractDNode>)container.getOwnedBorderedNodes());
                for (DDiagramElement subElem : container.getOwnedDiagramElements()) {
                    if (subElem instanceof DNode) {
                        result.add((DNode)subElem);
                    }
                    if (!(subElem instanceof DDiagramElementContainer)) continue;
                    DDiagramElementContainerOperations.addViewNodes((DDiagramElementContainer)subElem, result);
                }
                break block5;
            }
            if (!(elem instanceof DNodeList)) break block5;
            DNodeList container = (DNodeList)elem;
            for (DDiagramElement subElem : container.getOwnedElements()) {
                if (subElem instanceof DNode) {
                    result.add((DNode)subElem);
                }
                if (!(subElem instanceof DDiagramElementContainer)) continue;
                DDiagramElementContainerOperations.addViewNodes((DDiagramElementContainer)subElem, result);
            }
        }
    }

    public static Collection<DDiagramElementContainer> getContainers(DDiagramElementContainer container) {
        ArrayList<DDiagramElementContainer> result = new ArrayList<DDiagramElementContainer>();
        for (DDiagramElement elem : container.getElements()) {
            if (elem instanceof DDiagramElementContainer) {
                result.add((DDiagramElementContainer)elem);
            }
            if (!(elem instanceof DNodeContainer)) continue;
            DDiagramElementContainerOperations.addSiriusElementContainers((DNodeContainer)elem, result);
        }
        return result;
    }

    private static void addSiriusElementContainers(DNodeContainer container, Collection<DDiagramElementContainer> result) {
        for (DDiagramElement elem : container.getOwnedDiagramElements()) {
            if (elem instanceof DDiagramElementContainer) {
                result.add((DDiagramElementContainer)elem);
            }
            if (!(elem instanceof DNodeContainer)) continue;
            DDiagramElementContainerOperations.addSiriusElementContainers((DNodeContainer)elem, result);
        }
    }

    public static EList<DNode> getNodesFromMapping(DDiagramElementContainer container, NodeMapping mapping) {
        BasicEList result = new BasicEList();
        for (DNode node : container.getNodes()) {
            if (node.getMapping() != mapping) continue;
            result.add((Object)node);
        }
        return result;
    }

    public static EList<DDiagramElementContainer> getContainersFromMapping(DDiagramElementContainer current, ContainerMapping mapping) {
        BasicEList result = new BasicEList();
        for (DDiagramElementContainer container : DDiagramElementContainerOperations.getContainers(current)) {
            if (container.getActualMapping() != mapping) continue;
            result.add((Object)container);
        }
        return result;
    }

    public static DDiagram getParentDiagram(DDiagramElementContainer container) {
        return DDiagramElementSpecOperations.getParentDiagram(container);
    }

    public static DragAndDropTargetDescription getDragAndDropDescription(DDiagramElementContainer self) {
        return self.getActualMapping();
    }
}

