/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.api.command.view;

import com.google.common.collect.Lists;
import java.util.Iterator;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.business.api.helper.graphicalfilters.HideFilterHelper;

public class RevealAllElementsCommand
extends RecordingCommand {
    public static final String REVEAL_ALL_ELEMENTS_LABEL = Messages.RevealAllElementsCommand_revealAllElementsLabel;
    private final DDiagram viewpoint;

    public RevealAllElementsCommand(TransactionalEditingDomain domain, DDiagram vp) {
        super(domain, REVEAL_ALL_ELEMENTS_LABEL);
        this.viewpoint = vp;
    }

    protected void doExecute() {
        NonConcurrentEAllContentIterator it = new NonConcurrentEAllContentIterator((EObject)this.viewpoint);
        while (it.hasNext()) {
            EObject eObj = (EObject)it.next();
            if (!(eObj instanceof DDiagramElement)) continue;
            HideFilterHelper.INSTANCE.reveal((DDiagramElement)eObj);
        }
    }

    private static final class NonConcurrentEAllContentIterator
    extends AbstractTreeIterator<EObject> {
        private static final long serialVersionUID = 1L;

        NonConcurrentEAllContentIterator(EObject object) {
            super((Object)object, false);
        }

        protected Iterator<EObject> getChildren(Object object) {
            return Lists.newArrayList((Iterable)((EObject)object).eContents()).iterator();
        }
    }
}

