/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.codeexecution.behaviors;

import fr.inria.aoste.timesquare.backend.codeexecution.Activator;
import fr.inria.aoste.timesquare.backend.codeexecution.CodeExecutionHelper;
import fr.inria.aoste.timesquare.backend.codeexecution.ICodeExecutionAPI;
import fr.inria.aoste.timesquare.backend.codeexecution.persistentoptions.Variable;
import fr.inria.aoste.timesquare.backend.manager.visible.Behavior;
import fr.inria.aoste.timesquare.backend.manager.visible.ConfigurationHelper;
import fr.inria.aoste.trace.ModelElementReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IMethod;

public class CodeExecutionBehavior
implements Behavior {
    protected IMethod _method;
    protected String _methodName;
    protected String _className;
    public ConfigurationHelper _confHelper = null;
    protected CodeExecutionHelper ce = null;
    protected ClassLoader newLoader = null;
    protected Object o = null;
    protected Method m;
    protected Variable variable = null;

    public final CodeExecutionHelper getCe() {
        return this.ce;
    }

    public final void setCe(CodeExecutionHelper ce) {
        this.ce = ce;
        if (this.variable != null) {
            this.variable.setCodeExecutionHelper(ce);
            this.o = this.variable.getObject();
        }
        this.applyo();
    }

    public String getClassName() {
        return this._className;
    }

    public IStatus createStatusError(String message, Throwable throwable) {
        Status status = new Status(4, "fr.inria.aoste.timesquare.backend.codeexecution", message, throwable);
        Activator.getDefault().getLog().log((IStatus)status);
        return status;
    }

    private void applyo() {
        if (this.o == null && this.ce != null) {
            try {
                if (this.variable != null) {
                    this.variable.setCodeExecutionHelper(this.ce);
                    this.o = this.variable.getObject();
                }
            }
            catch (Throwable e) {
                this.createStatusError("newInstance fail", e);
                e.printStackTrace();
            }
        }
        if (this.o instanceof ICodeExecutionAPI) {
            try {
                ((ICodeExecutionAPI)this.o).setHelper(this.ce);
            }
            catch (Throwable e) {
                this.createStatusError("ICodeExecutionAPI.setHelper fail ", e);
            }
        }
    }

    public CodeExecutionBehavior(Variable v, IMethod method, ConfigurationHelper helper) {
        this._confHelper = helper;
        try {
            this.setVariable(v);
            this._methodName = null;
            this._method = method;
            this._className = this._method.getCompilationUnit().findPrimaryType().getFullyQualifiedParameterizedName();
            this.applyo();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public CodeExecutionBehavior(Variable v, String methodName, ConfigurationHelper helper) {
        this._confHelper = helper;
        try {
            this.setVariable(v);
            this._method = null;
            this._methodName = methodName;
            this._className = v.getTypeName();
            this.applyo();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void execute(ArrayList<ModelElementReference> mersToForce) {
        block21: {
            security = System.getSecurityManager();
            System.setSecurityManager(new NoExitSecurityManager(Thread.currentThread()));
            try {
                if (this._className == null) {
                    return;
                }
                try {
                    block22: {
                        try {
                            if (this.m == null) {
                                this.m = this.o.getClass().getDeclaredMethod(this._method != null ? this._method.getElementName() : this._methodName, new Class[0]);
                            }
                            if ((res = this.m.invoke(this.o, new Object[0])) instanceof Boolean) {
                                boolRes = (Boolean)res;
                                if (boolRes.booleanValue()) {
                                    for (ModelElementReference mer : mersToForce) {
                                        this.ce.getSolver().forceClockPresence(mer);
                                    }
                                } else {
                                    for (ModelElementReference mer : mersToForce) {
                                        this.ce.getSolver().forceClockAbsence(mer);
                                    }
                                }
                            }
                            break block21;
                        }
                        catch (Throwable e) {
                            n = -1;
                            if (e instanceof InvocationTargetException) {
                                System.err.println("Code executor exception");
                                if (e.getCause() != null) {
                                    e.printStackTrace();
                                    n = e.getStackTrace().length;
                                    e = e.getCause();
                                }
                            }
                            if (n == -1 || (x = (st = e.getStackTrace()).length - n) <= 0) break block22;
                            ste = new StackTraceElement[x];
                            i = 0;
                            ** while (i < x)
                        }
lbl-1000:
                        // 1 sources

                        {
                            ste[i] = st[i];
                            ++i;
                            continue;
                        }
lbl36:
                        // 1 sources

                        e.setStackTrace(ste);
                    }
                    if (e instanceof ExitException) {
                        this.ce.printlnError("==> Operation Illegal on method " + (this._method != null ? this._method.getElementName() : this._methodName), e);
                    } else {
                        this.ce.printlnError("Error on method " + (this._method != null ? this._method.getElementName() : this._methodName), e);
                    }
                    this.createStatusError("Method fail ", e);
                }
                catch (Throwable e) {
                    System.err.println("Error : !! " + e);
                    this.createStatusError("Error ", e);
                }
            }
            finally {
                if (security != null) {
                    System.setSecurityManager(security);
                }
            }
        }
    }

    public boolean behaviorEquals(Behavior behavior) {
        block9: {
            CodeExecutionBehavior ceb;
            block10: {
                if (behavior == this) {
                    return true;
                }
                if (behavior == null) {
                    return false;
                }
                if (behavior.getClass() != this.getClass()) {
                    return false;
                }
                ceb = (CodeExecutionBehavior)behavior;
                String itsMethodName = null;
                String itsClassName = null;
                if (ceb.getMethod() != null && this.getMethod() != null) {
                    itsMethodName = ceb.getMethod().getElementName();
                    itsClassName = ceb.getMethod().getCompilationUnit().findPrimaryType().getFullyQualifiedParameterizedName();
                } else {
                    itsMethodName = ceb.getMethodName();
                    itsClassName = ceb.getClassName();
                }
                if (!this._method.getElementName().equals(itsMethodName) || !this._className.equals(itsClassName)) break block9;
                if (this.variable != null || ceb.variable != null) break block10;
                return true;
            }
            try {
                if (this.variable != null && this.variable.equals(ceb.variable)) {
                    return true;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.createStatusError("behaviorEquals fail ", e);
            }
        }
        return false;
    }

    public IMethod getMethod() {
        return this._method;
    }

    public void setMethod(IMethod method) {
        this._method = method;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public void setMethodName(String _methodName) {
        this._methodName = _methodName;
    }

    public final String getDescription() {
        String name = this.getClass().getSimpleName();
        StringBuilder sb = new StringBuilder();
        char[] cArray = name.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isUpperCase(c)) {
                sb.append(" ");
            }
            sb.append(c);
            ++n2;
        }
        sb.append(" : ");
        sb.append(this._className).append(" ");
        if (this._method != null) {
            sb.append(this._method.getElementName());
        } else {
            sb.append(this._methodName);
        }
        return sb.toString();
    }

    public void finish() {
        if (this.o instanceof ICodeExecutionAPI) {
            try {
                ((ICodeExecutionAPI)this.o).finish();
            }
            catch (Throwable e) {
                this.createStatusError("ICodeExecutionAPI.setHelper fail ", e);
            }
        }
    }

    public Variable getVariable() {
        return this.variable;
    }

    public void setVariable(Variable variable) {
        this.variable = variable;
    }

    public static class ExitException
    extends SecurityException {
        private static final long serialVersionUID = 1460964248465204534L;
        public final int status;

        public ExitException(int status) {
            super("There is no escape!");
            this.status = status;
        }
    }

    public static class NoExitSecurityManager
    extends SecurityManager {
        public Thread t = null;

        public NoExitSecurityManager(Thread thread) {
            this.t = thread;
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
        }

        @Override
        public void checkPermission(Permission perm) {
        }

        @Override
        public void checkExit(int status) {
            if (Thread.currentThread() == this.t) {
                super.checkExit(status);
                throw new ExitException(status);
            }
        }
    }
}

