/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.force.graph;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.force.graph.FBendpoint;
import org.eclipse.elk.alg.force.graph.FLabel;
import org.eclipse.elk.alg.force.graph.FNode;
import org.eclipse.elk.core.math.ElkMath;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.graph.properties.MapPropertyHolder;

public final class FEdge
extends MapPropertyHolder {
    private static final long serialVersionUID = 4387555754824186467L;
    private List<FBendpoint> bendpoints = new ArrayList<FBendpoint>();
    private List<FLabel> labels = new ArrayList<FLabel>();
    private FNode source;
    private FNode target;

    public String toString() {
        if (this.source != null && this.target != null) {
            return String.valueOf(this.source.toString()) + "->" + this.target.toString();
        }
        return "e_" + ((Object)((Object)this)).hashCode();
    }

    public FNode getSource() {
        return this.source;
    }

    public FNode getTarget() {
        return this.target;
    }

    public List<FBendpoint> getBendpoints() {
        return this.bendpoints;
    }

    public List<FLabel> getLabels() {
        return this.labels;
    }

    public KVector getSourcePoint() {
        KVector v = this.target.getPosition().clone().sub(this.source.getPosition());
        ElkMath.clipVector((KVector)v, (double)this.source.getSize().x, (double)this.source.getSize().y);
        return v.add(this.source.getPosition());
    }

    public KVector getTargetPoint() {
        KVector v = this.source.getPosition().clone().sub(this.target.getPosition());
        ElkMath.clipVector((KVector)v, (double)this.target.getSize().x, (double)this.target.getSize().y);
        return v.add(this.target.getPosition());
    }

    public void setSource(FNode theSource) {
        this.source = theSource;
    }

    public void setTarget(FNode theTarget) {
        this.target = theTarget;
    }

    public KVectorChain toVectorChain() {
        KVectorChain vectorChain = new KVectorChain();
        vectorChain.add((Object)this.getSourcePoint());
        for (FBendpoint bendPoint : this.bendpoints) {
            vectorChain.add((Object)bendPoint.getPosition());
        }
        vectorChain.add((Object)this.getTargetPoint());
        return vectorChain;
    }

    public void distributeBendpoints() {
        int count = this.bendpoints.size();
        if (count > 0) {
            KVector sourcePos = this.source.getPosition();
            KVector targetPos = this.target.getPosition();
            KVector incr = targetPos.clone().sub(sourcePos).scale(1.0 / (double)(count + 1));
            KVector pos = sourcePos.clone();
            for (FBendpoint bendPoint : this.bendpoints) {
                bendPoint.getPosition().x = pos.x;
                bendPoint.getPosition().y = pos.y;
                pos.add(incr);
            }
        }
    }
}

