/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.visible;

import fr.inria.aoste.timesquare.backend.manager.controller.Controller;
import fr.inria.aoste.timesquare.backend.manager.datastructure.assertion.AssertActivationState;
import fr.inria.aoste.timesquare.backend.manager.datastructure.assertion.AssertBehaviorEntity;
import fr.inria.aoste.timesquare.backend.manager.datastructure.clock.ClockActivationState;
import fr.inria.aoste.timesquare.backend.manager.datastructure.clock.ClockBehaviorEntity;
import fr.inria.aoste.timesquare.backend.manager.datastructure.relation.RelationActivationState;
import fr.inria.aoste.timesquare.backend.manager.datastructure.relation.RelationBehaviorEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockBehavior;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.PersistentOptions;
import fr.inria.aoste.timesquare.backend.manager.visible.RelationBehavior;
import fr.inria.aoste.timesquare.backend.manager.visible.RelationEntity;
import fr.inria.aoste.timesquare.launcher.core.console.ConsoleSimulation;
import fr.inria.aoste.trace.PhysicalBase;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;

public class ConfigurationHelper {
    private Controller _controller;
    private ConsoleSimulation cs;

    public ConfigurationHelper(Controller controller) {
        assert (controller != null);
        this._controller = controller;
    }

    public void addBehavior(ClockEntity clockEntity, ClockActivationState clockActivationState, String pluginName, ClockBehavior behavior, PersistentOptions persistentOptions) {
        if (clockEntity != null && clockActivationState != null && pluginName != null && behavior != null) {
            this._controller.addEntity(new ClockBehaviorEntity(clockEntity, clockActivationState, pluginName, behavior, persistentOptions));
        }
    }

    public void removeBehavior(ClockEntity clockEntity, ClockActivationState activationState, ClockBehavior behavior) {
        ClockBehaviorEntity foundCbe = null;
        for (ClockBehaviorEntity cbe : this._controller.getDsm().getClockBehaviorEntity()) {
            if (!cbe.getClockEntity().equals(clockEntity) || !cbe.getClockActivationState().equals(activationState) || !cbe.getBehavior().equals(behavior)) continue;
            foundCbe = cbe;
            break;
        }
        if (foundCbe != null) {
            this._controller.deleteEntity(foundCbe);
        }
    }

    public void addBehavior(RelationActivationState relation, String pluginName, RelationBehavior behavior, PersistentOptions persistentOptions) {
        if (pluginName != null) {
            this._controller.addEntity(new RelationBehaviorEntity(relation, pluginName, behavior, persistentOptions));
        }
    }

    public void addBehavior(ClockEntity clockEntity, AssertActivationState clockActivationState, String pluginName, ClockBehavior behavior, PersistentOptions persistentOptions) {
        if (clockEntity != null && clockActivationState != null && pluginName != null && behavior != null) {
            this._controller.addEntity(new AssertBehaviorEntity(clockEntity, clockActivationState, pluginName, behavior, persistentOptions));
        }
    }

    public List<ClockEntity> getAssert() {
        return this._controller.getAssert();
    }

    public List<RelationEntity> getRelationEntities() {
        return this._controller.getRelationEntities();
    }

    public List<EObject> getRelationConstraint() {
        return this._controller.getRelationConstraint();
    }

    public List<EObject> getCcslConstraints() {
        return this._controller.getCcslConstraints();
    }

    public List<ClockEntity> getClocks() {
        return this._controller.getClocks();
    }

    public ClockEntity getClock(String ID) {
        for (ClockEntity ce : this._controller.getClocks()) {
            if (ce.getID().compareTo(ID) != 0) continue;
            return ce;
        }
        return null;
    }

    public ClockEntity getClock(EObject eo) {
        for (ClockEntity ce : this._controller.getClocks()) {
            if (ce.getClock() == eo) {
                return ce;
            }
            if (ce.getModelElementReference() != eo) continue;
            return ce;
        }
        return null;
    }

    public int getStateNumber() {
        return ClockActivationState.stateNumber;
    }

    public ClockActivationState getAlwaysState() {
        boolean[] tab = new boolean[]{true, true, true, true, true, true, true, true};
        return new ClockActivationState(tab);
    }

    public ClockActivationState getTicksState() {
        boolean[] blArray = new boolean[8];
        blArray[0] = true;
        blArray[2] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        boolean[] tab = blArray;
        return new ClockActivationState(tab);
    }

    public ClockActivationState getDoesntTickState() {
        boolean[] blArray = new boolean[8];
        blArray[1] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        boolean[] tab = blArray;
        return new ClockActivationState(tab);
    }

    public ClockActivationState createClockState(boolean[] state) {
        return new ClockActivationState(state);
    }

    public List<PhysicalBase> getPhysicalBases() {
        return this._controller.getPhysicalBases();
    }

    public void deleteEntitiesByPluginName(String pluginName) {
        this._controller.deleteEntitiesByPluginName(pluginName);
    }

    public IPath getModelPath() {
        return this._controller.getModelPath();
    }

    public void print(String s) {
        if (this.cs != null) {
            this.cs.printStdMessage(s);
        }
    }

    public void println(String s) {
        if (this.cs != null) {
            this.cs.printStdMessageln(s);
        }
    }

    public void printlnError(String s) {
        if (this.cs != null) {
            this.cs.printErrMessageln(s);
        }
    }

    public void printlnError(String s, Throwable e) {
        if (this.cs != null) {
            this.cs.printErrMessageln(s, e);
        }
    }

    public final synchronized void setCs(ConsoleSimulation cs) {
        this.cs = cs;
    }

    public InputStream getInputStream() {
        return this.cs.getInput();
    }
}

