/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.power.behavior;

import fr.inria.aoste.timesquare.backend.manager.visible.Behavior;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockBehavior;
import fr.inria.aoste.timesquare.backend.manager.visible.TraceHelper;
import fr.inria.aoste.timesquare.backend.power.behavior.PowerHelper;
import fr.inria.aoste.timesquare.backend.power.behavior.PowerPersitenceOption;
import fr.inria.aoste.timesquare.backend.power.view.PowerData;

public class ClockPowerBehavior
implements ClockBehavior {
    int start = 0;
    int stop = 0;
    long value = 0L;
    PowerPersitenceOption options;
    int integralpower = 0;
    PowerHelper power = null;
    PowerData powerData;
    int s = 0;

    public ClockPowerBehavior(PowerPersitenceOption _options) {
        this.options = _options;
        this.value = this.options.c.value;
    }

    public String getDescription() {
        try {
            return " ClockPowerBehavior " + this.options.c.toInfoString();
        }
        catch (Throwable e) {
            return " ClockPowerBehavior .....";
        }
    }

    public boolean behaviorEquals(Behavior behavior) {
        return behavior == this;
    }

    public void run(TraceHelper helper) {
        this.power.print("Ticking " + helper.getClockEntity().getName());
        if (helper.getClockEntity().getModelElementReference() == this.options.c.getSource()) {
            this.power.print("  Starting :" + this.start++);
            if (this.powerData != null) {
                this.powerData.addPoint(this.s, this.integralpower);
            }
        }
        if (helper.getClockEntity().getModelElementReference() == this.options.c.getDestination()) {
            this.power.print("  Stopping :" + this.stop++);
            this.integralpower = (int)((long)this.integralpower + this.value);
            if (this.powerData != null) {
                this.powerData.addPoint(this.s, this.integralpower);
            }
        }
        this.power.println("");
    }

    public void runWithWrongActivationState(TraceHelper helper) {
    }

    public void setPowerHelper(PowerHelper _power) {
        this.power = _power;
    }

    public void dispRapport() {
        this.power.println("***********************************");
        this.power.println("Couple :" + this.options.c.toInfoString());
        this.power.println("Starting :" + this.start + "  Stopping " + this.stop);
        this.power.println("Full execution :" + this.stop);
        this.power.println("Partial execution :" + (this.start - this.stop));
        if (this.value != -1L) {
            this.power.print("Consommation : " + this.value + " * " + this.stop + " = " + this.value * (long)this.stop);
            this.power.println("");
        }
        this.power.println("");
    }

    public void setPowerData(PowerData createPowerData) {
        this.powerData = createPowerData;
    }

    public void step(int step) {
        this.s = step;
    }
}

