/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.layout;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.CombinedFragmentEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.InteractionUseEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ObservationPointEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.SequenceDiagramEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.layout.CombinedFragmentVerticalPositionFunction;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.layout.InstanceUseVerticalPositionFunction;

public class SequenceZOrderingRefresher
implements Runnable {
    private final SequenceDiagramEditPart sequenceDiagramPart;

    public SequenceZOrderingRefresher(SequenceDiagramEditPart sequenceDiagramEditPart) {
        this.sequenceDiagramPart = (SequenceDiagramEditPart)((Object)Preconditions.checkNotNull((Object)((Object)sequenceDiagramEditPart)));
    }

    @Override
    public void run() {
        this.moveInteractionUsesToFront();
        this.moveCombinedFragmentsToBack();
        this.moveObservationPointToFront();
    }

    private void moveInteractionUsesToFront() {
        this.moveParts(InteractionUseEditPart.class, true, new InstanceUseVerticalPositionFunction());
    }

    private void moveObservationPointToFront() {
        this.moveParts(ObservationPointEditPart.class, true, null);
    }

    private void moveCombinedFragmentsToBack() {
        this.moveParts(CombinedFragmentEditPart.class, false, new CombinedFragmentVerticalPositionFunction());
    }

    private void moveParts(Class<? extends IGraphicalEditPart> typeToMove, boolean moveToFront, Function<IGraphicalEditPart, Integer> sorter) {
        ArrayList partsToMove = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.sequenceDiagramPart.getChildren(), typeToMove));
        if (sorter != null) {
            Ordering onResultOf = Ordering.natural().onResultOf(sorter);
            if (moveToFront) {
                onResultOf = onResultOf.reverse();
            }
            Collections.sort(partsToMove, onResultOf);
        }
        if (!partsToMove.isEmpty()) {
            int index = moveToFront ? Iterables.size((Iterable)Iterables.filter((Iterable)this.sequenceDiagramPart.getChildren(), IGraphicalEditPart.class)) - 1 : 0;
            for (IGraphicalEditPart frame : partsToMove) {
                this.sequenceDiagramPart.reorderChild((EditPart)frame, index);
                index += moveToFront ? -1 : 1;
            }
        }
    }
}

