/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.solver;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.Element;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.IntegerElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.PrimitiveElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.RealElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.SequenceElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.ClassicalExpression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntegerVariableRef;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExpressionDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Concatenation;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Death;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Defer;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Discretization;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Inf;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Intersection;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.NonStrictSampling;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.StrictSampling;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Sup;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Union;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.UpTo;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Wait;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.util.KernelExpressionSwitch;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.AbstractConcreteMapping;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiatedElement;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiationPath;
import fr.inria.aoste.timesquare.ccslkernel.runtime.ValueProvider;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeSequence;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.AbstractRuntimeExpression;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.RuntimeConcatenation;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.RuntimeDeath;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.RuntimeDefer;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.RuntimeDiscretization;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.RuntimeInf;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.RuntimeIntersection;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.RuntimeSampling;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.RuntimeStrictSampling;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.RuntimeSup;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.RuntimeUnion;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.RuntimeUpTo;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.RuntimeWait;
import fr.inria.aoste.timesquare.ccslkernel.solver.CCSLKernelSolver;
import fr.inria.aoste.timesquare.ccslkernel.solver.ClassicalExpressionEvaluator;
import fr.inria.aoste.timesquare.ccslkernel.solver.ISolverElement;
import fr.inria.aoste.timesquare.ccslkernel.solver.ImplicitClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.SolverElement;
import fr.inria.aoste.timesquare.ccslkernel.solver.SolverPrimitiveElement;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.BasicType.SolverSequenceElement;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.SolverClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.exception.ClockNotFound;
import fr.inria.aoste.timesquare.ccslkernel.solver.exception.SolverWrappedException;
import fr.inria.aoste.timesquare.ccslkernel.solver.exception.UnboundAbstract;
import fr.inria.aoste.timesquare.ccslkernel.solver.expression.SolverExpression;
import fr.inria.aoste.timesquare.ccslkernel.solver.expression.SolverExpressionDelegate;
import java.util.Collection;
import javax.management.BadAttributeValueExpException;
import org.eclipse.emf.ecore.EObject;

class SolverKernelExpressionBuilder
extends KernelExpressionSwitch<SolverExpression> {
    private CCSLKernelSolver solver;
    private ImplicitClock iClock;
    private AbstractConcreteMapping<ISolverElement> environment;
    private InstantiatedElement expression;

    SolverKernelExpressionBuilder(CCSLKernelSolver solver, ImplicitClock iClock, AbstractConcreteMapping<ISolverElement> env) {
        this.solver = solver;
        this.iClock = iClock;
        this.environment = env;
    }

    public SolverExpression buildExpression(InstantiatedElement expression) throws UnboundAbstract {
        this.expression = expression;
        ExpressionDeclaration decl = (ExpressionDeclaration)expression.getDeclaration();
        SolverExpression expr = (SolverExpression)this.doSwitch((EObject)decl);
        expr.setInstantiationPath(new InstantiationPath((Collection)expression.getInstantiationPath()));
        expr.setInstantiatedElement(expression);
        return expr;
    }

    private SolverClock findClock(InstantiationPath path) {
        SolverClock res = (SolverClock)this.solver.getClockInstantiationTree().lookupInstance(path);
        if (res == null) {
            throw new SolverWrappedException(new ClockNotFound("No clock for path: " + path.toString()));
        }
        return res;
    }

    public SolverExpression caseDeath(Death object) {
        SolverExpressionDelegate expr = new SolverExpressionDelegate((AbstractRuntimeExpression)new RuntimeDeath((RuntimeClock)this.iClock));
        return expr;
    }

    public SolverExpression caseUnion(Union object) {
        SolverExpressionDelegate expr = new SolverExpressionDelegate();
        InstantiatedElement left = this.expression.resolveAbstractEntity(object.getClock1());
        SolverClock leftClock = this.findClock(left.getInstantiationPath());
        InstantiatedElement right = this.expression.resolveAbstractEntity(object.getClock2());
        SolverClock rightClock = this.findClock(right.getInstantiationPath());
        leftClock.incRefCount();
        rightClock.incRefCount();
        expr.setDelegate((AbstractRuntimeExpression)new RuntimeUnion((RuntimeClock)this.iClock, (RuntimeClock)leftClock, (RuntimeClock)rightClock));
        return expr;
    }

    public SolverExpression caseWait(Wait object) {
        SolverExpressionDelegate expr = new SolverExpressionDelegate();
        InstantiatedElement waiting = this.expression.resolveAbstractEntity(object.getWaitingClock());
        InstantiatedElement value = this.expression.resolveAbstractEntity(object.getWaitingValue());
        SolverClock waitClock = this.findClock(waiting.getInstantiationPath());
        PrimitiveElement waitCount = (PrimitiveElement)this.solver.buildElement(value, expr).getModelElement();
        waitClock.incRefCount();
        RuntimeWait wait = null;
        if (waitCount instanceof IntegerElement) {
            wait = new RuntimeWait((RuntimeClock)this.iClock, (RuntimeClock)waitClock, ((IntegerElement)waitCount).getValue());
        } else if (waitCount instanceof ClassicalExpression) {
            ValueProvider<Integer> temp = new ValueProvider<Integer>(waitCount){
                private ClassicalExpression expr;
                {
                    this.expr = (ClassicalExpression)primitiveElement;
                }

                public Integer getValue() {
                    ClassicalExpressionEvaluator eval = new ClassicalExpressionEvaluator((AbstractConcreteMapping<ISolverElement>)SolverKernelExpressionBuilder.this.environment);
                    SolverElement value = eval.evaluate((PrimitiveElement)this.expr);
                    if (value instanceof SolverPrimitiveElement && value.getModelElement() instanceof IntegerElement) {
                        return ((IntegerElement)value.getModelElement()).getValue();
                    }
                    return 0;
                }
            };
            wait = new RuntimeWait((RuntimeClock)this.iClock, (RuntimeClock)waitClock, (ValueProvider)temp);
        }
        expr.setDelegate((AbstractRuntimeExpression)wait);
        return expr;
    }

    public SolverExpression caseDefer(Defer object) {
        SolverExpressionDelegate expr = new SolverExpressionDelegate();
        InstantiatedElement baseClockElt = this.expression.resolveAbstractEntity(object.getBaseClock());
        InstantiatedElement delayClockElt = this.expression.resolveAbstractEntity(object.getDelayClock());
        InstantiatedElement delayPattern = this.expression.resolveAbstractEntity(object.getDelayPattern());
        SolverClock baseClock = this.findClock(baseClockElt.getInstantiationPath());
        SolverClock delayClock = this.findClock(delayClockElt.getInstantiationPath());
        baseClock.incRefCount();
        delayClock.incRefCount();
        SolverElement delayElt = (SolverElement)this.solver.buildElement(delayPattern, expr);
        RuntimeDefer defer = null;
        if (delayElt instanceof SolverSequenceElement) {
            SequenceElement seq = ((SolverSequenceElement)delayElt).getSequenceElement();
            Object[] fp = new Integer[seq.getFinitePart().size()];
            int i = 0;
            for (PrimitiveElement elt : seq.getFinitePart()) {
                if (!(elt instanceof IntegerElement)) continue;
                fp[i] = ((IntegerElement)elt).getValue();
                ++i;
            }
            Object[] nfp = new Integer[seq.getNonFinitePart().size()];
            i = 0;
            for (PrimitiveElement elt : seq.getNonFinitePart()) {
                if (elt instanceof IntegerElement) {
                    nfp[i] = ((IntegerElement)elt).getValue();
                    ++i;
                    continue;
                }
                if (!(elt instanceof IntegerVariableRef)) continue;
                InstantiatedElement ie = this.expression.resolveAbstractEntity(((IntegerVariableRef)elt).getReferencedVar());
                if (!(ie.getInstantiationPath().getLast() instanceof IntegerElement)) {
                    try {
                        throw new BadAttributeValueExpException((Object)("the integerVaribaleRef (" + elt + ") is not bounded to an integerElement !"));
                    }
                    catch (BadAttributeValueExpException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                nfp[i] = ((IntegerElement)ie.getInstantiationPath().getLast()).getValue();
                ++i;
            }
            RuntimeSequence rseq = new RuntimeSequence(fp, nfp);
            defer = new RuntimeDefer((RuntimeClock)this.iClock, (RuntimeClock)baseClock, (RuntimeClock)delayClock, rseq);
        } else if (delayElt.getModelElement() instanceof ClassicalExpression) {
            Element delay = delayElt.getModelElement();
            ValueProvider<RuntimeSequence<? extends Integer>> tmp = new ValueProvider<RuntimeSequence<? extends Integer>>(delay){
                private ClassicalExpression expr;
                {
                    this.expr = (ClassicalExpression)element;
                }

                public RuntimeSequence<Integer> getValue() {
                    ClassicalExpressionEvaluator eval = new ClassicalExpressionEvaluator((AbstractConcreteMapping<ISolverElement>)SolverKernelExpressionBuilder.this.environment);
                    SolverElement value = eval.evaluate((PrimitiveElement)this.expr);
                    if (value instanceof SolverSequenceElement) {
                        SequenceElement seq = ((SolverSequenceElement)value).getSequenceElement();
                        Object[] fp = new Integer[seq.getFinitePart().size()];
                        int i = 0;
                        for (PrimitiveElement elt : seq.getFinitePart()) {
                            if (!(elt instanceof IntegerElement)) continue;
                            fp[i] = ((IntegerElement)elt).getValue();
                            ++i;
                        }
                        Object[] nfp = new Integer[seq.getNonFinitePart().size()];
                        i = 0;
                        for (PrimitiveElement elt : seq.getNonFinitePart()) {
                            if (!(elt instanceof IntegerElement)) continue;
                            nfp[i] = ((IntegerElement)elt).getValue();
                            ++i;
                        }
                        RuntimeSequence rseq = new RuntimeSequence(fp, nfp);
                        return rseq;
                    }
                    return null;
                }
            };
            defer = new RuntimeDefer((RuntimeClock)this.iClock, (RuntimeClock)baseClock, (RuntimeClock)delayClock, (ValueProvider)tmp);
        }
        expr.setDelegate((AbstractRuntimeExpression)defer);
        return expr;
    }

    public SolverExpression caseIntersection(Intersection object) {
        InstantiatedElement left = this.expression.resolveAbstractEntity(object.getClock1());
        InstantiatedElement right = this.expression.resolveAbstractEntity(object.getClock2());
        SolverClock leftClock = this.findClock(left.getInstantiationPath());
        SolverClock rightClock = this.findClock(right.getInstantiationPath());
        leftClock.incRefCount();
        rightClock.incRefCount();
        SolverExpressionDelegate expr = new SolverExpressionDelegate();
        expr.setDelegate((AbstractRuntimeExpression)new RuntimeIntersection((RuntimeClock)this.iClock, (RuntimeClock)leftClock, (RuntimeClock)rightClock));
        return expr;
    }

    public SolverExpression caseUpTo(UpTo object) {
        InstantiatedElement follow = this.expression.resolveAbstractEntity(object.getClockToFollow());
        InstantiatedElement killer = this.expression.resolveAbstractEntity(object.getKillerClock());
        SolverClock clockToFollow = this.findClock(follow.getInstantiationPath());
        SolverClock killerClock = this.findClock(killer.getInstantiationPath());
        clockToFollow.incRefCount();
        killerClock.incRefCount();
        RuntimeUpTo upTo = new RuntimeUpTo((RuntimeClock)this.iClock, (RuntimeClock)clockToFollow, (RuntimeClock)killerClock);
        upTo.setPreemptive(object.isIsPreemptive());
        SolverExpressionDelegate expr = new SolverExpressionDelegate((AbstractRuntimeExpression)upTo);
        return expr;
    }

    public SolverExpression caseStrictSampling(StrictSampling object) {
        InstantiatedElement sampled = this.expression.resolveAbstractEntity(object.getSampledClock());
        InstantiatedElement sampling = this.expression.resolveAbstractEntity(object.getSamplingClock());
        SolverClock sampledClock = this.findClock(sampled.getInstantiationPath());
        SolverClock samplingClock = this.findClock(sampling.getInstantiationPath());
        sampledClock.incRefCount();
        samplingClock.incRefCount();
        RuntimeStrictSampling smp = new RuntimeStrictSampling((RuntimeClock)this.iClock, (RuntimeClock)sampledClock, (RuntimeClock)samplingClock);
        SolverExpressionDelegate expr = new SolverExpressionDelegate((AbstractRuntimeExpression)smp);
        return expr;
    }

    public SolverExpression caseNonStrictSampling(NonStrictSampling object) {
        InstantiatedElement sampled = this.expression.resolveAbstractEntity(object.getSampledClock());
        InstantiatedElement sampling = this.expression.resolveAbstractEntity(object.getSamplingClock());
        SolverClock sampledClock = this.findClock(sampled.getInstantiationPath());
        SolverClock samplingClock = this.findClock(sampling.getInstantiationPath());
        sampledClock.incRefCount();
        samplingClock.incRefCount();
        RuntimeSampling smp = new RuntimeSampling((RuntimeClock)this.iClock, (RuntimeClock)sampledClock, (RuntimeClock)samplingClock);
        SolverExpressionDelegate expr = new SolverExpressionDelegate((AbstractRuntimeExpression)smp);
        return expr;
    }

    public SolverExpression caseInf(Inf object) {
        InstantiatedElement left = this.expression.resolveAbstractEntity(object.getClock1());
        InstantiatedElement right = this.expression.resolveAbstractEntity(object.getClock2());
        SolverClock clock1 = this.findClock(left.getInstantiationPath());
        SolverClock clock2 = this.findClock(right.getInstantiationPath());
        clock1.incRefCount();
        clock2.incRefCount();
        RuntimeInf inf = new RuntimeInf((RuntimeClock)this.iClock, (RuntimeClock)clock1, (RuntimeClock)clock2);
        SolverExpressionDelegate expr = new SolverExpressionDelegate((AbstractRuntimeExpression)inf);
        return expr;
    }

    public SolverExpression caseSup(Sup object) {
        InstantiatedElement left = this.expression.resolveAbstractEntity(object.getClock1());
        InstantiatedElement right = this.expression.resolveAbstractEntity(object.getClock2());
        SolverClock clock1 = this.findClock(left.getInstantiationPath());
        SolverClock clock2 = this.findClock(right.getInstantiationPath());
        clock1.incRefCount();
        clock2.incRefCount();
        RuntimeSup sup = new RuntimeSup((RuntimeClock)this.iClock, (RuntimeClock)clock1, (RuntimeClock)clock2);
        SolverExpressionDelegate expr = new SolverExpressionDelegate((AbstractRuntimeExpression)sup);
        return expr;
    }

    public SolverExpression caseConcatenation(Concatenation object) {
        InstantiatedElement left = this.expression.resolveAbstractEntity(object.getLeftClock());
        InstantiatedElement right = this.expression.resolveAbstractEntity(object.getRightClock());
        SolverClock leftClock = this.findClock(left.getInstantiationPath());
        SolverClock rightClock = this.findClock(right.getInstantiationPath());
        leftClock.incRefCount();
        if (!this.expression.getInstantiationPath().equals((Object)right.getInstantiationPath())) {
            rightClock.incRefCount();
        }
        RuntimeConcatenation concat = new RuntimeConcatenation((RuntimeClock)this.iClock, (RuntimeClock)leftClock, (RuntimeClock)rightClock);
        SolverExpressionDelegate expr = new SolverExpressionDelegate((AbstractRuntimeExpression)concat);
        return expr;
    }

    public SolverExpression caseDiscretization(Discretization object) {
        SolverExpressionDelegate expr = new SolverExpressionDelegate();
        InstantiatedElement clock = this.expression.resolveAbstractEntity(object.getDenseClock());
        InstantiatedElement discFactor = this.expression.resolveAbstractEntity(object.getDiscretizationFactor());
        SolverClock denseClock = this.findClock(clock.getInstantiationPath());
        SolverElement factorElement = (SolverElement)this.solver.buildElement(discFactor, expr);
        float factor = 0.0f;
        if (factorElement.getModelElement() instanceof RealElement) {
            factor = ((RealElement)factorElement.getModelElement()).getValue().floatValue();
        } else if (factorElement.getModelElement() instanceof RealElement) {
            factor = ((IntegerElement)factorElement.getModelElement()).getValue().intValue();
        }
        RuntimeDiscretization disc = new RuntimeDiscretization((RuntimeClock)this.iClock, (RuntimeClock)denseClock, factor);
        expr.setDelegate((AbstractRuntimeExpression)disc);
        return expr;
    }
}

