/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.helper.task.InitInterpreterVariablesTask;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.description.TreeItemMapping;
import org.eclipse.sirius.tree.description.TreeMapping;
import org.eclipse.sirius.tree.ui.provider.Messages;
import org.eclipse.sirius.tree.ui.tools.internal.commands.EMFCommandFactoryUI;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeEditor;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeViewerManager;
import org.eclipse.sirius.tree.ui.tools.internal.editor.actions.AbstractToolAction;
import org.eclipse.sirius.tree.ui.tools.internal.editor.actions.AbstractToolItemAction;
import org.eclipse.sirius.tree.ui.tools.internal.editor.actions.CreateRepresentationFromRepresentationCreationDescription;
import org.eclipse.sirius.tree.ui.tools.internal.editor.actions.CreateToolItemAction;
import org.eclipse.sirius.tree.ui.tools.internal.editor.actions.DeleteTreeItemsAction;
import org.eclipse.sirius.tree.ui.tools.internal.editor.actions.RefreshAction;
import org.eclipse.sirius.tree.ui.tools.internal.editor.provider.TreePopupMenuContributionSupport;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.tools.internal.editor.MenuHelper;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationCreationDescription;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationNavigationDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class DTreeMenuListener
implements IMenuListener {
    private static final String MENU_OPEN_REPRESENTATION_ID = "popup.navigate";
    private static final String MENU_NEW_REPRESENTATION_ID = "popup.new";
    private static final String NEW_REPRESENTATION_GROUP_SEPARATOR = "newRepresentation";
    private static final String EXISTING_REPRESENTATION_GROUP_SEPARATOR = "existingRepresentation";
    private static final String PROPERTIES_SEPARATOR = "properties";
    private static final String LOCK_SEPARATOR = "lockGroup";
    private final AdapterFactory adapterFactory = DialectUIManager.INSTANCE.createAdapterFactory();
    private final DTree dTree;
    private final DTreeViewerManager treeViewManager;
    private RefreshAction refreshAction;
    private final DeleteTreeItemsAction deleteItemsAction;
    private Map<TreeMapping, List<AbstractToolAction>> mappingToCreateActions;
    private List<AbstractToolAction> createActionsForTree;
    private TreePopupMenuContributionSupport treePopupMenuContributionHandler;

    public DTreeMenuListener(DTree tree, DTreeViewerManager treeViewManager, Map<TreeMapping, List<AbstractToolAction>> mappingToCreateActions, List<AbstractToolAction> createActionsForTree) {
        this.dTree = tree;
        this.treeViewManager = treeViewManager;
        this.treePopupMenuContributionHandler = new TreePopupMenuContributionSupport(this.treeViewManager.getEditingDomain(), this.treeViewManager.getTreeCommandFactory());
        this.deleteItemsAction = new DeleteTreeItemsAction(treeViewManager.getEditingDomain(), treeViewManager.getTreeCommandFactory());
        this.setMappingToCreateActions(mappingToCreateActions);
        this.setCreateActionsForTree(createActionsForTree);
        this.refreshAction = new RefreshAction((DTreeEditor)treeViewManager.getEditor());
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.treeViewManager.fillMenu();
        this.addOpenRepresentationMenu(manager);
        this.addNewRepresentationMenu(manager);
        manager.add((IContributionItem)new Separator());
        this.addRefreshMenu(manager);
        manager.add((IContributionItem)new Separator());
        this.addTreeItemMenus(manager);
        manager.add((IContributionItem)new Separator(LOCK_SEPARATOR));
        this.addTreeMenus(manager);
        manager.add((IContributionItem)new Separator(PROPERTIES_SEPARATOR));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void addTreeMenus(IMenuManager manager) {
        Collection<DTreeItem> selectedItems = this.treeViewManager.getSelectedItems();
        if (selectedItems != null && !selectedItems.isEmpty()) {
            for (AbstractToolAction abstractToolAction : this.getCreateActionsForTree()) {
                CreateToolItemAction createLineAction;
                if (!(abstractToolAction instanceof CreateToolItemAction) || !(createLineAction = (CreateToolItemAction)abstractToolAction).canExecute()) continue;
                manager.add((IAction)createLineAction);
            }
            manager.add((IContributionItem)new Separator());
        }
    }

    private void addOpenRepresentationMenu(IMenuManager manager) {
        MenuManager openMenuManager = new MenuManager(Messages.DTreeMenuListener_open, MENU_OPEN_REPRESENTATION_ID);
        SubContributionItem openMenuItem = new SubContributionItem((IContributionItem)openMenuManager);
        manager.add((IContributionItem)openMenuItem);
        Separator existingGroup = new Separator(EXISTING_REPRESENTATION_GROUP_SEPARATOR);
        openMenuManager.add((IContributionItem)existingGroup);
        Separator openRepresentationGroup = new Separator("openRepresentationGroup");
        openMenuManager.add((IContributionItem)openRepresentationGroup);
        Collection<DTreeItem> currentTreeElements = this.treeViewManager.getSelectedItems();
        if (currentTreeElements != null && currentTreeElements.size() == 1) {
            DTreeItem currentTreeElement = currentTreeElements.iterator().next();
            this.createOpenAction(openMenuItem, (DSemanticDecorator)currentTreeElement);
        } else {
            this.createOpenAction(openMenuItem, (DSemanticDecorator)this.dTree);
        }
    }

    private void addNewRepresentationMenu(IMenuManager manager) {
        DTreeItem currentTreeElement;
        MenuManager newMenuManager = new MenuManager(Messages.DTreeMenuListener_new, MENU_NEW_REPRESENTATION_ID);
        SubContributionItem newMenuItem = new SubContributionItem((IContributionItem)newMenuManager);
        manager.add((IContributionItem)newMenuItem);
        Separator createGroup = new Separator(NEW_REPRESENTATION_GROUP_SEPARATOR);
        newMenuManager.add((IContributionItem)createGroup);
        Collection<DTreeItem> currentTreeElements = this.treeViewManager.getSelectedItems();
        if (currentTreeElements != null && currentTreeElements.size() == 1 && (currentTreeElement = currentTreeElements.iterator().next()) != null) {
            this.createDetailsActions(currentTreeElement, newMenuItem);
        }
    }

    private void createOpenAction(SubContributionItem openItem, DSemanticDecorator decorator) {
        EObject semanticElement = decorator.getTarget();
        Session session = SessionManager.INSTANCE.getSession(semanticElement);
        if (session != null) {
            DRepresentationDescriptor representationDescriptor = new DRepresentationQuery((DRepresentation)this.dTree).getRepresentationDescriptor();
            DialectManager.INSTANCE.getAllRepresentationDescriptors(session).stream().filter(rd -> !Objects.equals(rd, representationDescriptor)).filter(repDesc -> Objects.equals(repDesc.getTarget(), semanticElement)).filter(repDesc -> this.isFromActiveViewpoint(session, repDesc.getDescription())).forEach(repDesc -> {
                openItem.setVisible(true);
                ((IMenuManager)openItem.getInnerItem()).appendToGroup(EXISTING_REPRESENTATION_GROUP_SEPARATOR, MenuHelper.buildOpenRepresentationAction((Session)session, (DRepresentationDescriptor)repDesc, (AdapterFactory)this.adapterFactory));
            });
            if (decorator instanceof DRepresentationElement && this.buildOpenRepresentationsMenu((IMenuManager)openItem.getInnerItem(), (DRepresentationElement)decorator, session)) {
                openItem.setVisible(true);
            }
        }
    }

    private boolean buildOpenRepresentationsMenu(IMenuManager openMenu, DRepresentationElement element, Session session) {
        RepresentationElementMapping mapping = element.getMapping();
        if (mapping != null) {
            for (RepresentationNavigationDescription navDesc : mapping.getNavigationDescriptions()) {
                boolean append = true;
                if (!this.isFromActiveViewpoint(session, navDesc.getRepresentationDescription())) {
                    append = false;
                }
                IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(element.getTarget());
                HashMap<Object, Object> variables = new HashMap<Object, Object>();
                variables.put(navDesc.getContainerVariable(), element.getTarget());
                variables.put(navDesc.getContainerViewVariable(), element);
                InitInterpreterVariablesTask init = new InitInterpreterVariablesTask(variables, interpreter, (UICallBack)new EMFCommandFactoryUI());
                init.execute();
                String precondition = navDesc.getPrecondition();
                if (append && !StringUtil.isEmpty((String)precondition)) {
                    append = false;
                    try {
                        append = interpreter.evaluateBoolean(element.getTarget(), navDesc.getPrecondition());
                    }
                    catch (EvaluationException e) {
                        RuntimeLoggerManager.INSTANCE.error((EObject)navDesc, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition(), (Throwable)e);
                    }
                }
                if (!append) continue;
                return MenuHelper.buildOpenRepresentationActions((IMenuManager)openMenu, (IInterpreter)interpreter, (RepresentationNavigationDescription)navDesc, (DRepresentationElement)element, (Session)session, (AdapterFactory)this.adapterFactory);
            }
        }
        return false;
    }

    private void addRefreshMenu(IMenuManager manager) {
        manager.add((IAction)this.refreshAction);
    }

    private void addTreeItemMenus(IMenuManager manager) {
        Collection<DTreeItem> selectedItems = this.treeViewManager.getSelectedItems();
        if (selectedItems != null && !selectedItems.isEmpty()) {
            DTreeItem firstSelectedItem;
            manager.add((IContributionItem)new Separator());
            if (selectedItems.size() == 1) {
                firstSelectedItem = selectedItems.iterator().next();
                this.treePopupMenuContributionHandler.contributeToPopupMenu(manager, firstSelectedItem);
            }
            this.addDeleteItemsAction(manager, selectedItems);
            if (selectedItems.size() == 1) {
                firstSelectedItem = selectedItems.iterator().next();
                this.addCreateActions(manager, firstSelectedItem);
            }
        }
    }

    private void addCreateActions(IMenuManager manager, DTreeItem singleSelectedItem) {
        List<AbstractToolAction> createActions;
        TreeItemMapping actualMapping = singleSelectedItem.getActualMapping();
        if (actualMapping != null && (createActions = this.getMappingToCreateActions().get(actualMapping)) != null && !createActions.isEmpty()) {
            for (AbstractToolAction createAction : createActions) {
                ((AbstractToolItemAction)createAction).setLine(singleSelectedItem);
                if (!createAction.canExecute()) continue;
                manager.add((IAction)createAction);
            }
        }
    }

    private void addDeleteItemsAction(IMenuManager manager, Collection<DTreeItem> selectedItems) {
        this.deleteItemsAction.setItems(selectedItems);
        if (this.deleteItemsAction.canExecute()) {
            manager.add((IAction)this.deleteItemsAction);
        }
    }

    private void createDetailsActions(DTreeItem currentElement, SubContributionItem newMenuItem) {
        RepresentationElementMapping mapping = currentElement.getMapping();
        if (mapping != null) {
            Session session;
            Session session2 = session = currentElement.getTarget() != null ? SessionManager.INSTANCE.getSession(currentElement.getTarget()) : null;
            if (session != null) {
                for (RepresentationCreationDescription desc : mapping.getDetailDescriptions()) {
                    boolean append = true;
                    if (!this.isFromActiveViewpoint(session, desc.getRepresentationDescription())) {
                        append = false;
                    }
                    String precondition = desc.getPrecondition();
                    if (append && !StringUtil.isEmpty((String)precondition)) {
                        append = false;
                        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(currentElement.getTarget());
                        try {
                            append = interpreter.evaluateBoolean(currentElement.getTarget(), precondition);
                        }
                        catch (EvaluationException evaluationException) {}
                    }
                    if (!append) continue;
                    newMenuItem.setVisible(true);
                    ((IMenuManager)newMenuItem.getInnerItem()).appendToGroup(NEW_REPRESENTATION_GROUP_SEPARATOR, (IAction)new CreateRepresentationFromRepresentationCreationDescription(desc, (DRepresentationElement)currentElement, this.treeViewManager.getEditingDomain(), this.treeViewManager.getTreeCommandFactory()));
                }
            }
        }
    }

    private boolean isFromActiveViewpoint(Session session, RepresentationDescription representationDescription) {
        Viewpoint vp = ViewpointRegistry.getInstance().getViewpoint(representationDescription);
        return vp != null && session.getSelectedViewpoints(false).contains(vp);
    }

    private boolean isFromActiveViewpoint(Session session, DRepresentation representation) {
        RepresentationDescription description = DialectManager.INSTANCE.getDescription(representation);
        return this.isFromActiveViewpoint(session, description);
    }

    protected Map<TreeMapping, List<AbstractToolAction>> getMappingToCreateActions() {
        return this.mappingToCreateActions;
    }

    public void setMappingToCreateActions(Map<TreeMapping, List<AbstractToolAction>> mappingToCreateActions) {
        this.mappingToCreateActions = mappingToCreateActions;
    }

    protected List<AbstractToolAction> getCreateActionsForTree() {
        return this.createActionsForTree;
    }

    public void setCreateActionsForTree(List<AbstractToolAction> createActionsForTable) {
        this.createActionsForTree = createActionsForTable;
    }
}

