/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.context;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Bits;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.artifact.GavCalculator;
import org.apache.maven.index.artifact.M2GavCalculator;
import org.apache.maven.index.context.AbstractIndexingContext;
import org.apache.maven.index.context.DocumentFilter;
import org.apache.maven.index.context.ExistingLuceneIndexMismatchException;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexUtils;
import org.apache.maven.index.context.NexusAnalyzer;
import org.apache.maven.index.context.NexusIndexSearcherFactory;
import org.apache.maven.index.context.NexusIndexWriter;
import org.apache.maven.index.context.TrackingLockFactory;
import org.codehaus.plexus.util.StringUtils;

public class DefaultIndexingContext
extends AbstractIndexingContext {
    private static final String INDEX_DIRECTORY = ".index";
    public static final String FLD_DESCRIPTOR = "DESCRIPTOR";
    public static final String FLD_DESCRIPTOR_CONTENTS = "NexusIndex";
    public static final String FLD_IDXINFO = "IDXINFO";
    public static final String VERSION = "1.0";
    private static final Term DESCRIPTOR_TERM = new Term("DESCRIPTOR", "NexusIndex");
    private Directory indexDirectory;
    private TrackingLockFactory lockFactory;
    private File indexDirectoryFile;
    private String id;
    private boolean searchable;
    private String repositoryId;
    private File repository;
    private String repositoryUrl;
    private String indexUpdateUrl;
    private NexusIndexWriter indexWriter;
    private SearcherManager searcherManager;
    private Date timestamp;
    private List<? extends IndexCreator> indexCreators;
    private GavCalculator gavCalculator;

    private DefaultIndexingContext(String id, String repositoryId, File repository, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexCreators, Directory indexDirectory, TrackingLockFactory lockFactory, boolean reclaimIndex) throws ExistingLuceneIndexMismatchException, IOException {
        this.id = id;
        this.searchable = true;
        this.repositoryId = repositoryId;
        this.repository = repository;
        this.repositoryUrl = repositoryUrl;
        this.indexUpdateUrl = indexUpdateUrl;
        this.indexWriter = null;
        this.searcherManager = null;
        this.indexCreators = indexCreators;
        this.indexDirectory = indexDirectory;
        this.lockFactory = lockFactory;
        for (IndexCreator indexCreator : indexCreators) {
            indexCreator.getIndexerFields();
        }
        this.gavCalculator = new M2GavCalculator();
        this.prepareIndex(reclaimIndex);
        this.setIndexDirectoryFile(null);
    }

    private DefaultIndexingContext(String id, String repositoryId, File repository, File indexDirectoryFile, TrackingLockFactory lockFactory, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexCreators, boolean reclaimIndex) throws IOException, ExistingLuceneIndexMismatchException {
        this(id, repositoryId, repository, repositoryUrl, indexUpdateUrl, indexCreators, (Directory)FSDirectory.open((Path)indexDirectoryFile.toPath(), (LockFactory)lockFactory), lockFactory, reclaimIndex);
        this.setIndexDirectoryFile(indexDirectoryFile);
    }

    public DefaultIndexingContext(String id, String repositoryId, File repository, File indexDirectoryFile, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexCreators, boolean reclaimIndex) throws IOException, ExistingLuceneIndexMismatchException {
        this(id, repositoryId, repository, indexDirectoryFile, new TrackingLockFactory((LockFactory)FSLockFactory.getDefault()), repositoryUrl, indexUpdateUrl, indexCreators, reclaimIndex);
    }

    @Deprecated
    public DefaultIndexingContext(String id, String repositoryId, File repository, Directory indexDirectory, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexCreators, boolean reclaimIndex) throws IOException, ExistingLuceneIndexMismatchException {
        this(id, repositoryId, repository, repositoryUrl, indexUpdateUrl, indexCreators, indexDirectory, null, reclaimIndex);
        if (indexDirectory instanceof FSDirectory) {
            this.setIndexDirectoryFile(((FSDirectory)indexDirectory).getDirectory().toFile());
        }
    }

    @Override
    public Directory getIndexDirectory() {
        return this.indexDirectory;
    }

    protected void setIndexDirectoryFile(File dir) throws IOException {
        if (dir == null) {
            File tmpFile = File.createTempFile("mindexer-ctx" + this.id, "tmp");
            tmpFile.deleteOnExit();
            tmpFile.delete();
            tmpFile.mkdirs();
            this.indexDirectoryFile = tmpFile;
        } else {
            this.indexDirectoryFile = dir;
        }
    }

    @Override
    public File getIndexDirectoryFile() {
        return this.indexDirectoryFile;
    }

    private void prepareIndex(boolean reclaimIndex) throws IOException, ExistingLuceneIndexMismatchException {
        if (DirectoryReader.indexExists((Directory)this.indexDirectory)) {
            try {
                if (IndexWriter.isLocked((Directory)this.indexDirectory)) {
                    DefaultIndexingContext.unlockForcibly(this.lockFactory, this.indexDirectory);
                }
                this.openAndWarmup();
                this.checkAndUpdateIndexDescriptor(reclaimIndex);
            }
            catch (IOException e) {
                if (reclaimIndex) {
                    this.prepareCleanIndex(true);
                }
                throw e;
            }
        } else {
            this.prepareCleanIndex(false);
        }
        this.timestamp = IndexUtils.getTimestamp(this.indexDirectory);
    }

    private void prepareCleanIndex(boolean deleteExisting) throws IOException {
        if (deleteExisting) {
            this.closeReaders();
            if (IndexWriter.isLocked((Directory)this.indexDirectory)) {
                DefaultIndexingContext.unlockForcibly(this.lockFactory, this.indexDirectory);
            }
            this.deleteIndexFiles(true);
        }
        this.openAndWarmup();
        if (StringUtils.isEmpty((String)this.getRepositoryId())) {
            throw new IllegalArgumentException("The repositoryId cannot be null when creating new repository!");
        }
        this.storeDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndUpdateIndexDescriptor(boolean reclaimIndex) throws IOException, ExistingLuceneIndexMismatchException {
        if (reclaimIndex) {
            this.storeDescriptor();
            return;
        }
        if (this.getSize() > 0) {
            TopScoreDocCollector collector = TopScoreDocCollector.create((int)1);
            IndexSearcher indexSearcher = this.acquireIndexSearcher();
            try {
                indexSearcher.search((Query)new TermQuery(DESCRIPTOR_TERM), (Collector)collector);
                if (collector.getTotalHits() == 0) {
                    throw new ExistingLuceneIndexMismatchException("The existing index has no NexusIndexer descriptor");
                }
                if (collector.getTotalHits() > 1) {
                    this.storeDescriptor();
                    return;
                }
                Document descriptor = indexSearcher.doc(collector.topDocs().scoreDocs[0].doc);
                String[] h = StringUtils.split((String)descriptor.get(FLD_IDXINFO), (String)"|");
                String repoId = h[1];
                if (this.getRepositoryId() == null) {
                    this.repositoryId = repoId;
                } else if (!this.getRepositoryId().equals(repoId)) {
                    throw new ExistingLuceneIndexMismatchException("The existing index is for repository [" + repoId + "] and not for repository [" + this.getRepositoryId() + "]");
                }
            }
            finally {
                this.releaseIndexSearcher(indexSearcher);
            }
        }
    }

    private void storeDescriptor() throws IOException {
        Document hdr = new Document();
        hdr.add((IndexableField)new Field(FLD_DESCRIPTOR, FLD_DESCRIPTOR_CONTENTS, Field.Store.YES, Field.Index.NOT_ANALYZED));
        hdr.add((IndexableField)new Field(FLD_IDXINFO, "1.0|" + this.getRepositoryId(), Field.Store.YES, Field.Index.NO));
        IndexWriter w = this.getIndexWriter();
        w.updateDocument(DESCRIPTOR_TERM, (Iterable)hdr);
        w.commit();
    }

    private void deleteIndexFiles(boolean full) throws IOException {
        if (this.indexDirectory != null) {
            String[] names = this.indexDirectory.listAll();
            if (names != null) {
                for (String name : names) {
                    if (name.equals("nexus-maven-repository-index-packer.properties") || name.equals("nexus-maven-repository-index-updater.properties")) continue;
                    this.indexDirectory.deleteFile(name);
                }
            }
            if (full) {
                try {
                    this.indexDirectory.deleteFile("nexus-maven-repository-index-packer.properties");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.indexDirectory.deleteFile("nexus-maven-repository-index-updater.properties");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            IndexUtils.deleteTimestamp(this.indexDirectory);
        }
    }

    @Override
    public boolean isSearchable() {
        return this.searchable;
    }

    @Override
    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void updateTimestamp() throws IOException {
        this.updateTimestamp(false);
    }

    @Override
    public void updateTimestamp(boolean save) throws IOException {
        this.updateTimestamp(save, new Date());
    }

    @Override
    public void updateTimestamp(boolean save, Date timestamp) throws IOException {
        this.timestamp = timestamp;
        if (save) {
            IndexUtils.updateTimestamp(this.indexDirectory, this.getTimestamp());
        }
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int getSize() throws IOException {
        IndexSearcher is = this.acquireIndexSearcher();
        try {
            int n = is.getIndexReader().numDocs();
            return n;
        }
        finally {
            this.releaseIndexSearcher(is);
        }
    }

    @Override
    public String getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public File getRepository() {
        return this.repository;
    }

    @Override
    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    @Override
    public String getIndexUpdateUrl() {
        if (this.repositoryUrl != null && (this.indexUpdateUrl == null || this.indexUpdateUrl.trim().length() == 0)) {
            return this.repositoryUrl + (this.repositoryUrl.endsWith("/") ? "" : "/") + INDEX_DIRECTORY;
        }
        return this.indexUpdateUrl;
    }

    @Override
    public Analyzer getAnalyzer() {
        return new NexusAnalyzer();
    }

    protected void openAndWarmup() throws IOException {
        if (this.indexWriter != null) {
            this.indexWriter.close();
            this.indexWriter = null;
        }
        if (this.searcherManager != null) {
            this.searcherManager.close();
            this.searcherManager = null;
        }
        this.indexWriter = new NexusIndexWriter(this.getIndexDirectory(), this.getWriterConfig());
        this.indexWriter.commit();
        this.searcherManager = new SearcherManager((IndexWriter)this.indexWriter, false, (SearcherFactory)new NexusIndexSearcherFactory(this));
    }

    protected IndexWriterConfig getWriterConfig() {
        return NexusIndexWriter.defaultConfig();
    }

    @Override
    public IndexWriter getIndexWriter() throws IOException {
        return this.indexWriter;
    }

    @Override
    public IndexSearcher acquireIndexSearcher() throws IOException {
        this.searcherManager.maybeRefresh();
        return (IndexSearcher)this.searcherManager.acquire();
    }

    @Override
    public void releaseIndexSearcher(IndexSearcher is) throws IOException {
        if (is == null) {
            return;
        }
        this.searcherManager.release((Object)is);
    }

    @Override
    public void commit() throws IOException {
        this.getIndexWriter().commit();
    }

    @Override
    public void rollback() throws IOException {
        this.getIndexWriter().rollback();
    }

    @Override
    public synchronized void optimize() throws CorruptIndexException, IOException {
        this.commit();
    }

    @Override
    public synchronized void close(boolean deleteFiles) throws IOException {
        if (this.indexDirectory != null) {
            IndexUtils.updateTimestamp(this.indexDirectory, this.getTimestamp());
            this.closeReaders();
            if (deleteFiles) {
                this.deleteIndexFiles(true);
            }
            this.indexDirectory.close();
        }
        this.indexDirectory = null;
    }

    @Override
    public synchronized void purge() throws IOException {
        this.closeReaders();
        this.deleteIndexFiles(true);
        this.openAndWarmup();
        try {
            this.prepareIndex(true);
        }
        catch (ExistingLuceneIndexMismatchException existingLuceneIndexMismatchException) {
            // empty catch block
        }
        this.rebuildGroups();
        this.updateTimestamp(true, null);
    }

    @Override
    public synchronized void replace(Directory directory) throws IOException {
        this.replace(directory, null, null);
    }

    @Override
    public synchronized void replace(Directory directory, Set<String> allGroups, Set<String> rootGroups) throws IOException {
        Date ts = IndexUtils.getTimestamp(directory);
        this.closeReaders();
        this.deleteIndexFiles(false);
        IndexUtils.copyDirectory(directory, this.indexDirectory);
        this.openAndWarmup();
        this.storeDescriptor();
        if (allGroups == null && rootGroups == null) {
            this.rebuildGroups();
        } else {
            if (allGroups != null) {
                this.setAllGroups(allGroups);
            }
            if (rootGroups != null) {
                this.setRootGroups(rootGroups);
            }
        }
        this.updateTimestamp(true, ts);
        this.optimize();
    }

    @Override
    public synchronized void merge(Directory directory) throws IOException {
        this.merge(directory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void merge(Directory directory, DocumentFilter filter) throws IOException {
        IndexSearcher s = this.acquireIndexSearcher();
        try {
            IndexWriter w = this.getIndexWriter();
            DirectoryReader directoryReader = DirectoryReader.open((Directory)directory);
            TopScoreDocCollector collector = null;
            try {
                int numDocs = directoryReader.maxDoc();
                Bits liveDocs = MultiFields.getLiveDocs((IndexReader)directoryReader);
                for (int i = 0; i < numDocs; ++i) {
                    if (liveDocs != null && !liveDocs.get(i)) continue;
                    Document d = directoryReader.document(i);
                    if (filter != null && !filter.accept(d)) continue;
                    String uinfo = d.get(ArtifactInfo.UINFO);
                    if (uinfo != null) {
                        collector = TopScoreDocCollector.create((int)1);
                        s.search((Query)new TermQuery(new Term(ArtifactInfo.UINFO, uinfo)), (Collector)collector);
                        if (collector.getTotalHits() != 0) continue;
                        w.addDocument((Iterable)IndexUtils.updateDocument(d, this, false));
                        continue;
                    }
                    String deleted = d.get(ArtifactInfo.DELETED);
                    if (deleted == null) continue;
                    w.deleteDocuments(new Term[]{new Term(ArtifactInfo.UINFO, deleted)});
                    w.addDocument((Iterable)d);
                }
            }
            finally {
                directoryReader.close();
                this.commit();
            }
            this.rebuildGroups();
            Date mergedTimestamp = IndexUtils.getTimestamp(directory);
            if (this.getTimestamp() != null && mergedTimestamp != null && mergedTimestamp.after(this.getTimestamp())) {
                this.updateTimestamp(true, mergedTimestamp);
            } else {
                this.updateTimestamp(true);
            }
            this.optimize();
        }
        finally {
            this.releaseIndexSearcher(s);
        }
    }

    private void closeReaders() throws CorruptIndexException, IOException {
        if (this.searcherManager != null) {
            this.searcherManager.close();
            this.searcherManager = null;
        }
        if (this.indexWriter != null) {
            this.indexWriter.close();
            this.indexWriter = null;
        }
    }

    @Override
    public GavCalculator getGavCalculator() {
        return this.gavCalculator;
    }

    @Override
    public List<IndexCreator> getIndexCreators() {
        return Collections.unmodifiableList(this.indexCreators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void rebuildGroups() throws IOException {
        IndexSearcher is = this.acquireIndexSearcher();
        try {
            IndexReader r = is.getIndexReader();
            LinkedHashSet<String> rootGroups = new LinkedHashSet<String>();
            LinkedHashSet<String> allGroups = new LinkedHashSet<String>();
            int numDocs = r.maxDoc();
            Bits liveDocs = MultiFields.getLiveDocs((IndexReader)r);
            for (int i = 0; i < numDocs; ++i) {
                Document d;
                String uinfo;
                if (liveDocs != null && !liveDocs.get(i) || (uinfo = (d = r.document(i)).get(ArtifactInfo.UINFO)) == null) continue;
                ArtifactInfo info = IndexUtils.constructArtifactInfo(d, this);
                rootGroups.add(info.getRootGroup());
                allGroups.add(info.getGroupId());
            }
            this.setRootGroups(rootGroups);
            this.setAllGroups(allGroups);
            this.optimize();
        }
        finally {
            this.releaseIndexSearcher(is);
        }
    }

    @Override
    public Set<String> getAllGroups() throws IOException {
        return this.getGroups("allGroups", "allGroups", "allGroupsList");
    }

    @Override
    public synchronized void setAllGroups(Collection<String> groups) throws IOException {
        this.setGroups(groups, "allGroups", "allGroups", "allGroupsList");
        this.commit();
    }

    @Override
    public Set<String> getRootGroups() throws IOException {
        return this.getGroups("rootGroups", "rootGroups", "rootGroupsList");
    }

    @Override
    public synchronized void setRootGroups(Collection<String> groups) throws IOException {
        this.setGroups(groups, "rootGroups", "rootGroups", "rootGroupsList");
        this.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getGroups(String field, String filedValue, String listField) throws IOException, CorruptIndexException {
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)1);
        IndexSearcher indexSearcher = this.acquireIndexSearcher();
        try {
            Document doc;
            String groupList;
            indexSearcher.search((Query)new TermQuery(new Term(field, filedValue)), (Collector)collector);
            TopDocs topDocs = collector.topDocs();
            LinkedHashSet<String> groups = new LinkedHashSet<String>(Math.max(10, topDocs.totalHits));
            if (topDocs.totalHits > 0 && (groupList = (doc = indexSearcher.doc(topDocs.scoreDocs[0].doc)).get(listField)) != null) {
                groups.addAll(Arrays.asList(groupList.split("\\|")));
            }
            LinkedHashSet<String> linkedHashSet = groups;
            return linkedHashSet;
        }
        finally {
            this.releaseIndexSearcher(indexSearcher);
        }
    }

    protected void setGroups(Collection<String> groups, String groupField, String groupFieldValue, String groupListField) throws IOException, CorruptIndexException {
        IndexWriter w = this.getIndexWriter();
        w.updateDocument(new Term(groupField, groupFieldValue), (Iterable)this.createGroupsDocument(groups, groupField, groupFieldValue, groupListField));
    }

    protected Document createGroupsDocument(Collection<String> groups, String field, String fieldValue, String listField) {
        Document groupDoc = new Document();
        groupDoc.add((IndexableField)new Field(field, fieldValue, Field.Store.YES, Field.Index.NOT_ANALYZED));
        groupDoc.add((IndexableField)new Field(listField, ArtifactInfo.lst2str(groups), Field.Store.YES, Field.Index.NO));
        return groupDoc;
    }

    public String toString() {
        return this.id + " : " + this.timestamp;
    }

    private static void unlockForcibly(TrackingLockFactory lockFactory, Directory dir) throws IOException {
        FSDirectory fsdir;
        Path dirPath;
        if (lockFactory != null) {
            Set<? extends Lock> emittedLocks = lockFactory.getEmittedLocks("write.lock");
            for (Lock lock : emittedLocks) {
                lock.close();
            }
        }
        if (dir instanceof FSDirectory && Files.isDirectory(dirPath = (fsdir = (FSDirectory)dir).getDirectory(), new LinkOption[0])) {
            Path path;
            Path path2 = dirPath.resolve("write.lock");
            try {
                path = path2.toRealPath(new LinkOption[0]);
            }
            catch (IOException ioe) {
                return;
            }
            try (FileChannel fc = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
                FileLock lck = fc.tryLock();
                if (lck == null) {
                    throw new LockObtainFailedException("Lock held by another process: " + path);
                }
                lck.close();
            }
            Files.delete(path);
        }
    }
}

