/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.dialogs;

import fr.inria.aoste.timesquare.utils.ui.idialog.BasedDialog;
import fr.inria.aoste.timesquare.vcd.IVcdDiagram;
import fr.inria.aoste.timesquare.vcd.ListConnections;
import fr.inria.aoste.timesquare.vcd.model.IVar;
import fr.inria.aoste.timesquare.vcd.model.comment.ConstraintCommentCommand;
import java.util.ArrayList;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class SelectClocksDialog
extends BasedDialog<IVar> {
    protected boolean f = true;

    public SelectClocksDialog(Shell parentShell, ArrayList<IVar> a, ArrayList<IVar> b, String st1, String st2, String title) {
        super(parentShell, st1, st2, title);
        this.labelProvider = new MyLabelProvider();
        if (a.size() == 0) {
            this.f = false;
        }
        for (IVar var : b) {
            this.elselect.addElement((Object)var);
        }
        for (IVar var : a) {
            this.elsource.addElement((Object)var);
        }
    }

    public ArrayList<IVar> getSrc() {
        return this.elsource.getElements();
    }

    public ArrayList<IVar> added() {
        ArrayList l = this.getSelectedElements();
        ArrayList<IVar> la = new ArrayList<IVar>();
        for (IVar o : l) {
            la.add(o);
        }
        return la;
    }

    public int apply(IVcdDiagram ivcd) {
        ivcd.getCanvas().getContents().getChildren().clear();
        ivcd.getNames().getContents().getChildren().clear();
        ListConnections list = ivcd.getListConnections();
        list.clear();
        ivcd.getTraceCollector().setAllClocks(this.getSrc());
        ivcd.getVcdFactory().clear2();
        ivcd.getTraceCollector().constructClock(ivcd.getVcdFactory(), this.added(), ivcd.getTraceZoomValue());
        ivcd.getVcdFactory().getNameforfigures().clear();
        ivcd.getTraceCollector().setZoom(ivcd.getTraceZoomValue());
        ivcd.getVcdModel().visit(ivcd.getTraceCollector());
        ivcd.getNames().setContents((IFigure)ivcd.getVcdFactory().getNames());
        ivcd.getCanvas().setContents((IFigure)ivcd.getVcdFactory().getBackPanel());
        for (MenuItem menuitem : list.getMenuForComment().keySet()) {
            if (!menuitem.getSelection()) continue;
            ConstraintCommentCommand cc = list.getMenuForComment().get(menuitem);
            Color color = list.menuForColorGet(menuitem);
            ivcd.getConstraintsFactory().drawSyncInterval(cc, color);
        }
        int y = ivcd.getVcdFactory().getHeigth();
        int x = ivcd.getVcdFactory().getWindowsBoundsLength();
        ivcd.getCanvas().getContents().setPreferredSize(new Dimension(x, y));
        ivcd.getNames().getContents().setPreferredSize(new Dimension(120, y));
        ivcd.getCanvas().redraw();
        ivcd.getNames().redraw();
        ivcd.getfcb().scrollUpdate();
        ivcd.getVcdzoom().applyScrollZoom();
        if (ivcd.isGhostMode() != null && ivcd.isGhostMode().isHide()) {
            ivcd.getConstraintsFactory().hideAllGhost();
        }
        return 0;
    }

    protected static class MyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected MyLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object o) {
            if (o instanceof IVar) {
                return ((IVar)o).getAliasName();
            }
            return o.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getText(element);
            }
            if (columnIndex == 1) {
                return "toto";
            }
            return "not the right column index";
        }
    }
}

