/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.menu;

import fr.inria.aoste.timesquare.vcd.IVcdDiagram;
import fr.inria.aoste.timesquare.vcd.ListConnections;
import fr.inria.aoste.timesquare.vcd.action.ActionSync;
import fr.inria.aoste.timesquare.vcd.action.FindAction;
import fr.inria.aoste.timesquare.vcd.action.OrderAction;
import fr.inria.aoste.timesquare.vcd.action.PrinterAction;
import fr.inria.aoste.timesquare.vcd.menu.GhostAction;
import fr.inria.aoste.timesquare.vcd.menu.Mode;
import fr.inria.aoste.timesquare.vcd.model.Function;
import fr.inria.aoste.timesquare.vcd.model.comment.ConstraintCommentCommand;
import fr.inria.aoste.timesquare.vcd.preferences.VcdColorPreferences;
import java.util.ArrayList;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class VcdMenu {
    private IVcdDiagram _vcdDiagram;
    private Action _refreshAction;
    private GhostAction _showGhostAction;
    private GhostAction _hideGhostAction;
    private GhostAction _partialGhostAction;
    private Action _orderAction;
    private Action _vcdOption;
    private FindAction _findAction;
    private PrinterAction _printAction;
    private ArrayList<ActionSync> _syncAction = new ArrayList();
    ListConnections _listConnections;

    public VcdMenu(IVcdDiagram vcdDiagram) {
        this._vcdDiagram = vcdDiagram;
        this._listConnections = vcdDiagram.getListConnections();
        this._showGhostAction = new GhostAction(vcdDiagram, "&Show all ghost", 8, 0);
        this._showGhostAction.setToolTipText("&Use to show ghost instants");
        this._hideGhostAction = new GhostAction(vcdDiagram, "&Hide all ghost", 8, 1);
        this._hideGhostAction.setToolTipText("&Use to hide ghost instants");
        this._partialGhostAction = new GhostAction(vcdDiagram, "&Partial ...", 8, 2);
        this._partialGhostAction.setToolTipText("&Use to show or hide ghost instants");
        this._findAction = new FindAction(vcdDiagram);
        this._findAction.setText("&Find");
        this._printAction = new PrinterAction(vcdDiagram);
        this._printAction.setText("&Print");
        this.setGhostSelected(Mode.hide);
        this._orderAction = new OrderAction(vcdDiagram);
        this._orderAction.setText("&Ordering ...");
        this._orderAction.setToolTipText("&Use to hide show and move clock");
        this._vcdOption = this.getVCDOption();
    }

    public FindAction getFindAction() {
        this._findAction.setText("&Find");
        return this._findAction;
    }

    public Action getOrderAction() {
        return this._orderAction;
    }

    public PrinterAction getPrinterAction() {
        this._printAction.setText("&Print");
        return this._printAction;
    }

    public Action getVCDOption() {
        if (this._vcdOption == null) {
            this._vcdOption = new Action(){

                public void run() {
                    try {
                        PreferencesUtil.createPreferenceDialogOn((Shell)new Shell(), (String)"fr.inria.aoste.timesquare.vcd.preferences.VCDeditorPreferencePage", null, null).open();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            };
        }
        this._vcdOption.setText("&Vcd Option");
        return this._vcdOption;
    }

    public Action getRefreshAction() {
        if (this._refreshAction == null) {
            this._refreshAction = new Action(){

                public void run() {
                    try {
                        VcdMenu.this._vcdDiagram.vcdMultiPageEditorRefresh();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            };
        }
        this._refreshAction.setText("&Refresh");
        return this._refreshAction;
    }

    public Action getShowGhostAction() {
        this._showGhostAction.setEnabled(this._vcdDiagram.isContainGhost());
        return this._showGhostAction;
    }

    public Action getHideGhostAction() {
        this._hideGhostAction.setEnabled(this._vcdDiagram.isContainGhost());
        return this._hideGhostAction;
    }

    public Action getPartialGhostAction() {
        this._partialGhostAction.setEnabled(this._vcdDiagram.isContainGhost());
        return this._partialGhostAction;
    }

    public void setGhostSelected(Mode n) {
        if (n == null) {
            return;
        }
        this._showGhostAction.setChecked(n.isShow());
        this._hideGhostAction.setChecked(n.isHide());
        this._partialGhostAction.setChecked(n.isPartial());
    }

    public Mode getGhostSelected() {
        if (this._showGhostAction.isChecked()) {
            return Mode.show;
        }
        if (this._hideGhostAction.isChecked()) {
            return Mode.hide;
        }
        if (this._partialGhostAction.isChecked()) {
            return Mode.partial;
        }
        return null;
    }

    public ArrayList<ActionSync> getSyncAction() {
        VcdColorPreferences mca = this._vcdDiagram.getColorPreferences();
        if (mca == null) {
            return this._syncAction;
        }
        if (this._syncAction.isEmpty()) {
            int i = 0;
            ArrayList<String> clocksNames = new ArrayList<String>();
            Color color = mca.colorLightGraySync();
            for (ConstraintCommentCommand constraintCC : this._vcdDiagram.getVcdModel().getConstraintCommentCommand()) {
                if (constraintCC.getFunction() != Function._synchronizeswith) continue;
                if (i % 3 == 0) {
                    color = mca.colorLightGraySync();
                }
                if (i % 3 == 1) {
                    color = mca.colorLightBlueSync();
                }
                if (i % 3 == 2) {
                    color = mca.colorRedSync();
                }
                clocksNames.add(constraintCC.getClock());
                this._listConnections.getListInterval().put(constraintCC, new ArrayList());
                this._listConnections.firstClock1Put(constraintCC, new ArrayList<IFigure>());
                this._listConnections.firstClock2Put(constraintCC, new ArrayList<IFigure>());
                this._listConnections.lastClock1Put(constraintCC, new ArrayList<IFigure>());
                this._listConnections.lastClock2Put(constraintCC, new ArrayList<IFigure>());
                ActionSync as = new ActionSync(this._vcdDiagram, constraintCC, 2);
                as.setColor(color);
                this._syncAction.add(as);
                this._listConnections.actionForCommentPut(this._syncAction.get(i), constraintCC);
                this._listConnections.actionColorPut(this._syncAction.get(i), color);
                this._syncAction.get(i).setToolTipText("&Use to hide or show synchronized interval");
                ++i;
            }
        }
        return this._syncAction;
    }

    public int clear() {
        this._listConnections = null;
        this._vcdDiagram = null;
        this._refreshAction = null;
        this._showGhostAction = null;
        this._hideGhostAction = null;
        this._partialGhostAction = null;
        this._orderAction = null;
        if (this._findAction != null) {
            this._findAction.setAccelerator(-1);
        }
        this._findAction = null;
        if (this._printAction != null) {
            this._printAction.setAccelerator(-1);
        }
        this._printAction = null;
        return 0;
    }
}

