/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.compiler.codemodel;

import fr.inria.aoste.timesquare.ccslkernel.compiler.CompilerParameters;
import fr.inria.aoste.timesquare.ccslkernel.compiler.codemodel.AbstractStatement;
import fr.inria.aoste.timesquare.ccslkernel.compiler.codemodel.SimpleStatement;
import java.util.ArrayList;
import java.util.List;

public class IfStatement
extends AbstractStatement {
    private String testCode;
    private List<AbstractStatement> thenStatements;
    private List<AbstractStatement> elseStatements;

    public IfStatement() {
    }

    public IfStatement(String testCode) {
        this.testCode = testCode;
    }

    public void setTestCode(String code) {
        this.testCode = code;
    }

    public IfStatement addThenStatement(AbstractStatement statement) {
        if (this.thenStatements == null) {
            this.thenStatements = new ArrayList<AbstractStatement>();
        }
        this.thenStatements.add(statement);
        return this;
    }

    public IfStatement addThenStatement(String code) {
        return this.addThenStatement(new SimpleStatement(code));
    }

    public IfStatement addElseStatement(AbstractStatement statement) {
        if (this.elseStatements == null) {
            this.elseStatements = new ArrayList<AbstractStatement>();
        }
        this.elseStatements.add(statement);
        return this;
    }

    public IfStatement addElseStatement(String code) {
        return this.addElseStatement(new SimpleStatement(code));
    }

    @Override
    public void generate(StringBuilder sb, int indent) {
        this.indent(sb, indent);
        sb.append("if ( " + this.testCode + " ) {\n");
        if (this.thenStatements != null) {
            for (AbstractStatement st : this.thenStatements) {
                st.generate(sb, indent + CompilerParameters.indentStep);
            }
        }
        this.indent(sb, indent);
        sb.append("}\n");
        if (this.elseStatements != null && !this.elseStatements.isEmpty()) {
            this.indent(sb, indent);
            if (this.elseStatements.size() == 1 && this.elseStatements.get(0) instanceof IfStatement) {
                sb.append("else ");
                this.elseStatements.get(0).generate(sb, indent);
            } else {
                sb.append("else {\n");
                for (AbstractStatement st : this.elseStatements) {
                    st.generate(sb, indent + CompilerParameters.indentStep);
                }
                this.indent(sb, indent);
                sb.append("}\n");
            }
        }
    }
}

