/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.properties;

import org.eclipse.egit.ui.internal.properties.GitPropertyDescriptor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class MessagePropertyDescriptor
extends GitPropertyDescriptor {
    private final String message;
    private final PropertySheetPage page;

    public MessagePropertyDescriptor(Object id, String label, String message, PropertySheetPage page) {
        super(id, label);
        this.message = message;
        this.page = page;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        if (StringUtils.isEmptyOrNull((String)this.message)) {
            return null;
        }
        return new PopupCellEditor(parent);
    }

    private static class FocusPopupAction
    extends Action {
        private IInformationControl popup;

        FocusPopupAction() {
        }

        void setPopup(IInformationControl control) {
            this.popup = control;
            this.setEnabled(control != null);
        }

        public String getId() {
            return "ShowInformation";
        }

        public String getActionDefinitionId() {
            return "org.eclipse.ui.edit.text.showInformation";
        }

        public void run() {
            if (this.popup != null) {
                this.popup.setFocus();
            }
        }
    }

    private class PopupCellEditor
    extends CellEditor {
        private Label editor;
        private Tree tree;
        private TreeItem mySelf;
        private Object content;
        private AbstractInformationControlManager popupControlManager;

        PopupCellEditor(Composite parent) {
            super(parent);
        }

        protected Control createControl(Composite parent) {
            this.tree = (Tree)parent;
            this.editor = new Label(parent, 16384);
            this.editor.setBackground(parent.getDisplay().getSystemColor(37));
            return this.editor;
        }

        protected Object doGetValue() {
            return this.content;
        }

        protected void doSetValue(Object value) {
            this.content = value;
        }

        protected void doSetFocus() {
            FocusPopupAction focusAction;
            if (this.popupControlManager != null) {
                this.deactivate();
                return;
            }
            Rectangle bounds = this.editor.getBounds();
            Composite parent = this.editor.getParent();
            this.deactivate();
            IActionBars bars = MessagePropertyDescriptor.this.page.getSite().getActionBars();
            IAction existingAction = bars.getGlobalActionHandler("ShowInformation");
            if (existingAction == null || !(existingAction instanceof FocusPopupAction)) {
                focusAction = new FocusPopupAction();
                bars.setGlobalActionHandler(focusAction.getId(), (IAction)focusAction);
                bars.updateActionBars();
            } else {
                existingAction.setEnabled(true);
                focusAction = (FocusPopupAction)existingAction;
            }
            final IContextService ctxSrv = (IContextService)MessagePropertyDescriptor.this.page.getSite().getService(IContextService.class);
            final IContextActivation[] ctxActivation = new IContextActivation[]{ctxSrv.activateContext("org.eclipse.ui.textEditorScope")};
            IInformationControlCreator popupCreator = parentShell -> new DefaultInformationControl(parentShell, EditorsUI.getTooltipAffordanceString(), null);
            class Manager
            extends AbstractInformationControlManager {
                private final /* synthetic */ Rectangle val$bounds;

                Manager(IInformationControlCreator creator, Rectangle rectangle) {
                    this.val$bounds = rectangle;
                    super(creator);
                }

                protected void setCloser(AbstractInformationControlManager.IInformationControlCloser closer) {
                    super.setCloser(closer);
                }

                protected void computeInformation() {
                    this.setInformation(MessagePropertyDescriptor.this.message, this.val$bounds);
                }
            }
            Manager popupManager = new Manager(popupCreator, bounds);
            AbstractInformationControlManager.IInformationControlCloser closer = new AbstractInformationControlManager.IInformationControlCloser(){
                private Control subject;
                private IInformationControl popup;
                private Listener subjectListener;
                private FocusListener focusListener;
                private Display display;

                public void setSubjectControl(Control subject) {
                    this.subject = subject;
                    if (subject != null) {
                        this.display = subject.getDisplay();
                    }
                }

                public void setInformationControl(IInformationControl control) {
                    focusAction.setPopup(control);
                    if (control != null) {
                        this.popup = control;
                    } else if (ctxActivation[0] != null) {
                        ctxSrv.deactivateContext(ctxActivation[0]);
                        ctxActivation[0] = null;
                    }
                }

                public void start(Rectangle subjectArea) {
                    if (this.subject != null && this.popup != null) {
                        this.hookSubject();
                        this.popup.addDisposeListener(event -> {
                            focusAction.setPopup(null);
                            this.unhookSubject();
                            if (PopupCellEditor.this.popupControlManager != null) {
                                PopupCellEditor.this.popupControlManager.dispose();
                                PopupCellEditor.this.popupControlManager = null;
                            }
                        });
                        this.focusListener = new FocusListener(){

                            public void focusGained(FocusEvent e) {
                            }

                            public void focusLost(FocusEvent e) {
                                popup.dispose();
                            }
                        };
                        this.popup.addFocusListener(this.focusListener);
                    }
                }

                public void stop() {
                    this.unhookSubject();
                    if (this.popup != null) {
                        if (this.focusListener != null) {
                            this.popup.removeFocusListener(this.focusListener);
                            this.focusListener = null;
                        }
                        this.popup = null;
                    }
                }

                private void hookSubject() {
                    if (this.subject == null || this.popup == null) {
                        return;
                    }
                    this.subjectListener = event -> {
                        switch (event.type) {
                            case 13: {
                                if (event.item == PopupCellEditor.this.mySelf || this.popup == null) break;
                                this.popup.dispose();
                                this.popup = null;
                                break;
                            }
                            case 10: 
                            case 11: 
                            case 12: 
                            case 17: 
                            case 18: 
                            case 37: {
                                if (this.popup == null) break;
                                this.popup.dispose();
                                this.popup = null;
                                break;
                            }
                            case 16: 
                            case 27: {
                                this.display.asyncExec(() -> {
                                    if (this.popup != null && !this.popup.isFocusControl()) {
                                        this.popup.dispose();
                                        this.popup = null;
                                    }
                                });
                                break;
                            }
                        }
                    };
                    this.subject.addListener(13, this.subjectListener);
                    this.subject.addListener(12, this.subjectListener);
                    this.subject.addListener(27, this.subjectListener);
                    this.subject.addListener(16, this.subjectListener);
                    this.subject.addListener(37, this.subjectListener);
                    this.subject.addListener(11, this.subjectListener);
                    this.subject.addListener(10, this.subjectListener);
                    this.subject.addListener(17, this.subjectListener);
                    this.subject.addListener(18, this.subjectListener);
                    if (this.subject instanceof Composite) {
                        Composite composite = (Composite)this.subject;
                        ScrollBar scroll = composite.getHorizontalBar();
                        if (scroll != null) {
                            scroll.addListener(13, this.subjectListener);
                        }
                        if ((scroll = composite.getVerticalBar()) != null) {
                            scroll.addListener(13, this.subjectListener);
                        }
                    }
                    this.subject.getShell().addListener(27, this.subjectListener);
                }

                private void unhookSubject() {
                    Shell shell;
                    if (this.subject == null || this.subjectListener == null) {
                        return;
                    }
                    this.subject.removeListener(13, this.subjectListener);
                    this.subject.removeListener(12, this.subjectListener);
                    this.subject.removeListener(27, this.subjectListener);
                    this.subject.removeListener(16, this.subjectListener);
                    this.subject.removeListener(37, this.subjectListener);
                    this.subject.removeListener(11, this.subjectListener);
                    this.subject.removeListener(10, this.subjectListener);
                    this.subject.removeListener(17, this.subjectListener);
                    this.subject.removeListener(18, this.subjectListener);
                    if (this.subject instanceof Composite) {
                        Composite composite = (Composite)this.subject;
                        ScrollBar scroll = composite.getHorizontalBar();
                        if (scroll != null) {
                            scroll.removeListener(13, this.subjectListener);
                        }
                        if ((scroll = composite.getVerticalBar()) != null) {
                            scroll.removeListener(13, this.subjectListener);
                        }
                    }
                    if ((shell = this.subject.getShell()) != null) {
                        shell.removeListener(27, this.subjectListener);
                    }
                    this.subjectListener = null;
                }
            };
            popupManager.setCloser(closer);
            this.popupControlManager = popupManager;
            TreeItem[] selection = this.tree.getSelection();
            this.mySelf = selection == null || selection.length == 0 ? null : selection[0];
            popupManager.install((Control)parent);
            popupManager.showInformation();
        }
    }
}

