/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.CachingRepository;
import org.eclipse.egit.core.RepositoryHandle;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.events.ConfigChangedEvent;
import org.eclipse.jgit.events.IndexChangedEvent;
import org.eclipse.jgit.events.ListenerList;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.events.WorkingTreeModifiedEvent;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;
import org.eclipse.jgit.lib.Repository;

public class RepositoryCache {
    private static final RepositoryCache INSTANCE = new RepositoryCache();
    private final ReferenceQueue<RepositoryHandle> queue = new ReferenceQueue();
    private final Map<File, RepositoryReference> repositoryCache = new HashMap<File, RepositoryReference>();
    private final ListenerList globalListeners = new ListenerList();

    public static RepositoryCache getInstance() {
        return INSTANCE;
    }

    private RepositoryCache() {
        new Closer(this.queue).start();
        ListenerList global = Repository.getGlobalListenerList();
        global.addConfigChangedListener(event -> {
            Repository repo = this.getRepository(event.getRepository().getDirectory());
            if (repo == null || repo == event.getRepository()) {
                this.globalListeners.dispatch((RepositoryEvent)event);
            } else {
                ConfigChangedEvent newEvent = new ConfigChangedEvent();
                newEvent.setRepository(repo);
                this.globalListeners.dispatch((RepositoryEvent)newEvent);
            }
        });
        global.addIndexChangedListener(event -> {
            Repository repo = this.getRepository(event.getRepository().getDirectory());
            if (repo == null || repo == event.getRepository()) {
                this.globalListeners.dispatch((RepositoryEvent)event);
            } else {
                IndexChangedEvent newEvent = new IndexChangedEvent(event.isInternal());
                newEvent.setRepository(repo);
                this.globalListeners.dispatch((RepositoryEvent)newEvent);
            }
        });
        global.addRefsChangedListener(event -> {
            Repository repo = this.getRepository(event.getRepository().getDirectory());
            if (repo == null || repo == event.getRepository()) {
                this.globalListeners.dispatch((RepositoryEvent)event);
            } else {
                RefsChangedEvent newEvent = new RefsChangedEvent();
                newEvent.setRepository(repo);
                this.globalListeners.dispatch((RepositoryEvent)newEvent);
            }
        });
        global.addWorkingTreeModifiedListener(event -> {
            Repository repo = this.getRepository(event.getRepository().getDirectory());
            if (repo == null || repo == event.getRepository()) {
                this.globalListeners.dispatch((RepositoryEvent)event);
            } else {
                WorkingTreeModifiedEvent newEvent = new WorkingTreeModifiedEvent(event.getModified(), event.getDeleted());
                newEvent.setRepository(repo);
                this.globalListeners.dispatch((RepositoryEvent)newEvent);
            }
        });
    }

    public ListenerList getGlobalListenerList() {
        return this.globalListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository lookupRepository(File gitDir) throws IOException {
        File normalizedGitDir = new Path(gitDir.getAbsolutePath()).toFile();
        Map<File, RepositoryReference> map = this.repositoryCache;
        synchronized (map) {
            RepositoryReference r = this.repositoryCache.get(normalizedGitDir);
            if (r == null) {
                CachingRepository inner = ((Builder)((Builder)new Builder().setGitDir(normalizedGitDir).readEnvironment()).setup()).createRepository();
                RepositoryHandle result = new RepositoryHandle((Repository)inner);
                this.repositoryCache.put(normalizedGitDir, new RepositoryReference(result, (Repository)inner, this.queue));
                return result;
            }
            Repository result = (Repository)r.get();
            if (result != null && result.getDirectory().exists()) {
                return result;
            }
            Closer.closeReference(this.repositoryCache.remove(normalizedGitDir));
        }
        IndexDiffCache cache = IndexDiffCache.getInstance();
        if (cache != null) {
            cache.remove(normalizedGitDir);
        }
        return this.lookupRepository(gitDir);
    }

    public BaseRepositoryBuilder<? extends BaseRepositoryBuilder, ? extends Repository> getBuilder(final boolean preventClose, final boolean cache) {
        return new Builder(this){

            @Override
            public RepositoryHandle build() throws IOException {
                Repository inner;
                RepositoryHandle result = super.build();
                if (preventClose) {
                    result.incrementOpen();
                }
                if (cache && (inner = result.getDelegate()) instanceof CachingRepository) {
                    ((CachingRepository)inner).cacheConfig(true);
                }
                return result;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getRepository(File gitDir) {
        if (gitDir == null) {
            return null;
        }
        File normalizedGitDir = new Path(gitDir.getAbsolutePath()).toFile();
        Map<File, RepositoryReference> map = this.repositoryCache;
        synchronized (map) {
            RepositoryReference r;
            block7: {
                r = this.repositoryCache.get(normalizedGitDir);
                if (r != null) break block7;
                return null;
            }
            Repository result = (Repository)r.get();
            if (result != null && result.getDirectory().exists()) {
                return result;
            }
            Closer.closeReference(this.repositoryCache.remove(normalizedGitDir));
        }
        IndexDiffCache cache = IndexDiffCache.getInstance();
        if (cache != null) {
            cache.remove(normalizedGitDir);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository[] getAllRepositories() {
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        ArrayList<File> toRemove = new ArrayList<File>();
        Map<File, RepositoryReference> map = this.repositoryCache;
        synchronized (map) {
            Iterator<Map.Entry<File, RepositoryReference>> i = this.repositoryCache.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<File, RepositoryReference> entry = i.next();
                Repository repository = (Repository)entry.getValue().get();
                if (repository == null || !repository.getDirectory().exists()) {
                    i.remove();
                    Closer.closeReference(entry.getValue());
                    toRemove.add(entry.getKey());
                    continue;
                }
                repositories.add(repository);
            }
        }
        this.removeIndexDiffCaches(toRemove);
        return repositories.toArray(new Repository[0]);
    }

    public Repository getRepository(IResource resource) {
        IPath location = resource.getLocation();
        return location == null ? null : this.getRepository(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getRepository(IPath location) {
        if (location == null) {
            return null;
        }
        Repository repository = null;
        int largestSegmentCount = 0;
        ArrayList<File> toRemove = new ArrayList<File>();
        Map<File, RepositoryReference> map = this.repositoryCache;
        synchronized (map) {
            Iterator<Map.Entry<File, RepositoryReference>> i = this.repositoryCache.entrySet().iterator();
            while (i.hasNext()) {
                Path repoPath;
                Map.Entry<File, RepositoryReference> entry = i.next();
                Repository repo = (Repository)entry.getValue().get();
                if (repo == null) {
                    i.remove();
                    Closer.closeReference(entry.getValue());
                    toRemove.add(entry.getKey());
                    continue;
                }
                if (repo.isBare() || !(repoPath = new Path(repo.getWorkTree().getAbsolutePath())).isPrefixOf(location) || repository != null && repoPath.segmentCount() <= largestSegmentCount) continue;
                if (!repo.getDirectory().exists()) {
                    i.remove();
                    Closer.closeReference(entry.getValue());
                    toRemove.add(entry.getKey());
                    continue;
                }
                repository = repo;
                largestSegmentCount = repoPath.segmentCount();
            }
        }
        this.removeIndexDiffCaches(toRemove);
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<RepositoryReference> references;
        ArrayList<File> gitDirs;
        Map<File, RepositoryReference> map = this.repositoryCache;
        synchronized (map) {
            gitDirs = new ArrayList<File>(this.repositoryCache.keySet());
            references = new ArrayList<RepositoryReference>(this.repositoryCache.values());
            this.repositoryCache.clear();
        }
        this.removeIndexDiffCaches(gitDirs);
        references.forEach(Closer::closeReference);
    }

    private void removeIndexDiffCaches(List<File> gitDirs) {
        IndexDiffCache cache;
        if (!gitDirs.isEmpty() && (cache = IndexDiffCache.getInstance()) != null) {
            for (File f : gitDirs) {
                cache.remove(f);
            }
        }
    }

    private class Builder
    extends BaseRepositoryBuilder<Builder, RepositoryHandle> {
        private Builder() {
        }

        public Builder setGitDir(File gitDir) {
            File normalizedGitDir = new Path(gitDir.getAbsolutePath()).toFile();
            return (Builder)super.setGitDir(normalizedGitDir);
        }

        public CachingRepository createRepository() throws IOException {
            CachingRepository repo = new CachingRepository(this);
            if (this.isMustExist() && !repo.getObjectDatabase().exists()) {
                throw new RepositoryNotFoundException(this.getGitDir());
            }
            return repo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public RepositoryHandle build() throws IOException {
            this.setup();
            File gitDir = this.getGitDir();
            RepositoryHandle result = null;
            boolean removeCache = false;
            try {
                Map map = RepositoryCache.this.repositoryCache;
                synchronized (map) {
                    Reference r = (Reference)RepositoryCache.this.repositoryCache.get(gitDir);
                    if (r != null) {
                        RepositoryHandle cached = (RepositoryHandle)((Object)r.get());
                        if (cached != null && cached.getDirectory().exists()) {
                            RepositoryHandle repositoryHandle = cached;
                            return repositoryHandle;
                        }
                        Closer.closeReference((RepositoryReference)RepositoryCache.this.repositoryCache.remove(gitDir));
                        removeCache = true;
                    }
                    CachingRepository inner = this.createRepository();
                    result = new RepositoryHandle((Repository)inner);
                    RepositoryCache.this.repositoryCache.put(gitDir, new RepositoryReference(result, (Repository)inner, RepositoryCache.this.queue));
                    return result;
                }
            }
            finally {
                IndexDiffCache indexCache;
                if (removeCache && (indexCache = IndexDiffCache.getInstance()) != null) {
                    indexCache.remove(gitDir);
                }
            }
        }

        /* synthetic */ Builder(Builder builder, Builder builder2) {
            this();
        }
    }

    private static class Closer
    extends Thread {
        private final ReferenceQueue<RepositoryHandle> queue;

        public Closer(ReferenceQueue<RepositoryHandle> queue) {
            this.queue = queue;
            this.setDaemon(true);
            this.setName("Git Repository Closer");
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Reference<RepositoryHandle> stale;
                    if (!((stale = this.queue.remove()) instanceof RepositoryReference)) {
                        continue;
                    }
                    Closer.closeReference((RepositoryReference)stale);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }

        public static void closeReference(RepositoryReference stale) {
            Repository repository = stale.getRepository();
            if (repository != null) {
                repository.close();
            }
            stale.clearRepository();
        }
    }

    private static class RepositoryReference
    extends WeakReference<RepositoryHandle> {
        private Repository inner;

        public RepositoryReference(RepositoryHandle handle, Repository delegate, ReferenceQueue<RepositoryHandle> queue) {
            super(handle, queue);
            this.inner = delegate;
        }

        public Repository getRepository() {
            return this.inner;
        }

        public void clearRepository() {
            this.inner = null;
        }
    }
}

