/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.safety;

import fr.kairos.common.graph.MyGraph;
import fr.kairos.common.graph.StronglyConnectedComponents;
import fr.kairos.timesquare.ccsl.graph.BuildCausalityGraph;
import fr.kairos.timesquare.ccsl.graph.BuildCounterGraph;
import fr.kairos.timesquare.ccsl.graph.BuildDelayedCausalityGraph;
import fr.kairos.timesquare.ccsl.graph.DigraphBuilder;
import fr.kairos.timesquare.ccsl.simple.ISpecificationBuilder;
import java.util.HashSet;
import java.util.Set;

public class AnalyzeSafety {
    private StronglyConnectedComponents scc;
    private MyGraph causalityGraph;
    private BuildCounterGraph bcog = new BuildCounterGraph();

    public AnalyzeSafety(ISpecificationBuilder specBuilder) {
        specBuilder.build(this.bcog);
        if (!this.hasCounters()) {
            return;
        }
        BuildCausalityGraph bcg = new BuildCausalityGraph(true);
        DigraphBuilder builder = bcg.getBuilder();
        specBuilder.build(bcg);
        BuildDelayedCausalityGraph bdcg = new BuildDelayedCausalityGraph(builder);
        specBuilder.build(bdcg);
        this.causalityGraph = new MyGraph(builder.getNodeNumber());
        builder.buildGraph(this.causalityGraph);
        this.scc = new StronglyConnectedComponents(this.causalityGraph);
    }

    public boolean checkSafety() {
        if (!this.hasCounters()) {
            return true;
        }
        for (DigraphBuilder.Arc edge : this.bcog.getBuilder().edges()) {
            if (this.scc.stronglyConnected(this.node(edge.tail()), this.node(edge.head()))) continue;
            return false;
        }
        return true;
    }

    public boolean hasCounters() {
        return this.bcog.getBuilder().getEdgeNumber() > 0;
    }

    public Set<String> findUnsafeCounters() {
        HashSet<String> unsafeCounters = new HashSet<String>();
        for (DigraphBuilder.Arc edge : this.bcog.getBuilder().edges()) {
            if (this.scc.stronglyConnected(this.node(edge.tail()), this.node(edge.head()))) continue;
            unsafeCounters.add(edge.toString());
        }
        return unsafeCounters;
    }

    private int node(String name) {
        return this.causalityGraph.nameToIndex(name);
    }
}

