/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.UnitOfWork;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.ui.internal.GitLabels;
import org.eclipse.egit.ui.internal.RepositoryStateCache;
import org.eclipse.jgit.lib.BranchTrackingStatus;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.util.StringUtils;

public class DecoratorRepositoryStateCache
extends RepositoryStateCache {
    public static final DecoratorRepositoryStateCache INSTANCE = new DecoratorRepositoryStateCache();
    private final Map<File, String> branchLabels = new ConcurrentHashMap<File, String>();
    private final Map<File, String> branchStateLabels = new ConcurrentHashMap<File, String>();
    private final Set<File> branchStatesToClear = ConcurrentHashMap.newKeySet();

    private DecoratorRepositoryStateCache() {
    }

    @Override
    public void initialize() {
    }

    @Override
    public void clear() {
        super.clear();
        this.branchLabels.clear();
        this.branchStateLabels.clear();
        this.branchStatesToClear.clear();
    }

    @Override
    public void clear(Repository repository) {
        super.clear(repository);
        File gitDir = repository.getDirectory();
        this.branchLabels.remove(gitDir);
        this.branchStateLabels.remove(gitDir);
        this.branchStatesToClear.remove(gitDir);
    }

    public void resetBranchState(Repository repository) {
        this.branchStatesToClear.add(repository.getDirectory());
    }

    public String getRepositoryNameAndState(Repository repository) {
        String repoName = RepositoryUtil.getInstance().getRepositoryName(repository);
        RepositoryState state = this.getRepositoryState(repository);
        if (state != RepositoryState.SAFE) {
            return String.valueOf(repoName) + '|' + state.getDescription();
        }
        return repoName;
    }

    public String getCurrentBranchLabel(Repository repository) {
        return this.branchLabels.computeIfAbsent(repository.getDirectory(), dir -> (String)UnitOfWork.get((Repository)repository, () -> {
            Ref head = this.getHeadRef(repository);
            if (head == null) {
                return CoreText.RepositoryUtil_noHead;
            }
            if (head.isSymbolic()) {
                String branchName = this.getFullBranchName(repository);
                return Repository.shortenRefName((String)branchName);
            }
            ObjectId objectId = head.getObjectId();
            if (objectId == null) {
                return CoreText.RepositoryUtil_noHead;
            }
            String ref = RepositoryUtil.getInstance().mapCommitToRef(repository, objectId.name(), false);
            if (ref != null) {
                return String.valueOf(Repository.shortenRefName((String)ref)) + ' ' + objectId.abbreviate(7).name();
            }
            return objectId.abbreviate(7).name();
        }));
    }

    public String getBranchStatus(Repository repository) {
        String label;
        File gitDir = repository.getDirectory();
        if (this.branchStatesToClear.remove(gitDir)) {
            this.branchStateLabels.remove(gitDir);
        }
        return StringUtils.isEmptyOrNull((String)(label = this.branchStateLabels.computeIfAbsent(gitDir, dir -> (String)UnitOfWork.get((Repository)repository, () -> {
            String branchName = this.getFullBranchName(repository);
            if (branchName == null) {
                return "";
            }
            BranchTrackingStatus status = null;
            try {
                status = BranchTrackingStatus.of((Repository)repository, (String)branchName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (status == null) {
                return "";
            }
            if (status.getAheadCount() == 0 && status.getBehindCount() == 0) {
                return "";
            }
            return GitLabels.formatBranchTrackingStatus(status);
        })))) ? null : label;
    }
}

