/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.iterator;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.evaluation.IterationManager;
import org.eclipse.ocl.pivot.ids.MapTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractIteration;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.MapValue;

public class MapRejectIteration
extends AbstractIteration {
    public static final @NonNull MapRejectIteration INSTANCE = new MapRejectIteration();

    @Override
    public @NonNull MapValue.Accumulator createAccumulatorValue(@NonNull Executor executor, @NonNull TypeId accumulatorTypeId, @NonNull TypeId bodyTypeId) {
        return MapRejectIteration.createMapAccumulatorValue((MapTypeId)accumulatorTypeId);
    }

    @Override
    protected @Nullable Object updateAccumulator(@NonNull IterationManager iterationManager) {
        Object bodyVal = iterationManager.evaluateBody();
        if (bodyVal == null) {
            throw new InvalidValueException(PivotMessages.UndefinedBody, "reject");
        }
        if (bodyVal == Boolean.FALSE) {
            Object key = iterationManager.get();
            MapValue mapValue = (MapValue)((IterationManager.IterationManagerExtension2)iterationManager).getSourceIterable();
            Object value = mapValue.at(key);
            MapValue.Accumulator accumulatorValue = (MapValue.Accumulator)iterationManager.getAccumulatorValue();
            assert (accumulatorValue != null);
            accumulatorValue.add(key, value);
        } else if (bodyVal != Boolean.TRUE) {
            throw new InvalidValueException(PivotMessages.NonBooleanBody, "reject");
        }
        return CARRY_ON;
    }
}

