/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.xref.internal.ui.providers;

import org.eclipse.contribution.xref.core.IXReferenceNode;
import org.eclipse.contribution.xref.internal.ui.providers.TreeObject;
import org.eclipse.contribution.xref.ui.IDeferredXReference;
import org.eclipse.contribution.xref.ui.XReferenceUIPlugin;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

public class XReferenceLabelProvider
extends LabelProvider {
    public ILabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new JavaElementLabelProvider(), XReferenceUIPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator());
    private boolean addedListener = false;
    private ListenerList fListeners;

    public void addListener(ILabelProviderListener listener) {
        super.addListener(listener);
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
        if (!this.addedListener) {
            this.addedListener = true;
            this.labelProvider.addListener(new ILabelProviderListener(){

                public void labelProviderChanged(LabelProviderChangedEvent event) {
                    XReferenceLabelProvider.this.fireLabelChanged();
                }
            });
        }
    }

    private void fireLabelChanged() {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ILabelProviderListener)listeners[i]).labelProviderChanged(event);
                ++i;
            }
        }
    }

    public String getText(Object obj) {
        String ret = obj.toString();
        Object data = ((TreeObject)obj).getData();
        if (data != null && !(data instanceof IDeferredXReference)) {
            ret = this.labelProvider.getText(data);
        }
        return ret;
    }

    public Image getImage(Object obj) {
        Object data = ((TreeObject)obj).getData();
        if (data != null) {
            if (data instanceof IDeferredXReference) {
                return XReferenceUIPlugin.getDefault().getEvaluateImage();
            }
            if (data instanceof IXReferenceNode) {
                return this.labelProvider.getImage((Object)((IXReferenceNode)data).getJavaElement());
            }
            return this.labelProvider.getImage(data);
        }
        return XReferenceUIPlugin.getDefault().getXReferenceImage();
    }

    public void dispose() {
        this.fListeners = null;
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
            this.labelProvider = null;
        }
    }
}

