/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2m.internal.qvt.oml.runtime.QvtRuntimePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectDependencyTracker {
    public static final String POINT = "org.eclipse.m2m.qvt.oml.runtime.qvtProjectDependencyTracker";
    private static Collection<ProjectDependencyTracker> trackers = null;

    private static Collection<ProjectDependencyTracker> getTrackers() {
        if (trackers == null) {
            IConfigurationElement[] providers = Platform.getExtensionRegistry().getConfigurationElementsFor(POINT);
            trackers = new ArrayList<ProjectDependencyTracker>(providers.length);
            IConfigurationElement[] iConfigurationElementArray = providers;
            int n = providers.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement provider = iConfigurationElementArray[n2];
                try {
                    Object extension = provider.createExecutableExtension("class");
                    if (extension instanceof ProjectDependencyTracker) {
                        trackers.add((ProjectDependencyTracker)extension);
                    }
                }
                catch (CoreException e) {
                    QvtRuntimePlugin.log(e.getStatus());
                }
                ++n2;
            }
        }
        return trackers;
    }

    public static Set<IProject> getAllReferencedProjects(IProject project, boolean recursive) {
        IConfigurationElement[] providers = Platform.getExtensionRegistry().getConfigurationElementsFor(POINT);
        HashSet<IProject> referencedProjects = new HashSet<IProject>(providers.length);
        for (ProjectDependencyTracker tracker : ProjectDependencyTracker.getTrackers()) {
            referencedProjects.addAll(tracker.getReferencedProjects(project, recursive));
        }
        return referencedProjects;
    }

    public abstract Set<IProject> getReferencedProjects(IProject var1, boolean var2);
}

