/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ui.quickfix;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.env.impl.FileBasedAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.io.IOResources;
import org.eclipse.emf.ecoretools.ale.ide.project.AleProjectPreferences;
import org.eclipse.emf.ecoretools.ale.ide.project.IAleProject;
import org.eclipse.emf.ecoretools.ale.xtext.ui.internal.XtextActivator;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.service.prefs.BackingStoreException;

public class AleQuickfixProvider
extends DefaultQuickfixProvider {
    public static final String CORE_PLUGIN_ID = "org.eclipse.emf.ecoretools.ale.core";

    @Fix(value="org.eclipse.emf.ecoretools.ale.xtext.SourceFileNotInEnvironmentMarker")
    public void capitalize(Issue issue, IssueResolutionAcceptor acceptor) {
        IModification _function = context -> {
            IXtextDocument xtextDocument = context.getXtextDocument();
            Optional aleFile = IOResources.toIFile((URI)xtextDocument.getResourceURI());
            boolean _isPresent = aleFile.isPresent();
            if (_isPresent) {
                IAleProject project = IAleProject.from((IProject)((IFile)aleFile.get()).getProject());
                IAleEnvironment env = project.getEnvironment();
                LinkedHashSet aleSourceFilesPath = env.getBehaviorsSources();
                URI aleFileURI = URI.createPlatformResourceURI((String)((IFile)aleFile.get()).getFullPath().toString(), (boolean)true);
                String _string = aleFileURI.toString();
                aleSourceFilesPath.add(_string);
                boolean _isConfiguredFromPreferences = project.isConfiguredFromPreferences();
                if (_isConfiguredFromPreferences) {
                    IProject _project = ((IFile)aleFile.get()).getProject();
                    ProjectScope projectContext = new ProjectScope(_project);
                    IEclipsePreferences preferences = projectContext.getNode(CORE_PLUGIN_ID);
                    Functions.Function1 _function_1 = it -> it.trim();
                    Functions.Function1 _function_2 = it -> {
                        boolean _isEmpty = it.isEmpty();
                        return !_isEmpty;
                    };
                    String commaSeparatedPaths = IterableExtensions.join((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)aleSourceFilesPath, (Functions.Function1)_function_1), (Functions.Function1)_function_2), (CharSequence)",");
                    try {
                        preferences.put(AleProjectPreferences.ALE_SOURCE_FILES.property(), commaSeparatedPaths);
                        preferences.flush();
                    }
                    catch (Throwable _t) {
                        if (_t instanceof IllegalStateException || _t instanceof BackingStoreException) {
                            Exception unlikelyToHappen = (Exception)_t;
                            XtextActivator.getInstance().getLog().error("An unexpected error occurred while saving preferences", (Throwable)unlikelyToHappen);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                } else {
                    Optional dsl = project.findDslFile();
                    boolean _isPresent_1 = dsl.isPresent();
                    if (_isPresent_1) {
                        FileBasedAleEnvironment dslEnv = IAleEnvironment.fromFile((IFile)((IFile)dsl.get()));
                        IAleEnvironment newEnv = IAleEnvironment.fromPaths((Collection)env.getMetamodelsSources(), (Collection)aleSourceFilesPath);
                        dslEnv.save(newEnv);
                    }
                }
            }
        };
        acceptor.accept(issue, "Add file to ALE environment", "Adds the file to the project's ALE environment (either in the configured .dsl file\nor in project`s preferences)", "upcase.png", _function);
    }
}

