/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.parser.xtext;

import com.google.common.collect.Lists;
import fr.inria.aoste.timesquare.utils.umlhelpers.UmlHelpers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.impl.AbstractResourceDescription;

public class EventResourceDescription
extends AbstractResourceDescription {
    private Resource resource;
    private String prefix = null;
    private URI uri;
    private IQualifiedNameConverter qualifiedNameConverter;
    private List<IEObjectDescription> result = null;
    public static final boolean addAliasPrefix = false;
    public static final String QUALIFIED_NAME_ATTRIBUTE = "qualifiedName";
    public static final String SIMPLE_NAME_ATTRIBUTE = "name";

    public EventResourceDescription(Resource resource, String pref, IQualifiedNameConverter qualifiedNameConverter) {
        this.resource = resource;
        this.uri = super.getNormalizedURI(resource);
        this.prefix = pref;
        this.qualifiedNameConverter = qualifiedNameConverter;
    }

    public String getPrefix() {
        return this.prefix;
    }

    protected List<IEObjectDescription> computeExportedObjects() {
        if (this.result != null) {
            return this.result;
        }
        TreeIterator contents = this.resource.getAllContents();
        this.result = Lists.newArrayList();
        String _prefix = "";
        UmlHelpers umlHelper = new UmlHelpers();
        while (contents.hasNext()) {
            Object objectName;
            EObject eObject = (EObject)contents.next();
            EObjectDescription desc = null;
            if (eObject == null) continue;
            EClass ec = eObject.eClass();
            EStructuralFeature esf = ec.getEStructuralFeature(QUALIFIED_NAME_ATTRIBUTE);
            if (esf == null || !esf.isDerived()) {
                esf = ec.getEStructuralFeature(SIMPLE_NAME_ATTRIBUTE);
            }
            Object object = objectName = esf != null ? eObject.eGet(esf) : String.valueOf(ec.getName()) + "_instanceWithNoName";
            if (objectName != null && objectName instanceof String) {
                String objectKey = String.valueOf(_prefix) + objectName.toString();
                QualifiedName qualifiedName = this.qualifiedNameConverter.toQualifiedName(objectKey);
                desc = new EObjectDescription(qualifiedName, eObject, null);
                if (desc != null) {
                    this.result.add((IEObjectDescription)desc);
                }
            } else {
                objectName = "";
            }
            ArrayList<EObject> objectMethods = new ArrayList<EObject>();
            ArrayList<String> objectMethodNames = new ArrayList<String>();
            for (EObject eo : eObject.eClass().eContents()) {
                if (!(eo instanceof EOperation)) continue;
                objectMethods.add(eo);
                objectMethodNames.add(String.valueOf(((EOperation)eo).getName()) + "()");
            }
            int i = 0;
            while (i < objectMethodNames.size()) {
                String methodName = (String)objectMethodNames.get(i);
                String methodKey = String.valueOf(_prefix) + objectName.toString() + "::" + methodName;
                QualifiedName qualifiedName = this.qualifiedNameConverter.toQualifiedName(methodKey);
                desc = new EObjectDescription(qualifiedName, (EObject)objectMethods.get(i), null);
                if (desc != null) {
                    this.result.add((IEObjectDescription)desc);
                }
                ++i;
            }
            ArrayList additionnalPropName = umlHelper.getPropertyNameToDisplayInXtext(eObject);
            ArrayList additionnalProp = umlHelper.getPropertyToDisplayInXtext(eObject);
            int i2 = 0;
            while (i2 < additionnalPropName.size()) {
                String propertyName = (String)additionnalPropName.get(i2);
                String propertyKey = String.valueOf(_prefix) + objectName.toString() + "::" + propertyName;
                QualifiedName qualifiedName = this.qualifiedNameConverter.toQualifiedName(propertyKey);
                desc = new EObjectDescription(qualifiedName, (EObject)additionnalProp.get(i2), null);
                if (desc != null) {
                    this.result.add((IEObjectDescription)desc);
                }
                ++i2;
            }
        }
        return this.result;
    }

    public Iterable<QualifiedName> getImportedNames() {
        return Collections.emptyList();
    }

    public Iterable<IReferenceDescription> getReferenceDescriptions() {
        return Collections.emptyList();
    }

    public URI getURI() {
        return this.uri;
    }
}

