/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.draw;

import fr.inria.aoste.timesquare.utils.pluginhelpers.PluginHelpers;
import fr.inria.aoste.timesquare.vcd.IVcd;
import fr.inria.aoste.timesquare.vcd.IVcdDiagram;
import fr.inria.aoste.timesquare.vcd.ListConnections;
import fr.inria.aoste.timesquare.vcd.draw.print.FigurePrinter;
import fr.inria.aoste.timesquare.vcd.draw.print.VCDDiagramPrint;
import fr.inria.aoste.timesquare.vcd.listener.MouseClickListener;
import fr.inria.aoste.timesquare.vcd.listener.MouseDraggedListener;
import fr.inria.aoste.timesquare.vcd.listener.MouseMoveListenerVCD;
import fr.inria.aoste.timesquare.vcd.listener.MouseTactileDraggedListener;
import fr.inria.aoste.timesquare.vcd.listener.VcdKeyListener;
import fr.inria.aoste.timesquare.vcd.listener.WheelListener;
import fr.inria.aoste.timesquare.vcd.model.VCDDefinitions;
import fr.inria.aoste.timesquare.vcd.model.visitor.TraceCollector;
import fr.inria.aoste.timesquare.vcd.preferences.VcdColorPreferences;
import fr.inria.aoste.timesquare.vcd.view.VcdFactory;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.ScrollPaneSolver;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;

public final class FigureCanvasBase {
    private IVcd _vcdMultiPageEditor = null;
    private FigureCanvas _clockCanvas = null;
    private FigureCanvas _names = null;
    private FigureCanvas _scale = null;
    private FigureCanvas _picture = null;
    private ToolBar _toolbar = null;
    private Composite _compositeParent = null;
    private ImageFigure _progressRatePicture = null;
    private VcdColorPreferences _mca;
    private MouseMoveListener _mouseMoveListener;
    private KeyListener _keyListener;
    private MouseListener _mouseListener;
    private MouseDraggedListener _mouseDraggedListenerName;
    private WheelListener _wheelListener;
    private MouseTactileDraggedListener _MouseTactileDraggedListener;

    public FigureCanvasBase(IVcd me, VcdColorPreferences mca) {
        this._vcdMultiPageEditor = me;
        this._mca = mca;
    }

    public void makeVcd(Composite p, boolean simulation) {
        if (p == null) {
            return;
        }
        if (p.isDisposed()) {
            return;
        }
        this.init(p, simulation);
        this.positionpicture();
        this.positionscale();
        this.positioncanvas();
        this.positionnames();
        this.positiontoolbar();
    }

    private void init(Composite p, boolean simulation) {
        this._compositeParent = new Composite(p, 772);
        this._clockCanvas = new FigureCanvas(this._compositeParent, 0);
        this._names = new FigureCanvas(this._compositeParent, 0);
        this._scale = new FigureCanvas(this._compositeParent, 0);
        this._picture = new FigureCanvas(this._compositeParent, 0);
        this._toolbar = new ToolBar(this._compositeParent, 0);
        this._compositeParent.setLayoutData((Object)new GridData(4, 4, true, true));
        this._compositeParent.setBackground(this._mca.colorMenuBackground());
        this._compositeParent.setLayout((Layout)new FormLayout());
        this._progressRatePicture = new ImageFigure(PluginHelpers.getImage((String)"fr.inria.aoste.timesquare.vcd", (String)"icons/sampleInira.gif"));
        this._vcdMultiPageEditor.getVcdFactory().getPicture().add((IFigure)this._progressRatePicture);
        this._progressRatePicture.setVisible(simulation);
    }

    private void positionpicture() {
        FormData pictureData = new FormData();
        pictureData.left = new FormAttachment(0, 0);
        pictureData.top = new FormAttachment(0, 0);
        pictureData.height = 50;
        pictureData.width = this._mca.getWidthName();
        this._picture.setLayoutData((Object)pictureData);
        this._picture.setBackground(this._mca.colorBlack());
        this._picture.setScrollBarVisibility(FigureCanvas.NEVER);
        this._picture.setContents((IFigure)this._vcdMultiPageEditor.getVcdFactory().getPicture());
    }

    private void positionscale() {
        FormData scaleData = new FormData();
        scaleData.left = new FormAttachment((Control)this._picture);
        scaleData.right = new FormAttachment(100, 0);
        scaleData.top = new FormAttachment(0, 0);
        scaleData.height = 50;
        this._scale.setLayoutData((Object)scaleData);
        this._scale.setBackground(this._mca.colorBlack());
        this._scale.setScrollBarVisibility(FigureCanvas.NEVER);
        this._scale.setContents((IFigure)this._vcdMultiPageEditor.getVcdFactory().getScalePanel());
        this._vcdMultiPageEditor.getVcdFactory().getScalePanel().setSize(-1, 35);
        this._scale.setSize(-1, 50);
    }

    private void positioncanvas() {
        FormData canvasData = new FormData();
        canvasData.left = new FormAttachment((Control)this._names);
        canvasData.right = new FormAttachment(100, 0);
        canvasData.bottom = new FormAttachment((Control)this._toolbar);
        canvasData.top = new FormAttachment((Control)this._picture);
        this._clockCanvas.setBackground(this._mca.colorBlack());
        this._clockCanvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this._clockCanvas.setLayoutData((Object)canvasData);
        this._clockCanvas.setContents((IFigure)this._vcdMultiPageEditor.getVcdFactory().getBackPanel());
    }

    private void positionnames() {
        FormData namesData = new FormData();
        namesData.left = new FormAttachment(0, 0);
        namesData.bottom = new FormAttachment((Control)this._toolbar);
        namesData.top = new FormAttachment((Control)this._picture);
        namesData.width = this._mca.getWidthName();
        this._names.setBackground(this._mca.colorBlack());
        this._names.setLayoutData((Object)namesData);
        this._names.setContents((IFigure)this._vcdMultiPageEditor.getVcdFactory().getNames());
        this._names.setScrollBarVisibility(FigureCanvas.NEVER);
    }

    private void positiontoolbar() {
        FormData toolbarData = new FormData();
        toolbarData.left = new FormAttachment(0, 0);
        toolbarData.right = new FormAttachment(100, 0);
        toolbarData.bottom = new FormAttachment(100, 0);
        toolbarData.height = 25;
        this._toolbar.setLayoutData((Object)toolbarData);
    }

    public void layoutall() {
        this._clockCanvas.layout();
        this._names.layout();
        this._scale.layout();
        this._picture.layout();
        this._toolbar.layout();
        this._compositeParent.layout();
    }

    public FigureCanvas getClockCanvas() {
        return this._clockCanvas;
    }

    public FigureCanvas getNames() {
        return this._names;
    }

    public FigureCanvas getScaleCanvas() {
        return this._scale;
    }

    public FigureCanvas getPicture() {
        return this._picture;
    }

    public ToolBar getToolbar() {
        return this._toolbar;
    }

    public Composite getComposite() {
        return this._compositeParent;
    }

    public void setSimulationProgress(int etape) {
        if (this._progressRatePicture == null) {
            return;
        }
        String s = "fr.inria.aoste.timesquare.vcd";
        switch (etape) {
            case 0: {
                this._progressRatePicture.setImage(PluginHelpers.getImage((String)s, (String)"icons/simulation.png"));
                break;
            }
            case 1: {
                this._progressRatePicture.setImage(PluginHelpers.getImage((String)s, (String)"icons/simulation2.png"));
                break;
            }
            case 2: {
                this._progressRatePicture.setImage(PluginHelpers.getImage((String)s, (String)"icons/simulation3.png"));
                break;
            }
            case 3: {
                this._progressRatePicture.setImage(PluginHelpers.getImage((String)s, (String)"icons/simulation4.png"));
                break;
            }
            case 4: {
                this._progressRatePicture.setImage(PluginHelpers.getImage((String)s, (String)"icons/simulation5.png"));
                break;
            }
            case 5: {
                this._progressRatePicture.setImage(PluginHelpers.getImage((String)s, (String)"icons/simulation6.png"));
                break;
            }
            case 6: {
                this._progressRatePicture.setImage(PluginHelpers.getImage((String)s, (String)"icons/simulation7.png"));
            }
        }
    }

    public void scrollUpdate() {
        ScrollBar sbrscr = this.getClockCanvas().getHorizontalBar();
        ScrollBar sbrdst = this.getComposite().getHorizontalBar();
        sbrdst.setIncrement(sbrscr.getIncrement());
        sbrdst.setMaximum(sbrscr.getMaximum());
        sbrdst.setMinimum(sbrscr.getMinimum());
        sbrdst.setSelection(sbrscr.getSelection());
        sbrdst.setPageIncrement(sbrscr.getPageIncrement());
        sbrdst.setThumb(sbrscr.getThumb());
        sbrscr = this.getClockCanvas().getVerticalBar();
        sbrdst = this.getComposite().getVerticalBar();
        sbrdst.setIncrement(sbrscr.getIncrement());
        sbrdst.setMaximum(sbrscr.getMaximum());
        sbrdst.setMinimum(sbrscr.getMinimum());
        sbrdst.setSelection(sbrscr.getSelection());
        sbrdst.setPageIncrement(sbrscr.getPageIncrement());
        sbrdst.setThumb(sbrscr.getThumb());
        FigureCanvas fc = this.getClockCanvas();
        ScrollPaneSolver.Result result = ScrollPaneSolver.solve((Rectangle)new Rectangle(fc.getBounds()).setLocation(0, 0), (Viewport)fc.getViewport(), (int)FigureCanvas.AUTOMATIC, (int)FigureCanvas.AUTOMATIC, (int)0, (int)0);
        if (this.getComposite().getHorizontalBar().getVisible() != result.showH) {
            this.getComposite().getHorizontalBar().setVisible(result.showH);
        }
        if (this.getComposite().getVerticalBar().getVisible() != result.showV) {
            this.getComposite().getVerticalBar().setVisible(result.showV);
        }
    }

    public void scroll2End() {
        ScrollBar scbCC = this.getClockCanvas().getHorizontalBar();
        ScrollBar scbSC = this.getScaleCanvas().getHorizontalBar();
        scbCC.setSelection(scbCC.getMaximum());
        scbSC.setSelection(scbSC.getMaximum());
        this._clockCanvas.scrollToX(scbCC.getMaximum());
        this._scale.scrollToX(scbSC.getMaximum());
    }

    public int update2(int n1, int n2, boolean b) {
        if (this._vcdMultiPageEditor == null) {
            return 0;
        }
        if (this._vcdMultiPageEditor.getCanvas() == null) {
            return 0;
        }
        if (this._vcdMultiPageEditor.getCanvas().isDisposed()) {
            return 0;
        }
        this.scrollUpdate();
        this.scroll2End();
        this._vcdMultiPageEditor.getVcdModel().visit(this._vcdMultiPageEditor.getTraceCollector(), n1, n2, b);
        this._clockCanvas.setContents((IFigure)this._vcdMultiPageEditor.getVcdFactory().getBackPanel());
        this.getScaleCanvas().layout();
        this._vcdMultiPageEditor.getCanvas().layout();
        return 0;
    }

    public int printer(String name) {
        PrintDialog printDialog = new PrintDialog(new Shell(), 0);
        printDialog.setText("Print " + name);
        PrinterData printerData = printDialog.open();
        if (printerData != null) {
            Printer printer = new Printer(printerData);
            VcdColorPreferences mca = VcdColorPreferences.createColor();
            mca.setMode(false);
            VcdFactory vcdFactory = new VcdFactory(mca);
            VCDDefinitions vcdDefinitions = this._vcdMultiPageEditor.getVcdModel().cloneWithNewFactory(vcdFactory);
            TraceCollector traceCollector = new TraceCollector(this._vcdMultiPageEditor.getTraceCollector().getSelectedClocks(), vcdFactory, true);
            vcdDefinitions.visit(traceCollector);
            VCDDiagramPrint vcdDiagramPrint = new VCDDiagramPrint(vcdDefinitions, mca, vcdFactory);
            vcdDiagramPrint.setTraceCollector(traceCollector);
            FigureCanvasBase figureCanvasBase = vcdDiagramPrint.getFcb();
            figureCanvasBase.makeVcd(new Composite((Composite)new Shell(), 16777303), false);
            figureCanvasBase.getNames().setContents((IFigure)vcdFactory.getNames());
            figureCanvasBase.getClockCanvas().setContents((IFigure)vcdFactory.getBackPanel());
            figureCanvasBase.getNames().getParent().layout();
            figureCanvasBase.getClockCanvas().getContents().validate();
            figureCanvasBase.getNames().getContents().validate();
            figureCanvasBase.getClockCanvas().getParent().layout();
            figureCanvasBase.scrollUpdate();
            FigurePrinter figurePrinter = new FigurePrinter(printer);
            figurePrinter.setFigureCanvasBase(figureCanvasBase);
            figurePrinter.run(name);
            vcdDiagramPrint.clear();
            traceCollector.clear();
            figurePrinter.clear();
        }
        return 0;
    }

    public int createListener(ListConnections list, IVcdDiagram vdt) {
        this._mouseMoveListener = new MouseMoveListenerVCD(vdt);
        this.getClockCanvas().addMouseMoveListener(this._mouseMoveListener);
        this._mouseListener = new MouseClickListener(list, vdt);
        this.getClockCanvas().addMouseListener(this._mouseListener);
        this._mouseDraggedListenerName = new MouseDraggedListener(list, vdt);
        this.getNames().addMouseListener((MouseListener)this._mouseDraggedListenerName);
        this.getNames().addMouseMoveListener((MouseMoveListener)this._mouseDraggedListenerName);
        this._MouseTactileDraggedListener = new MouseTactileDraggedListener(vdt);
        this.getClockCanvas().addMouseListener((MouseListener)this._MouseTactileDraggedListener);
        this.getClockCanvas().addMouseMoveListener((MouseMoveListener)this._MouseTactileDraggedListener);
        this._wheelListener = new WheelListener(vdt);
        this.getClockCanvas().addMouseWheelListener((MouseWheelListener)this._wheelListener);
        this._keyListener = new VcdKeyListener(vdt);
        this.getClockCanvas().addKeyListener(this._keyListener);
        this.addScrollListener();
        return 0;
    }

    public int dispose() {
        Control c;
        int n;
        int n2;
        Control[] controlArray;
        if (!this._clockCanvas.isDisposed()) {
            controlArray = this._clockCanvas.getChildren();
            n2 = controlArray.length;
            n = 0;
            while (n < n2) {
                c = controlArray[n];
                c.dispose();
                ++n;
            }
            if (this._mouseMoveListener != null) {
                this._clockCanvas.removeMouseMoveListener(this._mouseMoveListener);
            }
            if (this._keyListener != null) {
                this._clockCanvas.removeKeyListener(this._keyListener);
            }
            if (this._mouseListener != null) {
                this._clockCanvas.removeMouseListener(this._mouseListener);
            }
            if (this._wheelListener != null) {
                this._clockCanvas.removeMouseWheelListener((MouseWheelListener)this._wheelListener);
            }
            if (this._MouseTactileDraggedListener != null) {
                this._clockCanvas.removeMouseListener((MouseListener)this._MouseTactileDraggedListener);
                this._clockCanvas.removeMouseMoveListener((MouseMoveListener)this._MouseTactileDraggedListener);
            }
            this._clockCanvas.dispose();
        }
        if (!this._names.isDisposed()) {
            controlArray = this._names.getChildren();
            n2 = controlArray.length;
            n = 0;
            while (n < n2) {
                c = controlArray[n];
                c.dispose();
                ++n;
            }
            if (this._mouseDraggedListenerName != null) {
                this._names.removeMouseListener((MouseListener)this._mouseDraggedListenerName);
                this._names.removeMouseMoveListener((MouseMoveListener)this._mouseDraggedListenerName);
            }
            this._names.dispose();
        }
        if (!this._scale.isDisposed()) {
            controlArray = this._scale.getChildren();
            n2 = controlArray.length;
            n = 0;
            while (n < n2) {
                c = controlArray[n];
                c.dispose();
                ++n;
            }
        }
        if (!this._picture.isDisposed()) {
            controlArray = this._picture.getChildren();
            n2 = controlArray.length;
            n = 0;
            while (n < n2) {
                c = controlArray[n];
                c.dispose();
                ++n;
            }
        }
        if (!this._toolbar.isDisposed()) {
            controlArray = this._toolbar.getChildren();
            n2 = controlArray.length;
            n = 0;
            while (n < n2) {
                c = controlArray[n];
                c.dispose();
                ++n;
            }
        }
        this._scale.dispose();
        this._picture.dispose();
        this._toolbar.dispose();
        this._compositeParent.dispose();
        this._mca = null;
        this._vcdMultiPageEditor = null;
        return 0;
    }

    public VcdColorPreferences getMca() {
        return this._mca;
    }

    public int addScrollListener() {
        this.getClockCanvas().getVerticalBar().addSelectionListener((SelectionListener)new CanvasVerticalBarListener());
        this.getNames().getVerticalBar().addSelectionListener((SelectionListener)new NamesVerticalBarListener());
        this.getComposite().getVerticalBar().addSelectionListener((SelectionListener)new CompositesVerticalBarListener());
        this.getComposite().addListener(11, (Listener)new ResizeListener());
        this.getClockCanvas().addListener(11, (Listener)new ResizeListener());
        this.getScaleCanvas().addListener(11, (Listener)new ResizeListener());
        this.getComposite().getHorizontalBar().addSelectionListener((SelectionListener)new CompositeHorizontalBarListener());
        return 0;
    }

    private final class CanvasVerticalBarListener
    implements SelectionListener {
        private CanvasVerticalBarListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            if (FigureCanvasBase.this._vcdMultiPageEditor.isCtrlKey()) {
                int y = FigureCanvasBase.this.getNames().getVerticalBar().getSelection();
                FigureCanvasBase.this.getClockCanvas().scrollToY(y);
                return;
            }
            int y = FigureCanvasBase.this.getClockCanvas().getVerticalBar().getSelection();
            FigureCanvasBase.this.getNames().scrollToY(y);
        }
    }

    private final class CompositeHorizontalBarListener
    implements SelectionListener {
        private CompositeHorizontalBarListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            int x = FigureCanvasBase.this.getComposite().getHorizontalBar().getSelection();
            FigureCanvasBase.this.getClockCanvas().scrollToX(x);
            FigureCanvasBase.this.getScaleCanvas().scrollToX(x);
            FigureCanvasBase.this.scrollUpdate();
        }
    }

    private final class CompositesVerticalBarListener
    implements SelectionListener {
        private CompositesVerticalBarListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            if (FigureCanvasBase.this._vcdMultiPageEditor.isCtrlKey()) {
                int y;
                if ((FigureCanvas)e.getSource() == FigureCanvasBase.this._clockCanvas) {
                    y = FigureCanvasBase.this._names.getVerticalBar().getSelection();
                    FigureCanvasBase.this.getClockCanvas().scrollToY(y);
                    FigureCanvasBase.this.getComposite().getVerticalBar().setSelection(y);
                }
                if ((FigureCanvas)e.getSource() == FigureCanvasBase.this._names) {
                    y = FigureCanvasBase.this._clockCanvas.getVerticalBar().getSelection();
                    FigureCanvasBase.this.getNames().scrollToY(y);
                    FigureCanvasBase.this.getComposite().getVerticalBar().setSelection(y);
                }
                return;
            }
            int y = FigureCanvasBase.this.getComposite().getVerticalBar().getSelection();
            FigureCanvasBase.this.getClockCanvas().scrollToY(y);
            FigureCanvasBase.this.getNames().scrollToY(y);
            FigureCanvasBase.this.scrollUpdate();
        }
    }

    private final class NamesVerticalBarListener
    implements SelectionListener {
        private NamesVerticalBarListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            int y = FigureCanvasBase.this.getNames().getVerticalBar().getSelection();
            FigureCanvasBase.this.getClockCanvas().scrollToY(y);
        }
    }

    public final class ResizeListener
    implements Listener {
        public void handleEvent(Event event) {
            FigureCanvasBase.this.scrollUpdate();
        }
    }
}

