/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.preferences;

import fr.inria.aoste.timesquare.vcd.VcdActivator;
import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;

public final class ColorSelection {
    private ArrayList<ColorData> _arrayColor = new ArrayList();
    private String _colorName;
    private IPreferenceStore _store = null;

    public ColorSelection(String colorName) {
        this._colorName = colorName;
        String top = "";
        if (colorName != null && colorName.length() != 0) {
            top = String.valueOf(colorName) + ".";
        }
        if (VcdActivator.getDefault() != null) {
            this._store = VcdActivator.getDefault().getPreferenceStore();
        }
        this._arrayColor.add(0, new ColorData(String.valueOf(top) + "background", "Background", 0, 0, 0));
        this._arrayColor.add(1, new ColorData(String.valueOf(top) + "text", "Text", 255, 255, 255));
        this._arrayColor.add(2, new ColorData(String.valueOf(top) + "clock", "Clocks", 0, 255, 0));
        this._arrayColor.add(3, new ColorData(String.valueOf(top) + "highImpedence", "High Impedance", 255, 212, 0));
        this._arrayColor.add(4, new ColorData(String.valueOf(top) + "Timer", "Timer", 0, 255, 0));
        this._arrayColor.add(5, new ColorData(String.valueOf(top) + "TimerLabel", "Timer Label", 0, 127, 255));
        this._arrayColor.add(6, new ColorData(String.valueOf(top) + "timerZ", "Timer Inactif", 255, 100, 0));
        this._arrayColor.add(7, new ColorData(String.valueOf(top) + "ghost", "Ghosts", 0, 127, 0));
        this._arrayColor.add(8, new ColorData(String.valueOf(top) + "time", "Time Scale", 255, 0, 0));
        this._arrayColor.add(9, new ColorData(String.valueOf(top) + "whiteArrow", "Precedence", 255, 255, 255));
        this._arrayColor.add(10, new ColorData(String.valueOf(top) + "coincidence", "Coincidence", 255, 0, 0));
        this._arrayColor.add(11, new ColorData(String.valueOf(top) + "weaklyPrecedenceCoincidence", "Weakly Coincidence", 255, 220, 220));
        this._arrayColor.add(12, new ColorData(String.valueOf(top) + "tickMarker", "TickMarker", 255, 255, 0));
    }

    public String getColorName() {
        return this._colorName;
    }

    public void init() {
        if (this._store != null) {
            for (ColorData cd : this._arrayColor) {
                this._store.setDefault(cd.name, cd.getValue());
            }
            this._store.setDefault("namesize", 150);
        }
    }

    public void defaultColor() {
        if (this._store != null) {
            for (ColorData cd : this._arrayColor) {
                this._store.setDefault(cd.name, cd.getValue());
            }
        }
    }

    public int getWidthName() {
        if (this._store == null) {
            return 120;
        }
        return this._store.getInt("namesize");
    }

    protected Color convertColor(int n) {
        if (n >= this._arrayColor.size()) {
            return new Color(null, 0, 0, 0);
        }
        return this._arrayColor.get(n).getColor();
    }

    protected ArrayList<ColorData> getArrayColor() {
        return this._arrayColor;
    }

    public class ColorData {
        String name;
        String title;
        int r;
        int g;
        int b;

        public ColorData(String name, String title, int r, int g, int b) {
            this.name = name;
            this.title = title;
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public Color getColor() {
            if (ColorSelection.this._store != null) {
                return new Color(null, PreferenceConverter.getColor((IPreferenceStore)ColorSelection.this._store, (String)this.name));
            }
            return new Color(null, this.r, this.g, this.b);
        }

        String getValue() {
            return String.valueOf(this.r) + "," + this.g + "," + this.b;
        }
    }
}

