/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.simple;

import fr.kairos.timesquare.ccsl.IDefinition;
import fr.kairos.timesquare.ccsl.IRelation;
import fr.kairos.timesquare.ccsl.ISpecification;
import fr.kairos.timesquare.ccsl.simple.Definition;
import fr.kairos.timesquare.ccsl.simple.Relation;
import fr.kairos.timesquare.ccsl.simple.Specification;
import java.util.HashMap;
import java.util.Map;

public class CopyWithReplace
implements ISpecification {
    private Specification result;
    private Map<String, String> replaceClocks = new HashMap<String, String>();

    public CopyWithReplace(String newName) {
        this(newName, new HashMap<String, String>());
    }

    public CopyWithReplace(String newName, Map<String, String> map) {
        this.result = new Specification(newName);
        this.replaceClocks = map;
    }

    public CopyWithReplace replace(String oldName, String newName) {
        this.replaceClocks.put(oldName, newName);
        return this;
    }

    public String replace(String name) {
        if (this.replaceClocks.containsKey(name)) {
            return this.replaceClocks.get(name);
        }
        return name;
    }

    public String[] replace(String[] clocks) {
        String[] res = new String[clocks.length];
        int i = 0;
        while (i < clocks.length) {
            res[i] = this.replace(clocks[i]);
            ++i;
        }
        return res;
    }

    @Override
    public void addClock(String name) {
        this.result.addClock(this.replace(name));
    }

    public Specification getResult() {
        return this.result;
    }

    @Override
    public void add(IDefinition def) {
        Definition res = new Definition(def.getDefinedClock(), def.getConstraintName(), this.replace(def.getRefClocks()));
        res.copyParamFrom(def);
        this.result.add(res);
    }

    @Override
    public void add(IRelation rel) {
        Relation res = new Relation(rel.getConstraintName(), this.replace(rel.getLeft()), this.replace(rel.getRight()));
        res.copyParamFrom(rel);
        this.result.add(res);
    }

    @Override
    public boolean isConstraintSupported(String name) {
        return true;
    }
}

