/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.moccml.testscenariolang.xtext;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class CodeExecutionJdtClassLoader
extends URLClassLoader {
    static IWorkspace workspace = ResourcesPlugin.getWorkspace();
    static IWorkspaceRoot root = workspace.getRoot();
    private HashMap<String, Integer> visitedProjects = new HashMap();

    public CodeExecutionJdtClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    private void updateSearchPaths() {
        IProject[] projects;
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                try {
                    boolean isJavaProject = false;
                    IProjectDescription descr = project.getDescription();
                    String[] stringArray = descr.getNatureIds();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String nature = stringArray[n4];
                        if (nature.equals("org.eclipse.jdt.core.javanature")) {
                            isJavaProject = true;
                            break;
                        }
                        ++n4;
                    }
                    if (isJavaProject) {
                        IJavaProject javaProject = JavaCore.create((IProject)project);
                        int hash = javaProject.hashCode();
                        Integer oldHash = this.visitedProjects.get(project.getName());
                        if (oldHash == null || oldHash != hash) {
                            URL[] uRLArray = this.getProjectClassPathURLs(javaProject);
                            int n5 = uRLArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                URL url = uRLArray[n6];
                                this.addURL(url);
                                ++n6;
                            }
                            this.visitedProjects.put(project.getName(), hash);
                        }
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    private URL[] getProjectClassPathURLs(IJavaProject project) {
        HashSet<URL> pathElements = new HashSet<URL>();
        try {
            IClasspathEntry[] paths = project.getResolvedClasspath(true);
            HashSet<IPath> outputPaths = new HashSet<IPath>();
            if (paths != null) {
                int i = 0;
                while (i < paths.length) {
                    IPath output;
                    IClasspathEntry iClasspathEntry = paths[i];
                    if (iClasspathEntry.getEntryKind() == 1) {
                        URL url = CodeExecutionJdtClassLoader.getRawLocationURL(iClasspathEntry.getPath());
                        pathElements.add(url);
                    } else if (iClasspathEntry.getEntryKind() == 3 && (output = iClasspathEntry.getOutputLocation()) != null) {
                        outputPaths.add(output);
                    }
                    ++i;
                }
            }
            outputPaths.add(project.getOutputLocation());
            IPath workspaceLocation = root.getLocation();
            for (IPath iPath : outputPaths) {
                IPath outputPath = workspaceLocation.append(iPath);
                URL outputURL = outputPath.toFile().toURI().toURL();
                pathElements.add(outputURL);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return pathElements.toArray(new URL[pathElements.size()]);
    }

    private static URL getRawLocationURL(IPath simplePath) throws MalformedURLException {
        File file = CodeExecutionJdtClassLoader.getRawLocationFile(simplePath);
        return file.toURI().toURL();
    }

    private static File getRawLocationFile(IPath simplePath) {
        IResource resource = root.findMember(simplePath);
        File file = null;
        file = resource != null ? root.findMember(simplePath).getRawLocation().toFile() : simplePath.toFile();
        return file;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        this.updateSearchPaths();
        Class<?> clazz = super.findClass(name);
        return clazz;
    }
}

