/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.preferences;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.runtime.preferences.PreferenceFilterEntry;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.IMavenConfigurationChangeListener;
import org.eclipse.m2e.core.embedder.MavenConfigurationChangeEvent;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.preferences.ProblemSeverity;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenConfigurationImpl
implements IMavenConfiguration,
IEclipsePreferences.IPreferenceChangeListener,
IEclipsePreferences.INodeChangeListener {
    private static final Logger log = LoggerFactory.getLogger(MavenConfigurationImpl.class);
    private final IEclipsePreferences[] preferencesLookup = new IEclipsePreferences[2];
    private final IPreferencesService preferenceStore;
    private final ListenerList<IMavenConfigurationChangeListener> listeners = new ListenerList(1);

    public MavenConfigurationImpl() {
        this.preferenceStore = Platform.getPreferencesService();
        this.init();
    }

    private boolean exists(IEclipsePreferences preferenceNode) {
        if (preferenceNode == null) {
            return false;
        }
        try {
            return preferenceNode.nodeExists("");
        }
        catch (BackingStoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    private void init() {
        if (this.exists(this.preferencesLookup[0])) {
            ((IEclipsePreferences)this.preferencesLookup[0].parent()).removeNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
            this.preferencesLookup[0].removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
        this.preferencesLookup[0] = InstanceScope.INSTANCE.getNode("org.eclipse.m2e.core");
        ((IEclipsePreferences)this.preferencesLookup[0].parent()).addNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
        this.preferencesLookup[0].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        if (this.exists(this.preferencesLookup[1])) {
            ((IEclipsePreferences)this.preferencesLookup[1].parent()).removeNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
            this.preferencesLookup[1].removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
        this.preferencesLookup[1] = DefaultScope.INSTANCE.getNode("org.eclipse.m2e.core");
        ((IEclipsePreferences)this.preferencesLookup[1].parent()).addNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
    }

    @Override
    public String getGlobalSettingsFile() {
        return this.preferenceStore.get("eclipse.m2.globalSettingsFile", null, (Preferences[])this.preferencesLookup);
    }

    @Override
    public String getUserSettingsFile() {
        return this.preferenceStore.get("eclipse.m2.userSettingsFile", null, (Preferences[])this.preferencesLookup);
    }

    @Override
    public boolean isDebugOutput() {
        return Boolean.parseBoolean(this.preferenceStore.get("eclipse.m2.debugOutput", null, (Preferences[])this.preferencesLookup));
    }

    public void setDebugOutput(boolean debug) {
        this.preferencesLookup[0].putBoolean("eclipse.m2.debugOutput", debug);
    }

    @Override
    public boolean isDownloadJavaDoc() {
        return Boolean.parseBoolean(this.preferenceStore.get("eclipse.m2.downloadJavadoc", null, (Preferences[])this.preferencesLookup));
    }

    @Override
    public boolean isDownloadSources() {
        return Boolean.parseBoolean(this.preferenceStore.get("eclipse.m2.downloadSources", null, (Preferences[])this.preferencesLookup));
    }

    public void setDownloadSources(boolean downloadSources) {
        this.preferencesLookup[0].putBoolean("eclipse.m2.downloadSources", downloadSources);
    }

    public void setDownloadJavadoc(boolean downloadJavadoc) {
        this.preferencesLookup[0].putBoolean("eclipse.m2.downloadJavadoc", downloadJavadoc);
    }

    @Override
    public boolean isHideFoldersOfNestedProjects() {
        return Boolean.parseBoolean(this.preferenceStore.get("eclipse.m2.hideFoldersOfNestedProjects", null, (Preferences[])this.preferencesLookup));
    }

    @Override
    public boolean isOffline() {
        return Boolean.parseBoolean(this.preferenceStore.get("eclipse.m2.offline", null, (Preferences[])this.preferencesLookup));
    }

    @Override
    public void setUserSettingsFile(String settingsFile) throws CoreException {
        if (!this.eq(settingsFile = this.trim(settingsFile), this.preferencesLookup[0].get("eclipse.m2.userSettingsFile", null))) {
            if (settingsFile != null) {
                this.preferencesLookup[0].put("eclipse.m2.userSettingsFile", settingsFile);
            } else {
                this.preferencesLookup[0].remove("eclipse.m2.userSettingsFile");
            }
            this.preferenceStore.applyPreferences(this.preferencesLookup[0], new IPreferenceFilter[]{this.getPreferenceFilter()});
        }
    }

    @Override
    public void setGlobalSettingsFile(String globalSettingsFile) throws CoreException {
        if (!this.eq(globalSettingsFile = this.trim(globalSettingsFile), this.preferencesLookup[0].get("eclipse.m2.globalSettingsFile", null))) {
            if (globalSettingsFile != null) {
                this.preferencesLookup[0].put("eclipse.m2.globalSettingsFile", globalSettingsFile);
            } else {
                this.preferencesLookup[0].remove("eclipse.m2.globalSettingsFile");
            }
            this.preferenceStore.applyPreferences(this.preferencesLookup[0], new IPreferenceFilter[]{this.getPreferenceFilter()});
        }
    }

    private boolean eq(String a, String b) {
        return a != null ? a.equals(b) : b == null;
    }

    private String trim(String str) {
        if (str == null) {
            return null;
        }
        return !(str = str.trim()).isEmpty() ? str : null;
    }

    @Override
    public boolean isUpdateProjectsOnStartup() {
        return Boolean.parseBoolean(this.preferenceStore.get("eclipse.m2.updateProjects", null, (Preferences[])this.preferencesLookup));
    }

    @Override
    public boolean isUpdateIndexesOnStartup() {
        return Boolean.parseBoolean(this.preferenceStore.get("eclipse.m2.updateIndexes", null, (Preferences[])this.preferencesLookup));
    }

    @Override
    public synchronized void addConfigurationChangeListener(IMavenConfigurationChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        MavenConfigurationChangeEvent mavenEvent = new MavenConfigurationChangeEvent(event.getKey(), event.getNewValue(), event.getOldValue());
        for (IMavenConfigurationChangeListener listener : this.listeners) {
            try {
                listener.mavenConfigurationChange(mavenEvent);
            }
            catch (Exception e) {
                log.error("Could not deliver maven configuration change event", (Throwable)e);
            }
        }
    }

    public void added(IEclipsePreferences.NodeChangeEvent event) {
    }

    public void removed(IEclipsePreferences.NodeChangeEvent event) {
        if (event.getChild() == this.preferencesLookup[0] || event.getChild() == this.preferencesLookup[1]) {
            this.init();
        }
    }

    private IPreferenceFilter getPreferenceFilter() {
        return new IPreferenceFilter(){

            public String[] getScopes() {
                return new String[]{"instance", "default"};
            }

            public Map<String, PreferenceFilterEntry[]> getMapping(String scope) {
                return null;
            }
        };
    }

    @Override
    public String getGlobalUpdatePolicy() {
        boolean never = Boolean.parseBoolean(this.preferenceStore.get("eclipse.m2.globalUpdatePolicy", null, (Preferences[])this.preferencesLookup));
        return never ? "never" : null;
    }

    public void setGlobalUpdatePolicy(String policy) {
        if (policy == null) {
            this.preferencesLookup[0].putBoolean("eclipse.m2.globalUpdatePolicy", false);
        } else if ("never".equals(policy)) {
            this.preferencesLookup[0].putBoolean("eclipse.m2.globalUpdatePolicy", true);
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public String getWorkspaceLifecycleMappingMetadataFile() {
        IPath stateLocation = MavenPluginActivator.getDefault().getStateLocation();
        String defaultValue = stateLocation.append("lifecycle-mapping-metadata.xml").toString();
        return this.preferenceStore.get("eclipse.m2.WorkspacelifecycleMappingsLocation", defaultValue, (Preferences[])this.preferencesLookup);
    }

    @Override
    public void setWorkspaceLifecycleMappingMetadataFile(String location) throws CoreException {
        if (location != null) {
            this.preferencesLookup[0].put("eclipse.m2.WorkspacelifecycleMappingsLocation", location);
        } else {
            this.preferencesLookup[0].remove("eclipse.m2.WorkspacelifecycleMappingsLocation");
        }
        this.preferenceStore.applyPreferences(this.preferencesLookup[0], new IPreferenceFilter[]{this.getPreferenceFilter()});
    }

    @Override
    public String getOutOfDateProjectSeverity() {
        return this.preferenceStore.get("eclipse.m2.problem.outofdateProjectConfig", ProblemSeverity.error.toString(), (Preferences[])this.preferencesLookup);
    }

    public void setOutOfDateProjectSeverity(String severity) throws CoreException {
        if (severity == null) {
            this.preferencesLookup[0].remove("eclipse.m2.problem.outofdateProjectConfig");
        } else {
            this.preferencesLookup[0].put("eclipse.m2.problem.outofdateProjectConfig", severity);
        }
        this.preferenceStore.applyPreferences(this.preferencesLookup[0], new IPreferenceFilter[]{this.getPreferenceFilter()});
    }

    @Override
    public String getGlobalChecksumPolicy() {
        return this.preferenceStore.get("eclipse.m2.globalChecksumPolicy", null, (Preferences[])this.preferencesLookup);
    }

    public void setGlobalChecksumPolicy(String checksumPolicy) {
        if (checksumPolicy == null) {
            this.preferencesLookup[0].remove("eclipse.m2.globalChecksumPolicy");
        } else if ("fail".equals(checksumPolicy) || "warn".equals(checksumPolicy) || "ignore".equals(checksumPolicy)) {
            this.preferencesLookup[0].put("eclipse.m2.globalChecksumPolicy", checksumPolicy);
        } else {
            throw new IllegalArgumentException(String.valueOf(checksumPolicy) + " is not a valid checksum policy");
        }
    }

    @Override
    public String getNotCoveredMojoExecutionSeverity() {
        return this.preferenceStore.get("eclipse.m2.problem.notCoveredMojoExecution", ProblemSeverity.error.toString(), (Preferences[])this.preferencesLookup);
    }

    public void setNotCoveredMojoExecutionSeverity(String severity) throws CoreException {
        if (severity == null) {
            this.preferencesLookup[0].remove("eclipse.m2.problem.notCoveredMojoExecution");
        } else {
            this.preferencesLookup[0].put("eclipse.m2.problem.notCoveredMojoExecution", severity);
        }
        this.preferenceStore.applyPreferences(this.preferencesLookup[0], new IPreferenceFilter[]{this.getPreferenceFilter()});
    }

    @Override
    public String getOverridingManagedVersionExecutionSeverity() {
        return this.preferenceStore.get("eclipse.m2.problem.overridingManagedVersion", ProblemSeverity.warning.toString(), (Preferences[])this.preferencesLookup);
    }

    public void setOverridingManagedVersionExecutionSeverity(String severity) throws CoreException {
        if (severity == null) {
            this.preferencesLookup[0].remove("eclipse.m2.problem.overridingManagedVersion");
        } else {
            this.preferencesLookup[0].put("eclipse.m2.problem.overridingManagedVersion", severity);
        }
        this.preferenceStore.applyPreferences(this.preferencesLookup[0], new IPreferenceFilter[]{this.getPreferenceFilter()});
    }

    @Override
    public boolean isAutomaticallyUpdateConfiguration() {
        return Boolean.parseBoolean(this.preferenceStore.get("eclipse.m2.autoUpdateProjects", null, (Preferences[])this.preferencesLookup));
    }

    public void setAutomaticallyUpdateConfiguration(boolean value) {
        this.preferencesLookup[0].putBoolean("eclipse.m2.autoUpdateProjects", value);
    }

    @Override
    public boolean buildWithNullSchedulingRule() {
        return Boolean.parseBoolean(this.preferenceStore.get("builderUsesNullSchedulingRule", null, (Preferences[])this.preferencesLookup));
    }
}

