/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.wizard.template;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.xtext.ui.wizard.template.ContainerTemplateVariable;
import org.eclipse.xtext.ui.wizard.template.ParameterComposite;
import org.eclipse.xtext.ui.wizard.template.TemplateVariable;

public class BooleanTemplateVariable
extends TemplateVariable {
    private boolean value;
    private Button checkbox;

    public BooleanTemplateVariable(String label, boolean defaultValue, String description, ContainerTemplateVariable container) {
        super(label, description, container);
        this.value = defaultValue;
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public void createWidget(final ParameterComposite parameterComposite, Composite parent) {
        this.checkbox = new Button(parent, 32);
        this.checkbox.setText(this.getLabel());
        this.checkbox.setSelection(this.getValue());
        this.checkbox.setToolTipText(this.getDescription());
        this.checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BooleanTemplateVariable.this.setValue(BooleanTemplateVariable.this.checkbox.getSelection());
                parameterComposite.update();
            }
        });
    }

    @Override
    public void refresh() {
        if (this.checkbox.isEnabled() != this.isEnabled()) {
            this.checkbox.setEnabled(this.isEnabled());
        }
        if (this.checkbox.getSelection() != this.getValue()) {
            this.checkbox.setSelection(this.getValue());
        }
    }

    @Override
    public boolean isLabeled() {
        return false;
    }

    @Override
    public Control getWidget() {
        return this.checkbox;
    }

    public String toString() {
        return Boolean.valueOf(this.value).toString();
    }

    public void setValue(boolean value) {
        this.value = value;
    }
}

