/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.command.builders;

import java.util.HashMap;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.InitInterpreterVariablesTask;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.description.tool.DoubleClickDescription;
import org.eclipse.sirius.diagram.description.tool.ElementDoubleClickVariable;
import org.eclipse.sirius.diagram.description.tool.Navigation;
import org.eclipse.sirius.diagram.tools.internal.command.builders.AbstractDiagramCommandBuilder;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.tools.internal.command.builders.ElementsToSelectTask;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;

public class DoubleClickCommandBuilder
extends AbstractDiagramCommandBuilder {
    private DoubleClickDescription tool;
    private DDiagramElement dDiagramElement;

    public DoubleClickCommandBuilder(DoubleClickDescription tool, DDiagramElement dDiagramElement) {
        this.tool = tool;
        this.dDiagramElement = dDiagramElement;
    }

    public Command buildCommand() {
        if (this.canDoubleClick()) {
            HashMap<ElementDoubleClickVariable, Object> variables = new HashMap<ElementDoubleClickVariable, Object>();
            variables.put(this.tool.getElement(), this.dDiagramElement.getTarget());
            variables.put(this.tool.getElementView(), this.dDiagramElement);
            DCommand cmd = this.createEnclosingCommand();
            IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)this.dDiagramElement);
            cmd.getTasks().add(new InitInterpreterVariablesTask(variables, interpreter, this.uiCallback));
            Option<DDiagram> parentDiagram = this.getDDiagram();
            if (this.tool.getInitialOperation() != null && this.tool.getInitialOperation().getFirstModelOperations() != null) {
                cmd.getTasks().add(this.taskHelper.buildTaskFromModelOperation((DRepresentation)parentDiagram.get(), (EObject)this.dDiagramElement, this.tool.getInitialOperation().getFirstModelOperations()));
                this.addPostOperationTasks(cmd, interpreter);
            }
            return cmd;
        }
        return UnexecutableCommand.INSTANCE;
    }

    private boolean canDoubleClick() {
        boolean valid = !this.isInLayoutingModeDiagram((EObject)this.dDiagramElement) && !this.isInShowingModeDiagram(this.dDiagramElement) || this.tool.getInitialOperation().getFirstModelOperations() instanceof Navigation;
        valid = valid && this.checkPrecondition(this.dDiagramElement, (AbstractToolDescription)this.tool);
        return valid;
    }

    protected void addPostOperationTasks(DCommand command, IInterpreter interpreter) {
        if (this.dDiagramElement != null) {
            this.addRefreshTask(this.dDiagramElement, command, (AbstractToolDescription)this.tool);
            Option<DDiagram> parentDiagram = new EObjectQuery((EObject)this.dDiagramElement).getParentDiagram();
            command.getTasks().add(new ElementsToSelectTask((AbstractToolDescription)this.tool, interpreter, this.dDiagramElement.getTarget(), (DRepresentation)parentDiagram.get()));
        }
    }

    protected String getEnclosingCommandLabel() {
        return new IdentifiedElementQuery((IdentifiedElement)this.tool).getLabel();
    }

    @Override
    protected Option<DDiagram> getDDiagram() {
        return new EObjectQuery((EObject)this.dDiagramElement).getParentDiagram();
    }
}

