/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.notation.ConnectorStyle;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.business.api.refresh.DiagramCreationUtil;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.osgi.framework.Version;

public class DeleteMultipleConnectorStyleMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    public static final Version MIGRATION_VERSION = new Version("14.1.0.201810161215");
    private boolean migrationOccured;

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            StringBuilder sb = new StringBuilder(Messages.DeleteMultipleConnectorMigrationParticipant_title);
            EList ownedViews = dAnalysis.getOwnedViews();
            for (DView view : ownedViews) {
                List loadedRepresentationsDescriptors = new DViewQuery(view).getLoadedRepresentationsDescriptors();
                for (DRepresentationDescriptor descriptor : loadedRepresentationsDescriptors) {
                    DRepresentation rep = descriptor.getRepresentation();
                    if (!(rep instanceof DSemanticDiagram)) continue;
                    DSemanticDiagram dDiagram = (DSemanticDiagram)rep;
                    boolean isEdgeModified = false;
                    List<Edge> edgeList = this.getEdgeList((DDiagram)dDiagram);
                    for (Edge edge : edgeList) {
                        boolean bl = isEdgeModified = this.checkAndDeleteMultipleConnectorStyle(edge) || isEdgeModified;
                    }
                    if (!isEdgeModified) continue;
                    this.migrationOccured = true;
                    sb.append(MessageFormat.format(Messages.DeleteMultipleConnectorMigrationParticipant_edgesModified, descriptor.getName()));
                }
                if (!this.migrationOccured) continue;
                DiagramPlugin.getDefault().logInfo(sb.toString());
                this.migrationOccured = false;
            }
        }
    }

    private boolean checkAndDeleteMultipleConnectorStyle(Edge edge) {
        boolean isEdgeModified = false;
        List connectorStyles = edge.getStyles().stream().filter(ConnectorStyle.class::isInstance).collect(Collectors.toList());
        if (connectorStyles.size() > 1) {
            int i = 1;
            while (i < connectorStyles.size()) {
                edge.getStyles().remove(connectorStyles.get(i));
                ++i;
            }
            isEdgeModified = true;
        }
        return isEdgeModified;
    }

    protected List<Edge> getEdgeList(DDiagram representation) {
        EList edges = new ArrayList();
        DiagramCreationUtil diagramCreationUtil = new DiagramCreationUtil(representation);
        if (diagramCreationUtil.findAssociatedGMFDiagram()) {
            Diagram gmfDiagram = diagramCreationUtil.getAssociatedGMFDiagram();
            edges = gmfDiagram.getEdges();
        }
        return edges;
    }
}

