/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.dialect.description;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.dialect.description.AbstractInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.dialect.description.DefaultInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.table.business.internal.dialect.description.TableInterpretedTargetSwitch;
import org.eclipse.sirius.table.metamodel.table.TablePackage;
import org.eclipse.sirius.table.metamodel.table.description.CellEditorTool;
import org.eclipse.sirius.table.metamodel.table.description.ColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.CreateCellTool;
import org.eclipse.sirius.table.metamodel.table.description.CreateColumnTool;
import org.eclipse.sirius.table.metamodel.table.description.CreateLineTool;
import org.eclipse.sirius.table.metamodel.table.description.DeleteColumnTool;
import org.eclipse.sirius.table.metamodel.table.description.DeleteLineTool;
import org.eclipse.sirius.table.metamodel.table.description.DescriptionPackage;
import org.eclipse.sirius.table.metamodel.table.description.ElementColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.FeatureColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.IntersectionMapping;
import org.eclipse.sirius.table.metamodel.table.description.LabelEditTool;
import org.eclipse.sirius.table.metamodel.table.description.LineMapping;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.viewpoint.description.AbstractVariable;
import org.eclipse.sirius.viewpoint.description.tool.EditMaskVariables;

public class TableInterpretedExpressionQuery
extends AbstractInterpretedExpressionQuery {
    public TableInterpretedExpressionQuery(EObject target, EStructuralFeature feature) {
        super(target, feature);
    }

    public Collection<EPackage> getPackagesToImport() {
        Collection superResult = super.getPackagesToImport();
        superResult.add(TablePackage.eINSTANCE);
        superResult.add(DescriptionPackage.eINSTANCE);
        return superResult;
    }

    protected void initializeTargetSwitch() {
        this.targetSwitch = new TableGlobalInterpretedTargetSwitch();
    }

    protected void appendAllLocalVariableDefinitions(Map<String, Collection<VariableType>> definitions, EObject context) {
        super.appendAllLocalVariableDefinitions(definitions, context);
        EditMaskVariables emv = null;
        if (context instanceof LabelEditTool) {
            emv = ((LabelEditTool)context).getMask();
            for (AbstractVariable subVar : ((LabelEditTool)context).getVariables()) {
                this.availableVariables.put(subVar.getName(), this.getVariableTypeName(subVar));
            }
        } else if (context instanceof CellEditorTool) {
            for (AbstractVariable subVar : ((CellEditorTool)context).getVariables()) {
                this.availableVariables.put(subVar.getName(), this.getVariableTypeName(subVar));
            }
        } else if (context instanceof CreateCellTool) {
            emv = ((CreateCellTool)context).getMask();
        }
        if (emv != null) {
            this.appendEditMaskVariables(emv, definitions);
        }
    }

    protected void addVariablesFromToolContext(EObject toolContext) {
        if (toolContext instanceof CreateCellTool) {
            CreateCellTool tool = (CreateCellTool)toolContext;
            IntersectionMapping interMapping = tool.getMapping();
            if (interMapping != null) {
                this.declareLineAndColumnSemantic(this.availableVariables, interMapping);
            }
        } else if (toolContext instanceof LabelEditTool) {
            LabelEditTool tool = (LabelEditTool)toolContext;
            if (tool.eContainer() instanceof IntersectionMapping) {
                IntersectionMapping interMapping = (IntersectionMapping)tool.eContainer();
                this.declareLineAndColumnSemantic(this.availableVariables, interMapping);
            }
            this.availableVariables.put("line", VariableType.fromEClassifiers(Arrays.asList(TablePackage.Literals.DLINE)));
            this.availableVariables.put("table", VariableType.fromEClassifiers(Arrays.asList(TablePackage.Literals.DTABLE)));
        } else if (toolContext instanceof CellEditorTool) {
            this.availableVariables.put("line", VariableType.fromEClassifiers(Arrays.asList(TablePackage.Literals.DLINE)));
            this.availableVariables.put("table", VariableType.fromEClassifiers(Arrays.asList(TablePackage.Literals.DTABLE)));
        } else if (toolContext instanceof CreateLineTool) {
            CreateLineTool tool = (CreateLineTool)toolContext;
            Set<String> possibleTypes = this.collectTypes(tool.eContainer());
            this.refineVariableType(this.availableVariables, "element", possibleTypes);
            this.refineVariableType(this.availableVariables, "container", possibleTypes);
            this.declareRootTableType(this.availableVariables, toolContext);
        } else if (toolContext instanceof CreateColumnTool) {
            CreateColumnTool tool = (CreateColumnTool)toolContext;
            Set<String> possibleTypes = this.collectTypes(tool.eContainer());
            this.refineVariableType(this.availableVariables, "element", possibleTypes);
            this.refineVariableType(this.availableVariables, "container", possibleTypes);
            this.declareRootTableType(this.availableVariables, toolContext);
        } else if (toolContext instanceof DeleteLineTool) {
            DeleteLineTool tool = (DeleteLineTool)toolContext;
            LineMapping mapping = tool.getMapping();
            String domainClass = mapping.getDomainClass();
            if (!StringUtil.isEmpty((String)domainClass)) {
                this.availableVariables.put("element", VariableType.fromString((String)domainClass));
            }
            this.declareRootTableType(this.availableVariables, toolContext);
        } else if (toolContext instanceof DeleteColumnTool) {
            DeleteColumnTool tool = (DeleteColumnTool)toolContext;
            ElementColumnMapping mapping = tool.getMapping();
            Set<String> possibleTypes = this.collectTypes(mapping);
            this.refineVariableType(this.availableVariables, "element", possibleTypes);
            this.declareRootTableType(this.availableVariables, toolContext);
        }
    }

    private void refineVariableType(Map<String, VariableType> availableVariables, String variableName, Collection<String> foundTypes) {
        if (foundTypes.size() > 0) {
            availableVariables.put(variableName, VariableType.fromStrings(foundTypes));
        }
    }

    private Set<String> collectTypes(EObject container) {
        Option tableDef;
        LinkedHashSet<String> possibleTypes = new LinkedHashSet<String>();
        if (container instanceof TableDescription) {
            String domainClass = ((TableDescription)container).getDomainClass();
            if (!StringUtil.isEmpty((String)domainClass)) {
                possibleTypes.add(domainClass);
            }
        } else if (container instanceof LineMapping) {
            String domainClass = ((LineMapping)container).getDomainClass();
            if (!StringUtil.isEmpty((String)domainClass)) {
                possibleTypes.add(domainClass);
            }
        } else if (container instanceof ElementColumnMapping) {
            String domainClass = ((ElementColumnMapping)container).getDomainClass();
            if (!StringUtil.isEmpty((String)domainClass)) {
                possibleTypes.add(domainClass);
            }
        } else if (container instanceof FeatureColumnMapping && (tableDef = new EObjectQuery(container).getFirstAncestorOfType(DescriptionPackage.Literals.TABLE_DESCRIPTION)).some() && tableDef.get() instanceof TableDescription) {
            TableDescription table = (TableDescription)tableDef.get();
            for (LineMapping lMapping : table.getAllLineMappings()) {
                String domainClass = lMapping.getDomainClass();
                if (StringUtil.isEmpty((String)domainClass)) continue;
                possibleTypes.add(domainClass);
            }
        }
        return possibleTypes;
    }

    private void declareRootTableType(Map<String, VariableType> availableVariables, EObject operationContext) {
        TableDescription table;
        String domainClass;
        Option tableDef = new EObjectQuery(operationContext).getFirstAncestorOfType(DescriptionPackage.Literals.TABLE_DESCRIPTION);
        if (tableDef.some() && tableDef.get() instanceof TableDescription && !StringUtil.isEmpty((String)(domainClass = (table = (TableDescription)tableDef.get()).getDomainClass()))) {
            availableVariables.put("root", VariableType.fromString((String)domainClass));
        }
    }

    private void declareLineAndColumnSemantic(Map<String, VariableType> availableVariables, IntersectionMapping interMapping) {
        ColumnMapping cMapping = interMapping.getColumnMapping();
        LinkedHashSet<String> possibleLineTypes = new LinkedHashSet<String>();
        for (LineMapping lineMapping : interMapping.getLineMapping()) {
            if (StringUtil.isEmpty((String)lineMapping.getDomainClass())) continue;
            possibleLineTypes.add(lineMapping.getDomainClass());
        }
        LinkedHashSet<String> possibleColumnTypes = new LinkedHashSet<String>();
        if (cMapping instanceof ElementColumnMapping) {
            String columnDomain = ((ElementColumnMapping)cMapping).getDomainClass();
            if (!StringUtil.isEmpty((String)columnDomain)) {
                possibleColumnTypes.add(columnDomain);
            }
        } else if (cMapping instanceof FeatureColumnMapping) {
            possibleColumnTypes.addAll(possibleLineTypes);
        }
        if (possibleLineTypes.size() > 0) {
            availableVariables.put("lineSemantic", VariableType.fromStrings(possibleLineTypes));
        } else {
            availableVariables.put("lineSemantic", VariableType.ANY_EOBJECT);
        }
        if (possibleColumnTypes.size() > 0) {
            availableVariables.put("columnSemantic", VariableType.fromStrings(possibleColumnTypes));
        } else {
            availableVariables.put("lineSemantic", VariableType.ANY_EOBJECT);
        }
    }

    protected Option<EObject> getToolContext() {
        Option result = super.getToolContext();
        if (!result.some()) {
            result = new EObjectQuery(this.target).getFirstAncestorOfType(DescriptionPackage.eINSTANCE.getTableTool());
        }
        return result;
    }

    private class TableGlobalInterpretedTargetSwitch
    implements IInterpretedExpressionTargetSwitch {
        private final DefaultInterpretedExpressionTargetSwitch defaultSwitch;
        private final TableInterpretedTargetSwitch specificTableSwitch;

        private TableGlobalInterpretedTargetSwitch() {
            this.defaultSwitch = new DefaultInterpretedExpressionTargetSwitch(TableInterpretedExpressionQuery.this.feature, (IInterpretedExpressionTargetSwitch)this);
            this.specificTableSwitch = new TableInterpretedTargetSwitch(TableInterpretedExpressionQuery.this.feature, this);
        }

        public Option<Collection<String>> doSwitch(EObject target, boolean considerFeature) {
            LinkedHashSet targetTypes = new LinkedHashSet();
            Option expressionTarget = Options.newSome(targetTypes);
            if (target != null) {
                String packageURI = target.eClass().getEPackage().getNsURI();
                if (DescriptionPackage.eINSTANCE.getNsURI().equals(packageURI)) {
                    this.specificTableSwitch.setConsiderFeature(considerFeature);
                    expressionTarget = this.specificTableSwitch.doSwitch(target);
                }
                if (expressionTarget.some() && ((Collection)expressionTarget.get()).isEmpty()) {
                    expressionTarget = this.defaultSwitch.doSwitch(target, considerFeature);
                }
            }
            return expressionTarget;
        }

        public EObject getFirstRelevantContainer(EObject obj) {
            return this.defaultSwitch != null ? this.defaultSwitch.getFirstRelevantContainer(obj) : null;
        }
    }
}

