/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.env.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecoretools.ale.core.env.IBehaviors;
import org.eclipse.emf.ecoretools.ale.core.parser.ParsedFile;
import org.eclipse.emf.ecoretools.ale.implementation.BehavioredClass;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.implementation.RuntimeClass;

public class ImmutableBehaviors
implements IBehaviors {
    private final List<ParsedFile<ModelUnit>> raw;

    public ImmutableBehaviors(Collection<ParsedFile<ModelUnit>> raw) {
        this.raw = new ArrayList<ParsedFile<ModelUnit>>(raw);
    }

    @Override
    public List<ModelUnit> getUnits() {
        return this.nonNullUnits().collect(Collectors.toList());
    }

    @Override
    public List<BehavioredClass> getClasses() {
        return this.nonNullUnits().flatMap(unit -> ImmutableBehaviors.classesIn(unit)).collect(Collectors.toList());
    }

    @Override
    public Optional<BehavioredClass> findClass(String qualifiedName) {
        return this.getClasses().stream().filter(behavior -> behavior.getName().equals(qualifiedName)).findAny();
    }

    private static Stream<BehavioredClass> classesIn(ModelUnit unit) {
        Stream dynamicClasses = unit.getClassDefinitions().stream();
        Stream staticClasses = unit.getClassExtensions().stream();
        return Stream.concat(dynamicClasses, staticClasses);
    }

    @Override
    public List<ExtendedClass> getOpenClasses() {
        return this.nonNullUnits().flatMap(unit -> unit.getClassExtensions().stream()).collect(Collectors.toList());
    }

    @Override
    public List<RuntimeClass> getRuntimeClasses() {
        return this.nonNullUnits().flatMap(unit -> unit.getClassDefinitions().stream()).collect(Collectors.toList());
    }

    @Override
    public Set<String> getServices() {
        return this.nonNullUnits().flatMap(root -> root.getServices().stream()).collect(Collectors.toSet());
    }

    @Override
    public Optional<Method> findMethod(EOperation correspondingOperation) {
        return this.nonNullUnits().flatMap(unit -> unit.getClassExtensions().stream()).flatMap(cls -> cls.getMethods().stream()).filter(mtd -> mtd.getOperationRef() == correspondingOperation).findAny();
    }

    @Override
    public List<Method> getMainMethods() {
        return this.nonNullUnits().flatMap(parsedFile -> parsedFile.getClassExtensions().stream()).flatMap(clazz -> clazz.getMethods().stream()).filter(method -> method.getTags().contains((Object)"main")).collect(Collectors.toList());
    }

    @Override
    public List<ParsedFile<ModelUnit>> getParsedFiles() {
        return new ArrayList<ParsedFile<ModelUnit>>(this.raw);
    }

    @Override
    public Optional<ParsedFile<ModelUnit>> findParsedFileDefining(Object astElement) {
        for (ParsedFile<ModelUnit> parsedFile : this.raw) {
            boolean parsedFileDefinesTheElement;
            boolean bl = parsedFileDefinesTheElement = parsedFile.getStartPositions().get(astElement) != null;
            if (!parsedFileDefinesTheElement) continue;
            return Optional.of(parsedFile);
        }
        return Optional.empty();
    }

    private Stream<ModelUnit> nonNullUnits() {
        return this.raw.stream().map(ParsedFile::getRoot).filter(Objects::nonNull);
    }
}

