/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.ui.views.engine.actions;

import org.eclipse.gemoc.executionframework.ui.Activator;
import org.eclipse.gemoc.executionframework.ui.views.engine.IEngineSelectionListener;
import org.eclipse.gemoc.xdsmlframework.api.core.EngineStatus;
import org.eclipse.gemoc.xdsmlframework.api.core.ExecutionMode;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class AbstractEngineAction
extends Action
implements IMenuCreator,
IEngineSelectionListener {
    protected IExecutionEngine<?> _currentSelectedEngine;

    public AbstractEngineAction() {
        super("fake", 1);
        this.setMenuCreator(this);
        this.setEnabled(false);
        this.init();
        this.updateButton();
        Activator.getDefault().getEngineSelectionManager().addEngineSelectionListener(this);
    }

    public AbstractEngineAction(int style) {
        super("fake", style);
        this.setMenuCreator(this);
        this.setEnabled(false);
        this.init();
        this.updateButton();
        Activator.getDefault().getEngineSelectionManager().addEngineSelectionListener(this);
    }

    protected void init() {
    }

    protected void updateButton() {
    }

    public void dispose() {
        Activator.getDefault().getEngineSelectionManager().removeEngineSelectionListener(this);
    }

    protected void showMessage(IWorkbenchPartSite partSite, String message) {
        MessageDialog.openInformation((Shell)partSite.getShell(), (String)"Gemoc Engines Status", (String)message);
    }

    public IExecutionEngine<?> getCurrentSelectedEngine() {
        return this._currentSelectedEngine;
    }

    @Override
    public void engineSelectionChanged(IExecutionEngine<?> engine) {
        this._currentSelectedEngine = engine;
        if (this._currentSelectedEngine == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(!this._currentSelectedEngine.getRunningStatus().equals((Object)EngineStatus.RunStatus.Stopped) && this._currentSelectedEngine.getExecutionContext().getExecutionMode().equals((Object)ExecutionMode.Animation));
        }
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }
}

