/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.manipulation.CodeGeneration;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.ConvertAnonymousDescriptor;
import org.eclipse.jdt.internal.core.manipulation.BindingLabelProviderCore;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroupCore;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.ModifierCorrectionSubProcessorCore;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class ConvertAnonymousToNestedRefactoring
extends Refactoring {
    private static final String ATTRIBUTE_VISIBILITY = "visibility";
    private static final String ATTRIBUTE_FINAL = "final";
    private static final String ATTRIBUTE_STATIC = "static";
    private static final String KEY_TYPE_NAME = "type_name";
    private static final String KEY_PARAM_NAME_EXT = "param_name_ext";
    private static final String KEY_PARAM_NAME_CONST = "param_name_const";
    private static final String KEY_FIELD_NAME_EXT = "field_name_ext";
    private int fSelectionStart;
    private int fSelectionLength;
    private ICompilationUnit fCu;
    private int fVisibility;
    private boolean fDeclareFinal = true;
    private boolean fDeclareStatic;
    private String fClassName = "";
    private CompilationUnit fCompilationUnitNode;
    private AnonymousClassDeclaration fAnonymousInnerClassNode;
    private Set<String> fClassNamesUsed;
    private boolean fSelfInitializing = false;
    private LinkedProposalModelCore fLinkedProposalModelCore;

    public ConvertAnonymousToNestedRefactoring(ICompilationUnit unit, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((unit == null || unit.exists() ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = unit;
        this.fAnonymousInnerClassNode = null;
        this.fCompilationUnitNode = null;
    }

    public ConvertAnonymousToNestedRefactoring(AnonymousClassDeclaration declaration) {
        Assert.isTrue((declaration != null ? 1 : 0) != 0);
        ASTNode astRoot = declaration.getRoot();
        Assert.isTrue((boolean)(astRoot instanceof CompilationUnit));
        this.fCompilationUnitNode = (CompilationUnit)astRoot;
        IJavaElement javaElement = this.fCompilationUnitNode.getJavaElement();
        Assert.isTrue((boolean)(javaElement instanceof ICompilationUnit));
        this.fCu = (ICompilationUnit)javaElement;
        this.fSelectionStart = declaration.getStartPosition();
        this.fSelectionLength = declaration.getLength();
    }

    public ConvertAnonymousToNestedRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null, 0, 0);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public void setLinkedProposalModel(LinkedProposalModelCore linkedProposalModel) {
        this.fLinkedProposalModelCore = linkedProposalModel;
    }

    public int[] getAvailableVisibilities() {
        if (this.isLocalInnerType()) {
            return new int[1];
        }
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[3] = 2;
        return nArray;
    }

    public boolean isLocalInnerType() {
        return ASTNodes.getParent((ASTNode)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, AbstractTypeDeclaration.class), 1) != null;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public void setVisibility(int visibility) {
        Assert.isTrue((visibility == 2 || visibility == 0 || visibility == 4 || visibility == 1 ? 1 : 0) != 0);
        this.fVisibility = visibility;
    }

    public void setClassName(String className) {
        Assert.isNotNull((Object)className);
        this.fClassName = className;
    }

    public boolean canEnableSettingFinal() {
        return true;
    }

    public boolean getDeclareFinal() {
        return this.fDeclareFinal;
    }

    public boolean getDeclareStatic() {
        return this.fDeclareStatic;
    }

    public void setDeclareFinal(boolean declareFinal) {
        this.fDeclareFinal = declareFinal;
    }

    public void setDeclareStatic(boolean declareStatic) {
        this.fDeclareStatic = declareStatic;
    }

    public String getName() {
        return RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_name;
    }

    private boolean useThisForFieldAccess() {
        return StubUtility.useThisForFieldAccess(this.fCu.getJavaProject());
    }

    private boolean doAddComments() {
        return StubUtility.doAddComments(this.fCu.getJavaProject());
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext(), pm);
        if (result.hasFatalError()) {
            return result;
        }
        this.initAST(pm);
        if (this.fAnonymousInnerClassNode == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_place_caret);
        }
        if (!this.fSelfInitializing) {
            this.initializeDefaults();
        }
        if (this.getSuperConstructorBinding() == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_compile_errors);
        }
        if (this.getSuperTypeBinding().isLocal()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_extends_local_class);
        }
        return new RefactoringStatus();
    }

    private void initializeDefaults() {
        this.fVisibility = this.isLocalInnerType() ? 0 : 2;
        this.fDeclareStatic = this.mustInnerClassBeStatic();
    }

    private void initAST(IProgressMonitor pm) {
        if (this.fCompilationUnitNode == null) {
            this.fCompilationUnitNode = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fCu, true, pm);
        }
        if (this.fAnonymousInnerClassNode == null) {
            this.fAnonymousInnerClassNode = ConvertAnonymousToNestedRefactoring.getAnonymousInnerClass(NodeFinder.perform((ASTNode)this.fCompilationUnitNode, (int)this.fSelectionStart, (int)this.fSelectionLength));
        }
        if (this.fAnonymousInnerClassNode != null) {
            AbstractTypeDeclaration declaration = ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, AbstractTypeDeclaration.class);
            if (declaration instanceof TypeDeclaration) {
                TypeDeclaration[] nested = ((TypeDeclaration)declaration).getTypes();
                this.fClassNamesUsed = new HashSet<String>(nested.length);
                TypeDeclaration[] typeDeclarationArray = nested;
                int n = nested.length;
                int n2 = 0;
                while (n2 < n) {
                    TypeDeclaration element = typeDeclarationArray[n2];
                    this.fClassNamesUsed.add(element.getName().getIdentifier());
                    ++n2;
                }
            } else {
                this.fClassNamesUsed = Collections.emptySet();
            }
        }
    }

    private static AnonymousClassDeclaration getAnonymousInnerClass(ASTNode node) {
        AnonymousClassDeclaration anon;
        if (node == null) {
            return null;
        }
        if (node instanceof AnonymousClassDeclaration) {
            return (AnonymousClassDeclaration)node;
        }
        if (node instanceof ClassInstanceCreation && (anon = ((ClassInstanceCreation)node).getAnonymousClassDeclaration()) != null) {
            return anon;
        }
        if ((node = ASTNodes.getNormalizedNode(node)).getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY && (anon = ((ClassInstanceCreation)node.getParent()).getAnonymousClassDeclaration()) != null) {
            return anon;
        }
        return ASTNodes.getParent(node, AnonymousClassDeclaration.class);
    }

    public RefactoringStatus validateInput() {
        RefactoringStatus result = Checks.checkTypeName(this.fClassName, (IJavaElement)this.fCu);
        if (result.hasFatalError()) {
            return result;
        }
        if (this.fClassNamesUsed.contains(this.fClassName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_type_exists);
        }
        IMethodBinding superConstructorBinding = this.getSuperConstructorBinding();
        if (superConstructorBinding == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_compile_errors);
        }
        if (this.fClassName.equals(superConstructorBinding.getDeclaringClass().getName())) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_another_name);
        }
        if (this.classNameHidesEnclosingType()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_name_hides);
        }
        return result;
    }

    private boolean accessesAnonymousFields() {
        List<IVariableBinding> anonymousInnerFieldTypes = this.getAllEnclosingAnonymousTypesField();
        List<IBinding> accessedField = this.getAllAccessedFields();
        for (IVariableBinding variableBinding : anonymousInnerFieldTypes) {
            for (IVariableBinding iVariableBinding : accessedField) {
                if (!Bindings.equals((IBinding)variableBinding, (IBinding)iVariableBinding)) continue;
                return true;
            }
        }
        return false;
    }

    private List<IBinding> getAllAccessedFields() {
        final ArrayList<IBinding> accessedFields = new ArrayList<IBinding>();
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(FieldAccess node) {
                IVariableBinding binding = node.resolveFieldBinding();
                if (binding != null && !binding.isEnumConstant()) {
                    accessedFields.add(binding);
                }
                return super.visit(node);
            }

            public boolean visit(QualifiedName node) {
                IVariableBinding variable;
                IBinding binding = node.resolveBinding();
                if (binding instanceof IVariableBinding && !(variable = (IVariableBinding)binding).isEnumConstant() && variable.isField()) {
                    accessedFields.add(binding);
                }
                return super.visit(node);
            }

            public boolean visit(SimpleName node) {
                IVariableBinding variable;
                IBinding binding = node.resolveBinding();
                if (binding instanceof IVariableBinding && !(variable = (IVariableBinding)binding).isEnumConstant() && variable.isField()) {
                    accessedFields.add(binding);
                }
                return super.visit(node);
            }

            public boolean visit(SuperFieldAccess node) {
                IVariableBinding binding = node.resolveFieldBinding();
                if (binding != null && !binding.isEnumConstant()) {
                    accessedFields.add(binding);
                }
                return super.visit(node);
            }
        };
        this.fAnonymousInnerClassNode.accept(visitor);
        return accessedFields;
    }

    private List<IVariableBinding> getAllEnclosingAnonymousTypesField() {
        ArrayList<IVariableBinding> ans = new ArrayList<IVariableBinding>();
        AbstractTypeDeclaration declaration = ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, AbstractTypeDeclaration.class);
        AnonymousClassDeclaration anonymous = (AnonymousClassDeclaration)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, 1);
        while (anonymous != null) {
            if (!ASTNodes.isParent((ASTNode)anonymous, (ASTNode)declaration)) break;
            ITypeBinding binding = anonymous.resolveBinding();
            if (binding != null) {
                ans.addAll(Arrays.asList(binding.getDeclaredFields()));
            }
            anonymous = (AnonymousClassDeclaration)ASTNodes.getParent((ASTNode)anonymous, 1);
        }
        return ans;
    }

    private boolean classNameHidesEnclosingType() {
        ITypeBinding type = ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, AbstractTypeDeclaration.class).resolveBinding();
        while (type != null) {
            if (this.fClassName.equals(type.getName())) {
                return true;
            }
            type = type.getDeclaringClass();
        }
        return false;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        try {
            RefactoringStatus status = this.validateInput();
            if (this.accessesAnonymousFields()) {
                status.merge(RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_anonymous_field_access));
            }
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public CompilationUnitChange createCompilationUnitChange(IProgressMonitor pm) throws CoreException {
        CompilationUnitRewrite rewrite = new CompilationUnitRewrite(this.fCu, this.fCompilationUnitNode);
        ITypeBinding[] typeParameters = this.getTypeParameters();
        this.addNestedClass(rewrite, typeParameters);
        this.modifyConstructorCall(rewrite, typeParameters);
        return rewrite.createChange(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_name, false, pm);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        CompilationUnitChange result = this.createCompilationUnitChange(pm);
        result.setDescriptor((ChangeDescriptor)this.createRefactoringDescriptor());
        return result;
    }

    private ITypeBinding[] getTypeParameters() {
        ArrayList<ITypeBinding> parameters = new ArrayList<ITypeBinding>(4);
        ClassInstanceCreation creation = (ClassInstanceCreation)this.fAnonymousInnerClassNode.getParent();
        if (this.fDeclareStatic) {
            TypeVariableFinder finder = new TypeVariableFinder();
            creation.accept((ASTVisitor)finder);
            return finder.getResult();
        }
        MethodDeclaration declaration = this.getEnclosingMethodDeclaration((ASTNode)creation);
        if (declaration != null) {
            ITypeBinding binding = null;
            TypeParameter parameter2 = null;
            for (TypeParameter parameter2 : declaration.typeParameters()) {
                binding = parameter2.resolveBinding();
                if (binding == null) continue;
                parameters.add(binding);
            }
        }
        TypeVariableFinder finder = new TypeVariableFinder();
        creation.accept((ASTVisitor)finder);
        ITypeBinding[] variables = finder.getResult();
        ArrayList<ITypeBinding> remove = new ArrayList<ITypeBinding>(4);
        boolean match = false;
        ITypeBinding binding = null;
        ITypeBinding variable = null;
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            match = false;
            binding = (ITypeBinding)iterator.next();
            ITypeBinding[] iTypeBindingArray = variables;
            int n = variables.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding variable2 = iTypeBindingArray[n2];
                variable = variable2;
                if (variable.equals((Object)binding)) {
                    match = true;
                }
                ++n2;
            }
            if (match) continue;
            remove.add(binding);
        }
        parameters.removeAll(remove);
        ITypeBinding[] result = new ITypeBinding[parameters.size()];
        parameters.toArray(result);
        return result;
    }

    private MethodDeclaration getEnclosingMethodDeclaration(ASTNode node) {
        ASTNode parent = node.getParent();
        if (parent != null) {
            if (parent instanceof AbstractTypeDeclaration) {
                return null;
            }
            if (parent instanceof MethodDeclaration) {
                return (MethodDeclaration)parent;
            }
            return this.getEnclosingMethodDeclaration(parent);
        }
        return null;
    }

    private RefactoringChangeDescriptor createRefactoringDescriptor() {
        ITypeBinding binding = this.fAnonymousInnerClassNode.resolveBinding();
        Object[] labels = new String[]{BindingLabelProviderCore.getBindingLabel((IBinding)binding, 2235681801344L), BindingLabelProviderCore.getBindingLabel((IBinding)binding.getDeclaringMethod(), 2235681801344L)};
        HashMap<String, String> arguments = new HashMap<String, String>();
        String projectName = this.fCu.getJavaProject().getElementName();
        String description = RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_descriptor_description_short;
        String header = Messages.format(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_descriptor_description, labels);
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(projectName, (Object)this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_original_pattern, BindingLabelProviderCore.getBindingLabel((IBinding)binding, 2235681801344L)));
        comment.addSetting(Messages.format(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_class_name_pattern, BasicElementLabels.getJavaElementName(this.fClassName)));
        String visibility = JdtFlags.getVisibilityString(this.fVisibility);
        if (visibility.length() == 0) {
            visibility = RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_default_visibility;
        }
        comment.addSetting(Messages.format(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_visibility_pattern, visibility));
        if (this.fDeclareFinal && this.fDeclareStatic) {
            comment.addSetting(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_declare_final_static);
        } else if (this.fDeclareFinal) {
            comment.addSetting(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_declare_final);
        } else if (this.fDeclareStatic) {
            comment.addSetting(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_declare_static);
        }
        arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(projectName, (IJavaElement)this.fCu));
        arguments.put("name", this.fClassName);
        arguments.put("selection", String.valueOf(Integer.toString(this.fSelectionStart)) + ' ' + Integer.toString(this.fSelectionLength));
        arguments.put(ATTRIBUTE_FINAL, Boolean.toString(this.fDeclareFinal));
        arguments.put(ATTRIBUTE_STATIC, Boolean.toString(this.fDeclareStatic));
        arguments.put(ATTRIBUTE_VISIBILITY, Integer.toString(this.fVisibility));
        ConvertAnonymousDescriptor descriptor = RefactoringSignatureDescriptorFactory.createConvertAnonymousDescriptor(projectName, description, comment.asString(), arguments, 786434);
        return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
    }

    private void modifyConstructorCall(CompilationUnitRewrite rewrite, ITypeBinding[] parameters) {
        rewrite.getASTRewrite().replace(this.fAnonymousInnerClassNode.getParent(), this.createNewClassInstanceCreation(rewrite, parameters), null);
    }

    private ASTNode createNewClassInstanceCreation(CompilationUnitRewrite rewrite, ITypeBinding[] parameters) {
        String name;
        AST ast = this.fAnonymousInnerClassNode.getAST();
        ClassInstanceCreation newClassCreation = ast.newClassInstanceCreation();
        newClassCreation.setAnonymousClassDeclaration(null);
        SimpleType type = null;
        SimpleName newNameNode = ast.newSimpleName(this.fClassName);
        if (parameters.length > 0) {
            ParameterizedType parameterized = ast.newParameterizedType((Type)ast.newSimpleType((Name)newNameNode));
            ITypeBinding[] iTypeBindingArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding parameter = iTypeBindingArray[n2];
                parameterized.typeArguments().add(ast.newSimpleType((Name)ast.newSimpleName(parameter.getName())));
                ++n2;
            }
            type = parameterized;
        } else {
            type = ast.newSimpleType((Name)newNameNode);
        }
        newClassCreation.setType((Type)type);
        this.copyArguments(rewrite, newClassCreation);
        this.addArgumentsForLocalsUsedInInnerClass(newClassCreation);
        this.addLinkedPosition(KEY_TYPE_NAME, (ASTNode)newNameNode, rewrite.getASTRewrite(), true);
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)this.fAnonymousInnerClassNode.getParent();
        if (classInstanceCreation.getExpression() instanceof SimpleName && (name = ((SimpleName)classInstanceCreation.getExpression()).getIdentifier()) != null && !name.isEmpty()) {
            newClassCreation.setExpression((Expression)ast.newSimpleName(name));
        }
        return newClassCreation;
    }

    private void addArgumentsForLocalsUsedInInnerClass(ClassInstanceCreation newClassCreation) {
        IVariableBinding[] iVariableBindingArray = this.getUsedLocalVariables();
        int n = iVariableBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableBinding binding = iVariableBindingArray[n2];
            AST ast = this.fAnonymousInnerClassNode.getAST();
            Object name = null;
            name = binding.isEnumConstant() ? ast.newQualifiedName((Name)ast.newSimpleName(binding.getDeclaringClass().getName()), ast.newSimpleName(binding.getName())) : ast.newSimpleName(binding.getName());
            newClassCreation.arguments().add(name);
            ++n2;
        }
    }

    private void copyArguments(CompilationUnitRewrite rewrite, ClassInstanceCreation newClassCreation) {
        Iterator iter = ((ClassInstanceCreation)this.fAnonymousInnerClassNode.getParent()).arguments().iterator();
        if (!iter.hasNext()) {
            return;
        }
        IMethodBinding superConstructorBinding = this.getSuperConstructorBinding();
        ITypeBinding[] parameterTypes = superConstructorBinding.getParameterTypes();
        List arguments = newClassCreation.arguments();
        ASTRewrite astRewrite = rewrite.getASTRewrite();
        int last = parameterTypes.length - 1;
        int i = 0;
        while (i < last) {
            arguments.add((Expression)astRewrite.createCopyTarget((ASTNode)iter.next()));
            ++i;
        }
        if (superConstructorBinding.isVarargs()) {
            AST ast = astRewrite.getAST();
            ArrayCreation arrayCreation = ast.newArrayCreation();
            arrayCreation.setType((ArrayType)rewrite.getImportRewrite().addImport(parameterTypes[last], ast));
            ArrayInitializer initializer = ast.newArrayInitializer();
            arrayCreation.setInitializer(initializer);
            arguments.add(arrayCreation);
            arguments = initializer.expressions();
        }
        while (iter.hasNext()) {
            arguments.add((Expression)astRewrite.createCopyTarget((ASTNode)iter.next()));
        }
    }

    private void addNestedClass(CompilationUnitRewrite rewrite, ITypeBinding[] typeParameters) throws CoreException {
        AbstractTypeDeclaration declarations = ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, AbstractTypeDeclaration.class);
        int index = ConvertAnonymousToNestedRefactoring.findIndexOfFistNestedClass(declarations.bodyDeclarations());
        if (index == -1) {
            index = 0;
        }
        rewrite.getASTRewrite().getListRewrite((ASTNode)declarations, declarations.getBodyDeclarationsProperty()).insertAt((ASTNode)this.createNewNestedClass(rewrite, typeParameters), index, null);
    }

    private static int findIndexOfFistNestedClass(List<BodyDeclaration> list) {
        int i = 0;
        int n = list.size();
        while (i < n) {
            BodyDeclaration each = list.get(i);
            if (ConvertAnonymousToNestedRefactoring.isNestedType(each)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean isNestedType(BodyDeclaration each) {
        if (!(each instanceof AbstractTypeDeclaration)) {
            return false;
        }
        return each.getParent() instanceof AbstractTypeDeclaration;
    }

    private AbstractTypeDeclaration createNewNestedClass(CompilationUnitRewrite rewrite, ITypeBinding[] typeParameters) throws CoreException {
        AST ast = this.fAnonymousInnerClassNode.getAST();
        TypeDeclaration newDeclaration = ast.newTypeDeclaration();
        newDeclaration.setInterface(false);
        newDeclaration.setJavadoc(null);
        newDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(ast, this.createModifiersForNestedClass()));
        newDeclaration.setName(ast.newSimpleName(this.fClassName));
        TypeParameter parameter = null;
        ITypeBinding[] iTypeBindingArray = typeParameters;
        int n = typeParameters.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding typeParameter = iTypeBindingArray[n2];
            parameter = ast.newTypeParameter();
            parameter.setName(ast.newSimpleName(typeParameter.getName()));
            newDeclaration.typeParameters().add(parameter);
            ++n2;
        }
        this.setSuperType(newDeclaration);
        IJavaProject project = this.fCu.getJavaProject();
        IVariableBinding[] bindings = this.getUsedLocalVariables();
        ArrayList<String> fieldNames = new ArrayList<String>();
        int i = 0;
        while (i < bindings.length) {
            String name = StubUtility.getBaseName(bindings[i], project);
            String[] fieldNameProposals = StubUtility.getVariableNameSuggestions(2, project, name, 0, fieldNames, true);
            fieldNames.add(fieldNameProposals[0]);
            if (this.fLinkedProposalModelCore != null) {
                LinkedProposalPositionGroupCore positionGroup = this.fLinkedProposalModelCore.getPositionGroup(KEY_FIELD_NAME_EXT + i, true);
                int k = 0;
                while (k < fieldNameProposals.length) {
                    positionGroup.addProposal(fieldNameProposals[k], fieldNameProposals.length - k);
                    ++k;
                }
            }
            ++i;
        }
        String[] allFieldNames = fieldNames.toArray(new String[fieldNames.size()]);
        List newBodyDeclarations = newDeclaration.bodyDeclarations();
        this.createFieldsForAccessedLocals(rewrite, bindings, allFieldNames, newBodyDeclarations);
        MethodDeclaration newConstructorDecl = this.createNewConstructor(rewrite, bindings, allFieldNames);
        if (newConstructorDecl != null) {
            newBodyDeclarations.add(newConstructorDecl);
        }
        this.updateAndMoveBodyDeclarations(rewrite, bindings, allFieldNames, newBodyDeclarations, newConstructorDecl);
        if (this.doAddComments()) {
            String[] parameterNames = new String[typeParameters.length];
            int index = 0;
            while (index < parameterNames.length) {
                parameterNames[index] = typeParameters[index].getName();
                ++index;
            }
            String string = CodeGeneration.getTypeComment(rewrite.getCu(), this.fClassName, parameterNames, StubUtility.getLineDelimiterUsed((IJavaElement)this.fCu));
            if (string != null) {
                Javadoc javadoc = (Javadoc)rewrite.getASTRewrite().createStringPlaceholder(string, 29);
                newDeclaration.setJavadoc(javadoc);
            }
        }
        if (this.fLinkedProposalModelCore != null) {
            this.addLinkedPosition(KEY_TYPE_NAME, (ASTNode)newDeclaration.getName(), rewrite.getASTRewrite(), false);
            ModifierCorrectionSubProcessorCore.installLinkedVisibilityProposals(this.fLinkedProposalModelCore, rewrite.getASTRewrite(), newDeclaration.modifiers(), false);
        }
        return newDeclaration;
    }

    private void updateAndMoveBodyDeclarations(CompilationUnitRewrite rewriter, IVariableBinding[] bindings, String[] fieldNames, List<BodyDeclaration> newBodyDeclarations, MethodDeclaration newConstructorDecl) {
        ASTRewrite astRewrite = rewriter.getASTRewrite();
        AST ast = astRewrite.getAST();
        boolean useThisAccess = this.useThisForFieldAccess();
        int fieldInsertIndex = newConstructorDecl != null ? newBodyDeclarations.lastIndexOf(newConstructorDecl) : newBodyDeclarations.size();
        for (BodyDeclaration body : this.fAnonymousInnerClassNode.bodyDeclarations()) {
            int i = 0;
            while (i < bindings.length) {
                String fieldName = fieldNames[i];
                SimpleName[] simpleNameArray = LinkedNodeFinder.findByBinding((ASTNode)body, (IBinding)bindings[i]);
                int n = simpleNameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SimpleName name = simpleNameArray[n2];
                    SimpleName newNode = ast.newSimpleName(fieldName);
                    if (useThisAccess) {
                        FieldAccess access = ast.newFieldAccess();
                        access.setExpression((Expression)ast.newThisExpression());
                        access.setName(newNode);
                        astRewrite.replace((ASTNode)name, (ASTNode)access, null);
                    } else {
                        astRewrite.replace((ASTNode)name, (ASTNode)newNode, null);
                    }
                    this.addLinkedPosition(KEY_FIELD_NAME_EXT + i, (ASTNode)newNode, astRewrite, false);
                    ++n2;
                }
                ++i;
            }
            if (body instanceof Initializer || body instanceof FieldDeclaration) {
                newBodyDeclarations.add(fieldInsertIndex++, (BodyDeclaration)astRewrite.createMoveTarget((ASTNode)body));
                continue;
            }
            newBodyDeclarations.add((BodyDeclaration)astRewrite.createMoveTarget((ASTNode)body));
        }
        if (newConstructorDecl != null) {
            List bodyStatements = newConstructorDecl.getBody().statements();
            for (VariableDeclarationFragment fragment : this.getFieldsToInitializeInConstructor()) {
                Expression initializer = fragment.getInitializer();
                Expression replacement = (Expression)astRewrite.get((ASTNode)fragment, (StructuralPropertyDescriptor)VariableDeclarationFragment.INITIALIZER_PROPERTY);
                if (replacement == initializer) {
                    replacement = (Expression)astRewrite.createMoveTarget((ASTNode)initializer);
                }
                astRewrite.remove((ASTNode)initializer, null);
                SimpleName fieldNameNode = ast.newSimpleName(fragment.getName().getIdentifier());
                bodyStatements.add(this.newFieldAssignment(ast, fieldNameNode, replacement, useThisAccess));
            }
        }
    }

    private void createFieldsForAccessedLocals(CompilationUnitRewrite rewrite, IVariableBinding[] varBindings, String[] fieldNames, List<BodyDeclaration> newBodyDeclarations) throws CoreException {
        ImportRewrite importRewrite = rewrite.getImportRewrite();
        ASTRewrite astRewrite = rewrite.getASTRewrite();
        AST ast = astRewrite.getAST();
        int i = 0;
        while (i < varBindings.length) {
            String string;
            VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
            fragment.setInitializer(null);
            fragment.setName(ast.newSimpleName(fieldNames[i]));
            FieldDeclaration field = ast.newFieldDeclaration(fragment);
            ITypeBinding varType = varBindings[i].getType();
            field.setType(importRewrite.addImport(varType, ast));
            field.modifiers().addAll(ASTNodeFactory.newModifiers(ast, 18));
            if (this.doAddComments() && (string = CodeGeneration.getFieldComment(rewrite.getCu(), varType.getName(), fieldNames[i], StubUtility.getLineDelimiterUsed((IJavaElement)this.fCu))) != null) {
                Javadoc javadoc = (Javadoc)astRewrite.createStringPlaceholder(string, 29);
                field.setJavadoc(javadoc);
            }
            newBodyDeclarations.add((BodyDeclaration)field);
            this.addLinkedPosition(KEY_FIELD_NAME_EXT + i, (ASTNode)fragment.getName(), astRewrite, false);
            ++i;
        }
    }

    private void addLinkedPosition(String key, ASTNode nodeToTrack, ASTRewrite rewrite, boolean isFirst) {
        if (this.fLinkedProposalModelCore != null) {
            this.fLinkedProposalModelCore.getPositionGroup(key, true).addPosition(rewrite.track(nodeToTrack), isFirst);
        }
    }

    private IVariableBinding[] getUsedLocalVariables() {
        HashSet<IBinding> result = new HashSet<IBinding>(0);
        this.collectRefrencedVariables((ASTNode)this.fAnonymousInnerClassNode, result);
        ArrayList<IVariableBinding> usedLocals = new ArrayList<IVariableBinding>();
        for (IBinding iBinding : result) {
            IVariableBinding next = (IVariableBinding)iBinding;
            if (!this.isBindingToTemp(next)) continue;
            usedLocals.add(next);
        }
        return usedLocals.toArray(new IVariableBinding[usedLocals.size()]);
    }

    private void collectRefrencedVariables(ASTNode root, final Set<IBinding> result) {
        root.accept(new ASTVisitor(){

            public boolean visit(SimpleName node) {
                IBinding binding = node.resolveBinding();
                if (binding instanceof IVariableBinding) {
                    result.add(binding);
                }
                return true;
            }
        });
    }

    private boolean isBindingToTemp(IVariableBinding variable) {
        if (variable.isField()) {
            return false;
        }
        if (!Modifier.isFinal((int)variable.getModifiers()) && !JavaModelUtil.is1d8OrHigher(this.fCu.getJavaProject())) {
            return false;
        }
        ASTNode declaringNode = this.fCompilationUnitNode.findDeclaringNode((IBinding)variable);
        if (declaringNode == null) {
            return false;
        }
        return !ASTNodes.isParent(declaringNode, (ASTNode)this.fAnonymousInnerClassNode);
    }

    private MethodDeclaration createNewConstructor(CompilationUnitRewrite rewrite, IVariableBinding[] bindings, String[] fieldNames) throws JavaModelException {
        int k;
        LinkedProposalPositionGroupCore positionGroup;
        IMethodBinding constructorBinding;
        ClassInstanceCreation instanceCreation = (ClassInstanceCreation)this.fAnonymousInnerClassNode.getParent();
        if (instanceCreation.arguments().isEmpty() && bindings.length == 0) {
            return null;
        }
        IJavaProject project = this.fCu.getJavaProject();
        AST ast = rewrite.getAST();
        ImportRewrite importRewrite = rewrite.getImportRewrite();
        ASTRewrite astRewrite = rewrite.getASTRewrite();
        MethodDeclaration newConstructor = ast.newMethodDeclaration();
        newConstructor.setConstructor(true);
        newConstructor.setJavadoc(null);
        newConstructor.modifiers().addAll(ASTNodeFactory.newModifiers(ast, this.fVisibility));
        newConstructor.setName(ast.newSimpleName(this.fClassName));
        this.addLinkedPosition(KEY_TYPE_NAME, (ASTNode)newConstructor.getName(), astRewrite, false);
        newConstructor.setBody(ast.newBlock());
        List newStatements = newConstructor.getBody().statements();
        List newParameters = newConstructor.parameters();
        ArrayList<String> newParameterNames = new ArrayList<String>();
        if (!instanceCreation.arguments().isEmpty() && (constructorBinding = this.getSuperConstructorBinding()) != null) {
            SuperConstructorInvocation superConstructorInvocation = ast.newSuperConstructorInvocation();
            ITypeBinding[] parameterTypes = constructorBinding.getParameterTypes();
            String[][] parameterNames = StubUtility.suggestArgumentNamesWithProposals(project, constructorBinding);
            int i = 0;
            while (i < parameterNames.length) {
                String[] nameProposals = parameterNames[i];
                String paramName = nameProposals[0];
                SingleVariableDeclaration param = this.newParameterDeclaration(ast, importRewrite, paramName, parameterTypes[i]);
                newParameters.add(param);
                newParameterNames.add(paramName);
                SimpleName newSIArgument = ast.newSimpleName(paramName);
                superConstructorInvocation.arguments().add(newSIArgument);
                if (this.fLinkedProposalModelCore != null) {
                    positionGroup = this.fLinkedProposalModelCore.getPositionGroup(KEY_PARAM_NAME_CONST + String.valueOf(i), true);
                    positionGroup.addPosition(astRewrite.track((ASTNode)param.getName()), false);
                    positionGroup.addPosition(astRewrite.track((ASTNode)newSIArgument), false);
                    k = 0;
                    while (k < nameProposals.length) {
                        positionGroup.addProposal(nameProposals[k], nameProposals.length - k);
                        ++k;
                    }
                }
                ++i;
            }
            newStatements.add(superConstructorInvocation);
        }
        boolean useThisAccess = this.useThisForFieldAccess();
        int i = 0;
        while (i < bindings.length) {
            String baseName = StubUtility.getBaseName(bindings[i], project);
            String[] paramNameProposals = StubUtility.getVariableNameSuggestions(4, project, baseName, 0, newParameterNames, true);
            String paramName = paramNameProposals[0];
            SingleVariableDeclaration param = this.newParameterDeclaration(ast, importRewrite, paramName, bindings[i].getType());
            newParameters.add(param);
            newParameterNames.add(paramName);
            String fieldName = fieldNames[i];
            SimpleName fieldNameNode = ast.newSimpleName(fieldName);
            SimpleName paramNameNode = ast.newSimpleName(paramName);
            newStatements.add(this.newFieldAssignment(ast, fieldNameNode, (Expression)paramNameNode, useThisAccess || newParameterNames.contains(fieldName)));
            if (this.fLinkedProposalModelCore != null) {
                positionGroup = this.fLinkedProposalModelCore.getPositionGroup(KEY_PARAM_NAME_EXT + String.valueOf(i), true);
                positionGroup.addPosition(astRewrite.track((ASTNode)param.getName()), false);
                positionGroup.addPosition(astRewrite.track((ASTNode)paramNameNode), false);
                k = 0;
                while (k < paramNameProposals.length) {
                    positionGroup.addProposal(paramNameProposals[k], paramNameProposals.length - k);
                    ++k;
                }
                this.fLinkedProposalModelCore.getPositionGroup(KEY_FIELD_NAME_EXT + i, true).addPosition(astRewrite.track((ASTNode)fieldNameNode), false);
            }
            ++i;
        }
        this.addExceptionsToNewConstructor(newConstructor, importRewrite);
        if (this.doAddComments()) {
            try {
                String[] allParamNames = newParameterNames.toArray(new String[newParameterNames.size()]);
                String string = CodeGeneration.getMethodComment(this.fCu, this.fClassName, this.fClassName, allParamNames, new String[0], null, new String[0], null, StubUtility.getLineDelimiterUsed((IJavaElement)this.fCu));
                if (string != null) {
                    Javadoc javadoc = (Javadoc)astRewrite.createStringPlaceholder(string, 29);
                    newConstructor.setJavadoc(javadoc);
                }
            }
            catch (CoreException exception) {
                throw new JavaModelException(exception);
            }
        }
        return newConstructor;
    }

    private Statement newFieldAssignment(AST ast, SimpleName fieldNameNode, Expression initializer, boolean useThisAccess) {
        Assignment assignment = ast.newAssignment();
        if (useThisAccess) {
            FieldAccess access = ast.newFieldAccess();
            access.setExpression((Expression)ast.newThisExpression());
            access.setName(fieldNameNode);
            assignment.setLeftHandSide((Expression)access);
        } else {
            assignment.setLeftHandSide((Expression)fieldNameNode);
        }
        assignment.setOperator(Assignment.Operator.ASSIGN);
        assignment.setRightHandSide(initializer);
        return ast.newExpressionStatement((Expression)assignment);
    }

    private List<VariableDeclarationFragment> getFieldsToInitializeInConstructor() {
        ArrayList<VariableDeclarationFragment> result = new ArrayList<VariableDeclarationFragment>(0);
        for (Object element : this.fAnonymousInnerClassNode.bodyDeclarations()) {
            if (!(element instanceof FieldDeclaration)) continue;
            List fragments = ((FieldDeclaration)element).fragments();
            for (VariableDeclarationFragment fragment : fragments) {
                if (!this.isToBeInitializerInConstructor(fragment, result)) continue;
                result.add(fragment);
            }
        }
        return result;
    }

    private boolean isToBeInitializerInConstructor(VariableDeclarationFragment fragment, List<VariableDeclarationFragment> fieldsToInitialize) {
        return fragment.getInitializer() != null && this.areLocalsUsedIn(fragment.getInitializer(), fieldsToInitialize);
    }

    private boolean areLocalsUsedIn(Expression fieldInitializer, List<VariableDeclarationFragment> fieldsToInitialize) {
        HashSet<IBinding> localsUsed = new HashSet<IBinding>(0);
        this.collectRefrencedVariables((ASTNode)fieldInitializer, localsUsed);
        ITypeBinding anonType = this.fAnonymousInnerClassNode.resolveBinding();
        for (IBinding iBinding : localsUsed) {
            IVariableBinding curr = (IVariableBinding)iBinding;
            if (!this.isBindingToTemp(curr) && (!curr.isField() || curr.getDeclaringClass() != anonType || !fieldsToInitialize.contains(this.fCompilationUnitNode.findDeclaringNode((IBinding)curr)))) continue;
            return true;
        }
        return false;
    }

    private IMethodBinding getSuperConstructorBinding() {
        IMethodBinding anonConstr = ((ClassInstanceCreation)this.fAnonymousInnerClassNode.getParent()).resolveConstructorBinding();
        if (anonConstr == null) {
            return null;
        }
        ITypeBinding superClass = anonConstr.getDeclaringClass().getSuperclass();
        IMethodBinding[] iMethodBindingArray = superClass.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding superMethod = iMethodBindingArray[n2];
            if (superMethod.isConstructor() && ConvertAnonymousToNestedRefactoring.parameterTypesMatch(superMethod, anonConstr)) {
                return superMethod;
            }
            ++n2;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private static boolean parameterTypesMatch(IMethodBinding m1, IMethodBinding m2) {
        ITypeBinding[] m2Params;
        ITypeBinding[] m1Params = m1.getParameterTypes();
        if (m1Params.length != (m2Params = m2.getParameterTypes()).length) {
            return false;
        }
        int i = 0;
        while (i < m2Params.length) {
            if (!m1Params[i].equals((Object)m2Params[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void addExceptionsToNewConstructor(MethodDeclaration newConstructor, ImportRewrite importRewrite) {
        IMethodBinding constructorBinding = this.getSuperConstructorBinding();
        if (constructorBinding == null) {
            return;
        }
        ITypeBinding[] iTypeBindingArray = constructorBinding.getExceptionTypes();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding exception = iTypeBindingArray[n2];
            Type exceptionType = importRewrite.addImport(exception, this.fAnonymousInnerClassNode.getAST());
            newConstructor.thrownExceptionTypes().add(exceptionType);
            ++n2;
        }
    }

    private SingleVariableDeclaration newParameterDeclaration(AST ast, ImportRewrite importRewrite, String paramName, ITypeBinding paramType) {
        SingleVariableDeclaration param = ast.newSingleVariableDeclaration();
        param.setType(importRewrite.addImport(paramType, ast));
        param.setName(ast.newSimpleName(paramName));
        return param;
    }

    private void setSuperType(TypeDeclaration declaration) {
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)this.fAnonymousInnerClassNode.getParent();
        ITypeBinding binding = classInstanceCreation.resolveTypeBinding();
        if (binding == null) {
            return;
        }
        Type newType = (Type)ASTNode.copySubtree((AST)this.fAnonymousInnerClassNode.getAST(), (ASTNode)classInstanceCreation.getType());
        if ("java.lang.Object".equals(binding.getSuperclass().getQualifiedName())) {
            Assert.isTrue((binding.getInterfaces().length <= 1 ? 1 : 0) != 0);
            if (binding.getInterfaces().length == 0) {
                return;
            }
            declaration.superInterfaceTypes().add(0, newType);
        } else {
            declaration.setSuperclassType(newType);
        }
    }

    private ITypeBinding getSuperTypeBinding() {
        ITypeBinding types = this.fAnonymousInnerClassNode.resolveBinding();
        ITypeBinding[] interfaces = types.getInterfaces();
        if (interfaces.length > 0) {
            return interfaces[0];
        }
        return types.getSuperclass();
    }

    private int createModifiersForNestedClass() {
        int flags = this.fVisibility;
        if (this.fDeclareFinal) {
            flags |= 0x10;
        }
        if (this.mustInnerClassBeStatic() || this.fDeclareStatic) {
            flags |= 8;
        }
        return flags;
    }

    public boolean mustInnerClassBeStatic() {
        ITypeBinding typeBinding = ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, AbstractTypeDeclaration.class).resolveBinding();
        ASTNode current = this.fAnonymousInnerClassNode.getParent();
        boolean ans = false;
        while (current != null) {
            switch (current.getNodeType()) {
                case 17: 
                case 46: {
                    return true;
                }
                case 1: {
                    AnonymousClassDeclaration enclosingAnonymousClassDeclaration = (AnonymousClassDeclaration)current;
                    ITypeBinding binding = enclosingAnonymousClassDeclaration.resolveBinding();
                    if (binding == null || !Bindings.isSuperType(typeBinding, binding.getSuperclass())) break;
                    return false;
                }
                case 23: {
                    FieldDeclaration enclosingFieldDeclaration = (FieldDeclaration)current;
                    if (!Modifier.isStatic((int)enclosingFieldDeclaration.getModifiers())) break;
                    ans = true;
                    break;
                }
                case 31: {
                    MethodDeclaration enclosingMethodDeclaration = (MethodDeclaration)current;
                    if (!Modifier.isStatic((int)enclosingMethodDeclaration.getModifiers())) break;
                    ans = true;
                    break;
                }
                case 55: {
                    return ans;
                }
                case 14: {
                    if (((ClassInstanceCreation)current).getExpression() == null) break;
                    return false;
                }
            }
            current = current.getParent();
        }
        return ans;
    }

    private RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        int length;
        int offset;
        String selection;
        IJavaElement element;
        this.fSelfInitializing = true;
        String handle = arguments.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 5) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.convert.anonymous");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.fCu = (ICompilationUnit)element;
        String name = arguments.getAttribute("name");
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        this.fClassName = name;
        String visibility = arguments.getAttribute(ATTRIBUTE_VISIBILITY);
        if (visibility != null && !"".equals(visibility)) {
            int flag = 0;
            try {
                flag = Integer.parseInt(visibility);
            }
            catch (NumberFormatException numberFormatException) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_VISIBILITY));
            }
            this.fVisibility = flag;
        }
        if ((selection = arguments.getAttribute("selection")) != null) {
            offset = -1;
            length = -1;
            StringTokenizer tokenizer = new StringTokenizer(selection);
            if (tokenizer.hasMoreTokens()) {
                offset = Integer.parseInt(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                length = Integer.parseInt(tokenizer.nextToken());
            }
            if (offset < 0 || length < 0) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
        }
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
        String declareStatic = arguments.getAttribute(ATTRIBUTE_STATIC);
        if (declareStatic == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_STATIC));
        }
        this.fDeclareStatic = Boolean.parseBoolean(declareStatic);
        String declareFinal = arguments.getAttribute(ATTRIBUTE_FINAL);
        if (declareFinal == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_FINAL));
        }
        this.fDeclareFinal = Boolean.parseBoolean(declareFinal);
        return new RefactoringStatus();
    }

    public static class TypeVariableFinder
    extends ASTVisitor {
        private final Map<String, ITypeBinding> fBindings = new HashMap<String, ITypeBinding>();
        private final List<ITypeBinding> fFound = new ArrayList<ITypeBinding>();

        public final boolean visit(SimpleName node) {
            Assert.isNotNull((Object)node);
            ITypeBinding binding = node.resolveTypeBinding();
            if (binding != null && binding.isTypeVariable() && !this.fBindings.containsKey(binding.getKey())) {
                this.fBindings.put(binding.getKey(), binding);
                this.fFound.add(binding);
            }
            return true;
        }

        public final boolean visit(TypeParameter parameter) {
            ITypeBinding binding = parameter.resolveBinding();
            if (binding != null) {
                this.fBindings.put(binding.getKey(), binding);
            }
            return false;
        }

        public final ITypeBinding[] getResult() {
            ITypeBinding[] result = new ITypeBinding[this.fFound.size()];
            this.fFound.toArray(result);
            return result;
        }
    }
}

