/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.k3.ui.wizards;

import fr.inria.diverse.k3.ui.Activator;
import fr.inria.diverse.k3.ui.tools.K3FileTemplates;
import fr.inria.diverse.k3.ui.tools.K3SampleFilesTemplates;
import fr.inria.diverse.k3.ui.tools.classpath.ManageClasspath;
import fr.inria.diverse.k3.ui.tools.classpath.ManageClasspathMaven;
import fr.inria.diverse.k3.ui.tools.classpath.ManageClasspathPlugin;
import fr.inria.diverse.k3.ui.tools.classpath.ManageClasspathStandAlone;
import fr.inria.diverse.k3.ui.wizards.pages.NewK3ProjectWizardFields;
import fr.inria.diverse.k3.ui.wizards.pages.NewK3ProjectWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.gemoc.commons.eclipse.core.resources.IFileUtils;
import org.eclipse.gemoc.commons.eclipse.core.resources.IFolderUtils;
import org.eclipse.gemoc.commons.eclipse.core.resources.ProjectDescriptor;
import org.eclipse.gemoc.commons.eclipse.pde.java.JavaNameHelper;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChanger;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.AbstractNewProjectWizardWithTemplates;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.BaseProjectWizardFields;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.IProjectContentWizard;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.ProjectTemplateApplicationOperation;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewK3ProjectWizard
extends AbstractNewProjectWizardWithTemplates
implements INewWizard {
    protected NewK3ProjectWizardFields context = new NewK3ProjectWizardFields();
    protected NewK3ProjectWizardPage projectPage;

    public void addPages() {
        this.projectPage = new NewK3ProjectWizardPage(this.context);
        this.addPage((IWizardPage)this.projectPage);
        this.addPage((IWizardPage)this.getTemplateListSelectionPage(this.context));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            final IProjectDescription description = workspace.newProjectDescription(this.context.projectName);
            if (!this.context.projectLocation.equals(workspace.getRoot().getLocation().toOSString())) {
                description.setLocation((IPath)new Path(this.context.projectLocation));
            }
            final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.context.projectName);
            IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    project.create(description, monitor);
                    project.open(monitor);
                    NewK3ProjectWizard.this.addKermetaNatureToProject(project);
                    NewK3ProjectWizard.this.configureProject(project, monitor);
                    IProjectContentWizard contentWizard = NewK3ProjectWizard.this.templateSelectionPage.getSelectedWizard();
                    try {
                        NewK3ProjectWizard.this.getContainer().run(false, true, (IRunnableWithProgress)new ProjectTemplateApplicationOperation((BaseProjectWizardFields)NewK3ProjectWizard.this.context, project, contentWizard));
                    }
                    catch (InvocationTargetException e) {
                        Activator.logErrorMessage(e.getMessage(), e);
                    }
                    catch (InterruptedException e) {
                        Activator.logErrorMessage(e.getMessage(), e);
                    }
                    project.refreshLocal(2, monitor);
                }
            };
            ResourcesPlugin.getWorkspace().run(operation, null);
        }
        catch (Exception exception) {
            Activator.logErrorMessage(exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    public boolean isHelpAvailable() {
        return true;
    }

    public void addKermetaNatureToProject(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            if (!description.hasNature("fr.inria.diverse.k3.ui.k3Nature")) {
                NewK3ProjectWizard.addNature(description, "fr.inria.diverse.k3.ui.k3Nature");
            }
            if (!description.hasNature("org.eclipse.jdt.core.javanature")) {
                NewK3ProjectWizard.addNature(description, "org.eclipse.jdt.core.javanature");
            }
            if (!description.hasNature("org.eclipse.xtext.ui.shared.xtextNature")) {
                NewK3ProjectWizard.addNature(description, "org.eclipse.xtext.ui.shared.xtextNature");
            }
            if (this.context.kindsOfProject == NewK3ProjectWizardFields.KindsOfProject.PLUGIN && !description.hasNature("org.eclipse.pde.PluginNature")) {
                NewK3ProjectWizard.addNature(description, "org.eclipse.pde.PluginNature");
            }
            if (this.context.kindsOfProject == NewK3ProjectWizardFields.KindsOfProject.MAVEN && !description.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                NewK3ProjectWizard.addNature(description, "org.eclipse.m2e.core.maven2Nature");
            }
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            Activator.logErrorMessage(e.getMessage(), e);
        }
    }

    public void configureProject(IProject project, IProgressMonitor monitor) {
        try {
            String sourceFolderName;
            IProjectDescription description = project.getDescription();
            NewK3ProjectWizard.addNature(description, "fr.inria.diverse.k3.ui.k3Nature");
            NewK3ProjectWizard.addNature(description, "org.eclipse.jdt.core.javanature");
            NewK3ProjectWizard.addNature(description, "org.eclipse.xtext.ui.shared.xtextNature");
            switch (this.context.kindsOfProject) {
                case MAVEN: {
                    sourceFolderName = "src/main/java/";
                    break;
                }
                default: {
                    sourceFolderName = "src/";
                }
            }
            this.createSettingsResourcePrefs(project, monitor);
            IFolderUtils.createFolder((String)(String.valueOf(sourceFolderName) + this.getContextNamePackage().replaceAll("\\.", "/")), (IProject)project, (IProgressMonitor)monitor);
            switch (this.context.kindsOfProject) {
                case STANDALONE: {
                    IFileUtils.unZip((IProject)project, (ProjectDescriptor)new ProjectDescriptor("fr.inria.diverse.k3.ui", "zips/k3.zip"));
                    IFileUtils.unZip((IProject)project, (ProjectDescriptor)new ProjectDescriptor("fr.inria.diverse.k3.ui", "zips/xtend.zip"));
                    if (this.context.useEMF) {
                        IFileUtils.unZip((IProject)project, (ProjectDescriptor)new ProjectDescriptor("fr.inria.diverse.k3.ui", "zips/emf.zip"));
                    }
                    ManageClasspathStandAlone classpath = new ManageClasspathStandAlone("lib");
                    ((ManageClasspath)classpath).setClasspath(project, monitor);
                    break;
                }
                case PLUGIN: {
                    ManageClasspathPlugin classpath = new ManageClasspathPlugin(this.context.useSLE);
                    NewK3ProjectWizard.addNature(description, "org.eclipse.pde.PluginNature");
                    this.configurePluginProject(project, monitor);
                    ((ManageClasspath)classpath).setClasspath(project, monitor);
                    if (!this.context.useSLE) break;
                    ((ManageClasspath)classpath).setClasspath(project, monitor);
                    break;
                }
                case MAVEN: {
                    ManageClasspathMaven classpath = new ManageClasspathMaven();
                    NewK3ProjectWizard.addNature(description, "org.eclipse.m2e.core.maven2Nature");
                    this.createMavenFile(project, monitor, false);
                    ((ManageClasspath)classpath).setClasspath(project, monitor);
                }
            }
            project.setDescription(description, monitor);
        }
        catch (Exception e) {
            Activator.logErrorMessage(e.getMessage(), e);
        }
    }

    private void configurePluginProject(IProject project, IProgressMonitor monitor) {
        try {
            this.createManifestFile(project, monitor);
            ManifestChanger manifestChanger = new ManifestChanger(project.getFile("META-INF/MANIFEST.MF"));
            manifestChanger.addPluginDependency("org.eclipse.xtend.lib", "2.6.0", false, true);
            manifestChanger.addPluginDependency("org.eclipse.xtext.xbase.lib", "2.6.0", false, true);
            manifestChanger.addPluginDependency("com.google.guava", "0.0.0", false, true);
            if (this.context.useEMF) {
                manifestChanger.addPluginDependency("org.eclipse.emf.ecore.xmi", "2.8.0", true, true);
                manifestChanger.addPluginDependency("org.eclipse.emf.ecore", "2.8.0", true, true);
                manifestChanger.addPluginDependency("org.eclipse.emf.common", "2.8.0", true, true);
                if (this.context.ecoreIFile != null) {
                    manifestChanger.addPluginDependency(this.context.ecoreIFile.getProject().getName(), "0.0.0", true, true);
                }
                if (this.context.useSLE) {
                    manifestChanger.addPluginDependency("fr.inria.diverse.k3.sle.lib", "3.0.0", true, true);
                }
            }
            manifestChanger.commit();
            this.createPlugInFile(project, monitor);
            this.createBuildProperties(project, monitor);
        }
        catch (Exception e) {
            Activator.logErrorMessage(e.getMessage(), e);
        }
    }

    public static void addNature(IProjectDescription description, String nature) {
        String[] natures = description.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = nature;
        description.setNatureIds(newNatures);
    }

    private void createManifestFile(IProject project, IProgressMonitor monitor) throws Exception {
        IFolder metaInf = project.getFolder("META-INF");
        metaInf.create(false, true, monitor);
        String path = "META-INF/MANIFEST.MF";
        IProject currentContainer = project;
        IFile file = currentContainer.getFile((IPath)new Path(path));
        String contents = K3FileTemplates.manifestMFPlugin(this.context.projectName, new ArrayList<String>(), new ArrayList<String>());
        IFileUtils.writeInFile((IFile)file, (String)contents, (IProgressMonitor)monitor);
    }

    private void createBuildProperties(IProject project, IProgressMonitor monitor) throws Exception {
        String path = "build.properties";
        IProject currentContainer = project;
        IFile file = currentContainer.getFile((IPath)new Path(path));
        String contents = K3SampleFilesTemplates.buildProperties();
        IFileUtils.writeInFile((IFile)file, (String)contents, (IProgressMonitor)monitor);
    }

    private void createSettingsResourcePrefs(IProject project, IProgressMonitor monitor) throws Exception {
        IFolder settings = project.getFolder(".settings");
        settings.create(false, true, monitor);
        String path = ".settings/org.eclipse.core.resources.prefs";
        IProject currentContainer = project;
        IFile file = currentContainer.getFile((IPath)new Path(path));
        String contents = K3SampleFilesTemplates.eclipseResourcePrefs();
        IFileUtils.writeInFile((IFile)file, (String)contents, (IProgressMonitor)monitor);
    }

    private void createPlugInFile(IProject project, IProgressMonitor monitor) throws Exception {
        String path = "/plugin.xml";
        IProject currentContainer = project;
        IFile file = currentContainer.getFile((IPath)new Path(path));
        String contents = K3FileTemplates.pluginbasisXML();
        IFileUtils.writeInFile((IFile)file, (String)contents, (IProgressMonitor)monitor);
    }

    private void createMavenFile(IProject project, IProgressMonitor monitor, Boolean bEcoreProject) throws Exception {
        String path = "/pom.xml";
        IProject currentContainer = project;
        IFile file = currentContainer.getFile((IPath)new Path(path));
        String contents = "";
        contents = !bEcoreProject.booleanValue() ? (this.context.ecoreIFile != null ? K3SampleFilesTemplates.pomXmlK3Ecore(this.context.projectName, "GroupID", "ArtifactID", "0.0.1-SNAPSHOT", String.valueOf(this.context.ecoreIFile.getName()) + ".metamodel", String.valueOf(this.context.ecoreIFile.getName()) + ".metamodel", "0.0.1-SNAPSHOT") : K3SampleFilesTemplates.pomXmlK3(this.context.projectName, "GroupID", "ArtifactID", "0.0.1-SNAPSHOT")) : K3SampleFilesTemplates.pomXmlMetamodel(String.valueOf(this.context.ecoreIFile.getName()) + ".metamodel", String.valueOf(this.context.ecoreIFile.getName()) + ".metamodel", String.valueOf(this.context.ecoreIFile.getName()) + ".metamodel", "0.0.1-SNAPSHOT");
        IFileUtils.writeInFile((IFile)file, (String)contents, (IProgressMonitor)monitor);
    }

    public NewK3ProjectWizardFields getContext() {
        return this.context;
    }

    public void addNatureToProject(IProject project, Boolean[] tabNature) {
        try {
            IProjectDescription description = project.getDescription();
            if (!tabNature[0].booleanValue() && !description.hasNature("fr.inria.diverse.k3.ui.k3Nature")) {
                NewK3ProjectWizard.addNature(description, "fr.inria.diverse.k3.ui.k3Nature");
            }
            if (!tabNature[1].booleanValue() && !description.hasNature("org.eclipse.jdt.core.javanature")) {
                NewK3ProjectWizard.addNature(description, "org.eclipse.jdt.core.javanature");
            }
            if (!tabNature[2].booleanValue() && !description.hasNature("org.eclipse.xtext.ui.shared.xtextNature")) {
                NewK3ProjectWizard.addNature(description, "org.eclipse.xtext.ui.shared.xtextNature");
            }
            if (!tabNature[3].booleanValue() && !description.hasNature("org.eclipse.pde.PluginNature")) {
                NewK3ProjectWizard.addNature(description, "org.eclipse.pde.PluginNature");
            }
            if (!tabNature[4].booleanValue() && !description.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                NewK3ProjectWizard.addNature(description, "org.eclipse.m2e.core.maven2Nature");
            }
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            Activator.logErrorMessage(e.getMessage(), e);
        }
    }

    private String getContextNamePackage() {
        if (this.context.namePackage == null || this.context.namePackage.isEmpty()) {
            return JavaNameHelper.getFormattedPackageName((String)this.context.projectName);
        }
        return this.context.namePackage;
    }

    public NewK3ProjectWizardPage getPageProject() {
        return this.projectPage;
    }

    public String getTargetPluginId() {
        return "fr.inria.diverse.k3.ui";
    }
}

