/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.SubmoduleSyncCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.core.TeamException;

public class SubmoduleSyncOperation
implements IEGitOperation {
    private final Repository repository;
    private final Collection<String> paths;

    public SubmoduleSyncOperation(Repository repository) {
        this.repository = repository;
        this.paths = new ArrayList<String>();
    }

    public SubmoduleSyncOperation addPath(String path) {
        this.paths.add(path);
        return this;
    }

    @Override
    public void execute(IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                Map updates = null;
                try {
                    try {
                        SubmoduleSyncCommand sync = Git.wrap((Repository)SubmoduleSyncOperation.this.repository).submoduleSync();
                        for (String path : SubmoduleSyncOperation.this.paths) {
                            sync.addPath(path);
                        }
                        updates = sync.call();
                    }
                    catch (GitAPIException e) {
                        throw new TeamException(e.getLocalizedMessage(), e.getCause());
                    }
                }
                finally {
                    if (updates != null && !updates.isEmpty()) {
                        SubmoduleSyncOperation.this.repository.notifyIndexChanged();
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, monitor);
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return null;
    }
}

