/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.compaction;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import org.eclipse.elk.alg.layered.ILayoutProcessor;
import org.eclipse.elk.alg.layered.compaction.oned.CNode;
import org.eclipse.elk.alg.layered.compaction.oned.ISpacingsHandler;
import org.eclipse.elk.alg.layered.compaction.oned.OneDimensionalCompactor;
import org.eclipse.elk.alg.layered.compaction.oned.algs.ICompactionAlgorithm;
import org.eclipse.elk.alg.layered.compaction.oned.algs.IConstraintCalculationAlgorithm;
import org.eclipse.elk.alg.layered.compaction.oned.algs.ScanlineConstraintCalculator;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.intermediate.compaction.CLEdge;
import org.eclipse.elk.alg.layered.intermediate.compaction.CLNode;
import org.eclipse.elk.alg.layered.intermediate.compaction.ConstraintCalculationStrategy;
import org.eclipse.elk.alg.layered.intermediate.compaction.GraphCompactionStrategy;
import org.eclipse.elk.alg.layered.intermediate.compaction.LGraphToCGraphTransformer;
import org.eclipse.elk.alg.layered.intermediate.compaction.NetworkSimplexCompaction;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.alg.layered.properties.Spacings;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.Pair;

public class HorizontalGraphCompactor
implements ILayoutProcessor {
    public static final ICompactionAlgorithm NETWORK_SIMPLEX_COMPACTION = new NetworkSimplexCompaction();
    private static final IConstraintCalculationAlgorithm EDGE_AWARE_SCANLINE_CONSTRAINTS = new EdgeAwareScanlineConstraintCalculation();
    private LGraph lGraph;
    private final ISpacingsHandler<CNode> specialSpacingsHandler = new ISpacingsHandler<CNode>(){

        @Override
        public double getHorizontalSpacing(CNode cNode1, CNode cNode2) {
            if (this.isVerticalSegmentsOfSameEdge(cNode1, cNode2)) {
                return 0.0;
            }
            LNode node1 = null;
            if (cNode1 instanceof CLNode) {
                node1 = ((CLNode)cNode1).getlNode();
            }
            LNode node2 = null;
            if (cNode2 instanceof CLNode) {
                node2 = ((CLNode)cNode2).getlNode();
            }
            if (node1 != null && node1.getType() == LNode.NodeType.EXTERNAL_PORT || node2 != null && node2.getType() == LNode.NodeType.EXTERNAL_PORT) {
                return 0.0;
            }
            Spacings spacings = (Spacings)HorizontalGraphCompactor.this.lGraph.getProperty(InternalProperties.SPACINGS);
            return spacings.getHorizontalSpacing(node1 != null ? node1.getType() : LNode.NodeType.LONG_EDGE, node2 != null ? node2.getType() : LNode.NodeType.LONG_EDGE);
        }

        @Override
        public double getVerticalSpacing(CNode cNode1, CNode cNode2) {
            if (this.isVerticalSegmentsOfSameEdge(cNode1, cNode2)) {
                return 1.0;
            }
            return Math.min(cNode1.getVerticalSpacing(), cNode2.getVerticalSpacing());
        }

        private boolean isVerticalSegmentsOfSameEdge(CNode cNode1, CNode cNode2) {
            return cNode1 instanceof CLEdge && cNode2 instanceof CLEdge && !Sets.intersection(((CLEdge)cNode1).originalLEdges, ((CLEdge)cNode2).originalLEdges).isEmpty();
        }
    };

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor progressMonitor) {
        GraphCompactionStrategy strategy = (GraphCompactionStrategy)((Object)layeredGraph.getProperty(LayeredOptions.COMPACTION_POST_COMPACTION_STRATEGY));
        if (strategy == GraphCompactionStrategy.NONE) {
            return;
        }
        progressMonitor.begin("Horizontal Compaction", 1.0f);
        this.lGraph = layeredGraph;
        LGraphToCGraphTransformer transformer = new LGraphToCGraphTransformer();
        OneDimensionalCompactor odc = new OneDimensionalCompactor(transformer.transform(layeredGraph));
        odc.setSpacingsHandler(this.specialSpacingsHandler);
        switch ((ConstraintCalculationStrategy)((Object)layeredGraph.getProperty(LayeredOptions.COMPACTION_POST_COMPACTION_CONSTRAINTS))) {
            case SCANLINE: {
                odc.setConstraintAlgorithm(EDGE_AWARE_SCANLINE_CONSTRAINTS);
                break;
            }
            default: {
                odc.setConstraintAlgorithm(OneDimensionalCompactor.QUADRATIC_CONSTRAINTS);
            }
        }
        switch (strategy) {
            case LEFT: {
                odc.compact();
                break;
            }
            case RIGHT: {
                odc.changeDirection(Direction.RIGHT).compact();
                break;
            }
            case LEFT_RIGHT_CONSTRAINT_LOCKING: {
                odc.compact().changeDirection(Direction.RIGHT).applyLockingStrategy().compact();
                break;
            }
            case LEFT_RIGHT_CONNECTION_LOCKING: {
                odc.compact().changeDirection(Direction.RIGHT).setLockingStrategy((Function<Pair<CNode, Direction>, Boolean>)((Function)pair -> !((CNode)pair.getFirst()).lock.get((Direction)pair.getSecond()))).applyLockingStrategy().compact();
                break;
            }
            case EDGE_LENGTH: {
                odc.setCompactionAlgorithm(NETWORK_SIMPLEX_COMPACTION).compact();
                break;
            }
        }
        odc.finish();
        transformer.applyLayout();
        progressMonitor.done();
    }

    private static final class EdgeAwareScanlineConstraintCalculation
    extends ScanlineConstraintCalculator {
        private final Function<CNode, Double> defaultSpacingFun = n -> this.compactor.direction.isHorizontal() ? n.getVerticalSpacing() : n.getHorizontalSpacing();

        private EdgeAwareScanlineConstraintCalculation() {
        }

        @Override
        public void calculateConstraints(OneDimensionalCompactor theCompactor) {
            this.compactor = theCompactor;
            this.sweep((Predicate<CNode>)((Predicate)n -> n instanceof CLEdge), this.defaultSpacingFun);
            this.sweep((Predicate<CNode>)((Predicate)n -> n instanceof CLNode), this.defaultSpacingFun);
            double minSpacing = Double.POSITIVE_INFINITY;
            for (CNode n2 : this.compactor.cGraph.cNodes) {
                if (n2 instanceof CLNode && ((CLNode)n2).getlNode().getType() == LNode.NodeType.EXTERNAL_PORT) continue;
                minSpacing = Math.min(minSpacing, (Double)this.defaultSpacingFun.apply((Object)n2));
            }
            if (minSpacing == Double.POSITIVE_INFINITY) {
                minSpacing = 0.0;
            }
            double finalMinSpacing = minSpacing;
            this.sweep((Predicate<CNode>)((Predicate)n -> true), (Function<CNode, Double>)((Function)n -> finalMinSpacing));
        }
    }
}

