/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.gemoc_studio.branding.discovery.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.amalgam.discovery.InstallableComponent;
import org.eclipse.amalgam.discovery.ui.common.internal.DiscoveryUiUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.dialogs.PreselectedIUInstallWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningWizardDialog;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.gemoc.gemoc_studio.branding.Activator;
import org.eclipse.gemoc.gemoc_studio.branding.discovery.wizards.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PrepareInstallProfileJob
implements IRunnableWithProgress {
    private static final String P2_FEATURE_GROUP_SUFFIX = ".feature.group";
    private final List<InstallableComponent> installableConnectors;
    private final ProvisioningUI provisioningUI;
    private Set<URI> repositoryLocations;
    private boolean headless = false;

    public PrepareInstallProfileJob(Collection<InstallableComponent> installableConnectors) {
        if (installableConnectors == null || installableConnectors.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.installableConnectors = new ArrayList<InstallableComponent>(installableConnectors);
        this.provisioningUI = ProvisioningUI.getDefaultUI();
    }

    public void setHeadlessMode(boolean isHeadless) {
        this.headless = isHeadless;
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)Messages.InstallConnectorsJob_task_configuring, (int)100);
            try {
                final Collection<IInstallableUnit> ius = this.computeInstallableUnits(monitor.newChild(50));
                this.checkCancelled((IProgressMonitor)monitor);
                final InstallOperation installOperation = this.resolve((IProgressMonitor)monitor.newChild(50), ius, this.repositoryLocations.toArray(new URI[0]));
                this.checkCancelled((IProgressMonitor)monitor);
                if (!this.headless) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PrepareInstallProfileJob.openInstallWizard(PrepareInstallProfileJob.this.provisioningUI, ius, installOperation);
                        }
                    });
                }
            }
            finally {
                monitor.done();
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException();
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    private static int openInstallWizard(ProvisioningUI ui, Collection<IInstallableUnit> initialSelections, InstallOperation operation) {
        PreselectedIUInstallWizard wizard = new PreselectedIUInstallWizard(ui, operation, initialSelections, null);
        wizard.setRemediationOperation(null);
        Shell defaultParentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(defaultParentShell, (ProvisioningOperationWizard)wizard);
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.equinox.p2.ui.install_wizard_context");
        return dialog.open();
    }

    private void checkCancelled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private InstallOperation resolve(IProgressMonitor monitor, Collection<IInstallableUnit> ius, URI[] repositories) throws CoreException {
        InstallOperation installOperation = this.provisioningUI.getInstallOperation(ius, repositories);
        IStatus operationStatus = installOperation.resolveModal((IProgressMonitor)new SubProgressMonitor(monitor, this.installableConnectors.size()));
        if (operationStatus.getSeverity() > 2) {
            Activator.getDefault().getLog().log(operationStatus);
            throw new RuntimeException(this.getFullMessage(operationStatus));
        }
        return installOperation;
    }

    public String getFullMessage(IStatus status) {
        if (status.isMultiStatus()) {
            StringBuilder sb = new StringBuilder();
            sb.append(status.getMessage());
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus subStatus = iStatusArray[n2];
                sb.append("\n" + this.getFullMessage(subStatus));
                ++n2;
            }
            return sb.toString();
        }
        return status.getMessage();
    }

    public Collection<IInstallableUnit> computeInstallableUnits(SubMonitor monitor) throws CoreException {
        try {
            monitor.setWorkRemaining(100);
            List<IMetadataRepository> repositories = this.addRepositories(monitor.newChild(50));
            List<IInstallableUnit> installableUnits = this.queryInstallableUnits(monitor.newChild(50), repositories);
            this.removeOldVersions(installableUnits);
            this.checkForUnavailable(installableUnits);
            List<IInstallableUnit> list = installableUnits;
            return list;
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.gemoc.gemoc_studio.branding", Messages.InstallConnectorsJob_unexpectedError_url, (Throwable)e));
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.gemoc.gemoc_studio.branding", Messages.InstallConnectorsJob_unexpectedError_url, (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    private void checkForUnavailable(List<IInstallableUnit> installableUnits) throws CoreException {
        HashSet<String> foundIds = new HashSet<String>();
        for (IInstallableUnit unit : installableUnits) {
            String id = unit.getId();
            if (id.endsWith(P2_FEATURE_GROUP_SUFFIX)) {
                id = id.substring(0, id.indexOf(P2_FEATURE_GROUP_SUFFIX));
            }
            foundIds.add(id);
        }
        String message = "";
        String detailedMessage = "";
        for (InstallableComponent descriptor : this.installableConnectors) {
            StringBuilder unavailableIds = null;
            for (String id : descriptor.getId()) {
                if (foundIds.contains(id)) continue;
                if (unavailableIds == null) {
                    unavailableIds = new StringBuilder();
                } else {
                    unavailableIds.append(Messages.InstallConnectorsJob_commaSeparator);
                }
                unavailableIds.append(id);
            }
            if (unavailableIds == null) continue;
            if (message.length() > 0) {
                message = String.valueOf(message) + Messages.InstallConnectorsJob_commaSeparator;
            }
            message = String.valueOf(message) + descriptor.getName();
            if (detailedMessage.length() > 0) {
                detailedMessage = String.valueOf(detailedMessage) + Messages.InstallConnectorsJob_commaSeparator;
            }
            detailedMessage = String.valueOf(detailedMessage) + NLS.bind((String)Messages.PrepareInstallProfileJob_notFoundDescriptorDetail, (Object[])new Object[]{descriptor.getName(), unavailableIds.toString(), descriptor.getSitesURLS()});
        }
        if (message.length() > 0) {
            final boolean[] okayToProceed = new boolean[1];
            final String finalMessage = message;
            if (this.headless) {
                throw new RuntimeException(detailedMessage);
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    okayToProceed[0] = MessageDialog.openQuestion((Shell)DiscoveryUiUtil.getShell(), (String)Messages.InstallConnectorsJob_questionProceed, (String)NLS.bind((String)Messages.InstallConnectorsJob_questionProceed_long, (Object[])new Object[]{finalMessage}));
                }
            });
            if (!okayToProceed[0]) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.gemoc.gemoc_studio.branding", NLS.bind((String)Messages.InstallConnectorsJob_connectorsNotAvailable, (Object)detailedMessage), null));
            }
        }
    }

    private void removeOldVersions(List<IInstallableUnit> installableUnits) {
        Version version;
        HashMap<String, Version> symbolicNameToVersion = new HashMap<String, Version>();
        for (IInstallableUnit unit : installableUnits) {
            version = (Version)symbolicNameToVersion.get(unit.getId());
            if (version != null && version.compareTo((Object)unit.getVersion()) != -1) continue;
            symbolicNameToVersion.put(unit.getId(), unit.getVersion());
        }
        if (symbolicNameToVersion.size() != installableUnits.size()) {
            for (IInstallableUnit unit : new ArrayList<IInstallableUnit>(installableUnits)) {
                version = (Version)symbolicNameToVersion.get(unit.getId());
                if (version.equals(unit.getVersion())) continue;
                installableUnits.remove(unit);
            }
        }
    }

    private List<IInstallableUnit> queryInstallableUnits(SubMonitor monitor, List<IMetadataRepository> repositories) throws URISyntaxException {
        ArrayList<IInstallableUnit> installableUnits = new ArrayList<IInstallableUnit>();
        monitor.setWorkRemaining(repositories.size());
        for (IMetadataRepository repository : repositories) {
            this.checkCancelled((IProgressMonitor)monitor);
            Set<String> installableUnitIdsThisRepository = this.getDescriptorIds(repository);
            IQuery query = QueryUtil.createMatchQuery((String)"id ~= /*.feature.group/ && properties['org.eclipse.equinox.p2.type.group'] == true ", (Object[])new Object[0]);
            IQueryResult result = repository.query(query, (IProgressMonitor)monitor.newChild(1));
            for (IInstallableUnit iu : result) {
                String id = iu.getId();
                if (!installableUnitIdsThisRepository.contains(id.substring(0, id.indexOf(P2_FEATURE_GROUP_SUFFIX)))) continue;
                installableUnits.add(iu);
            }
        }
        return installableUnits;
    }

    private List<IMetadataRepository> addRepositories(SubMonitor monitor) throws MalformedURLException, URISyntaxException, ProvisionException {
        ProvisioningSession session = ProvisioningUI.getDefaultUI().getSession();
        RepositoryTracker repositoryTracker = ProvisioningUI.getDefaultUI().getRepositoryTracker();
        this.repositoryLocations = new HashSet<URI>();
        monitor.setWorkRemaining(this.installableConnectors.size() * 5);
        for (InstallableComponent descriptor : this.installableConnectors) {
            for (String url : descriptor.getSitesURLS()) {
                this.addASiteURL(monitor, session, repositoryTracker, url);
            }
        }
        ArrayList<IMetadataRepository> repositories = new ArrayList<IMetadataRepository>();
        monitor.setWorkRemaining(repositories.size());
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)session.getProvisioningAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        for (URI uri : this.repositoryLocations) {
            this.checkCancelled((IProgressMonitor)monitor);
            IMetadataRepository repository = manager.loadRepository(uri, (IProgressMonitor)monitor.newChild(1));
            repositories.add(repository);
        }
        return repositories;
    }

    private void addASiteURL(SubMonitor monitor, ProvisioningSession session, RepositoryTracker repositoryTracker, String url) throws URISyntaxException, MalformedURLException {
        URI uri = new URL(url).toURI();
        if (this.repositoryLocations.add(uri)) {
            this.checkCancelled((IProgressMonitor)monitor);
            repositoryTracker.addRepository(uri, null, session);
        }
        monitor.worked(1);
    }

    private Set<String> getDescriptorIds(IMetadataRepository repository) throws URISyntaxException {
        HashSet<String> installableUnitIdsThisRepository = new HashSet<String>();
        for (InstallableComponent descriptor : this.installableConnectors) {
            try {
                if (!this.hasThisUpdateSite(repository.getLocation(), descriptor)) continue;
                installableUnitIdsThisRepository.addAll((Collection<String>)descriptor.getId());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return installableUnitIdsThisRepository;
    }

    private boolean hasThisUpdateSite(URI location, InstallableComponent descriptor) throws MalformedURLException {
        boolean found = false;
        Iterator it = descriptor.getSitesURLS().iterator();
        while (it.hasNext() && !found) {
            String url = (String)it.next();
            if (!location.toString().equals(url)) continue;
            found = true;
        }
        return found;
    }
}

