/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.ui.EvaluationContextManager;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionDelegateHelper;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.RunToLineAdapter;
import org.eclipse.jdt.internal.debug.ui.actions.StepIntoSelectionHandler;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class StepIntoSelectionUtils {
    public static IJavaElement getJavaElement(IEditorInput input) {
        IJavaElement je = JavaUI.getEditorInputJavaElement((IEditorInput)input);
        if (je != null) {
            return je;
        }
        return JavaUI.getWorkingCopyManager().getWorkingCopy(input);
    }

    public static IMethod getMethod(ITextSelection selection, IJavaElement element) throws JavaModelException {
        if (element != null && element instanceof ICodeAssist) {
            return StepIntoSelectionUtils.resolveMethod(selection.getOffset(), selection.getLength(), (ICodeAssist)element);
        }
        return null;
    }

    private static IMethod resolveMethod(int offset, int length, ICodeAssist codeAssist) throws JavaModelException {
        IJavaElement[] elements = codeAssist.codeSelect(offset, length);
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IMethod) {
                return (IMethod)elements[i];
            }
            ++i;
        }
        return null;
    }

    public static IMethod getFirstMethodOnLine(int offset, IEditorPart activeEditor, IJavaElement element) throws JavaModelException {
        if (!(activeEditor instanceof ITextEditor) || !(element instanceof ICodeAssist)) {
            return null;
        }
        ITextEditor editor = (ITextEditor)activeEditor;
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
        if (document == null) {
            return null;
        }
        try {
            IRegion lineInfo = document.getLineInformationOfOffset(offset);
            String line = document.get(lineInfo.getOffset(), lineInfo.getLength());
            IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, null, (String)"1.5");
            scanner.setSource(line.toCharArray());
            scanner.resetTo(offset - lineInfo.getOffset(), lineInfo.getLength());
            int token = scanner.getNextToken();
            while (token != 158) {
                if (token == 5) {
                    int methodStart = scanner.getCurrentTokenStartPosition();
                    token = scanner.getNextToken();
                    if (token != 7) continue;
                    return StepIntoSelectionUtils.resolveMethod(lineInfo.getOffset() + methodStart, 0, (ICodeAssist)element);
                }
                token = scanner.getNextToken();
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        catch (InvalidInputException invalidInputException) {
            return null;
        }
        return null;
    }

    public static void stepIntoSelection(ITextSelection selection) {
        IEditorPart editor;
        IWorkbenchPage page = JDIDebugUIPlugin.getActiveWorkbenchWindow().getActivePage();
        if (page != null && (editor = page.getActiveEditor()) instanceof ITextEditor) {
            IJavaStackFrame frame = EvaluationContextManager.getEvaluationContext((IWorkbenchPart)editor);
            if (frame == null || !frame.isSuspended()) {
                return;
            }
            if (selection == null) {
                selection = (ITextSelection)editor.getEditorSite().getSelectionProvider().getSelection();
            }
            try {
                IJavaElement javaElement = StepIntoSelectionUtils.getJavaElement(editor.getEditorInput());
                IMethod method = StepIntoSelectionUtils.getMethod(selection, javaElement);
                if (method == null) {
                    method = StepIntoSelectionUtils.getFirstMethodOnLine(selection.getOffset(), editor, javaElement);
                }
                IType callingType = StepIntoSelectionUtils.getType(selection);
                if (method == null || callingType == null) {
                    return;
                }
                int lineNumber = frame.getLineNumber();
                String callingTypeName = StepIntoSelectionUtils.stripInnerNamesAndParameterType(callingType.getFullyQualifiedName());
                String frameName = StepIntoSelectionUtils.stripInnerNamesAndParameterType(frame.getDeclaringTypeName());
                if (selection.getStartLine() != lineNumber - 1 || !callingTypeName.equals(frameName)) {
                    StepIntoSelectionUtils.runToLineBeforeStepIn(editor, callingTypeName, selection, frame.getThread(), method);
                    return;
                }
                StepIntoSelectionUtils.doStepIn(editor, frame, method);
            }
            catch (DebugException e) {
                StepIntoSelectionUtils.showErrorMessage(editor, e.getStatus().getMessage());
                return;
            }
            catch (JavaModelException jme) {
                StepIntoSelectionUtils.showErrorMessage(editor, jme.getStatus().getMessage());
                return;
            }
        }
    }

    static void runToLineBeforeStepIn(final IEditorPart editor, final String typeName, ITextSelection textSelection, final IThread thread, final IMethod method) {
        IAdapterManager adapterManager;
        final int line = textSelection.getStartLine() + 1;
        if (typeName == null || line == -1) {
            return;
        }
        IRunToLineTarget runToLineAction = null;
        if (editor != null && (runToLineAction = (IRunToLineTarget)editor.getAdapter(IRunToLineTarget.class)) == null && (adapterManager = Platform.getAdapterManager()).hasAdapter((Object)editor, IRunToLineTarget.class.getName())) {
            runToLineAction = (IRunToLineTarget)adapterManager.loadAdapter((Object)editor, IRunToLineTarget.class.getName());
        }
        if (runToLineAction == null) {
            runToLineAction = new RunToLineAdapter();
        }
        IDebugEventSetListener listener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    DebugEvent event = events[i];
                    switch (event.getKind()) {
                        case 2: {
                            this.handleSuspendEvent(event);
                            break;
                        }
                        case 8: {
                            this.handleTerminateEvent(event);
                            break;
                        }
                    }
                    ++i;
                }
            }

            private void handleSuspendEvent(DebugEvent event) {
                Object source = event.getSource();
                if (source instanceof IJavaThread) {
                    try {
                        final IJavaStackFrame frame = (IJavaStackFrame)((IJavaThread)source).getTopStackFrame();
                        if (this.isExpectedFrame(frame)) {
                            DebugPlugin plugin = DebugPlugin.getDefault();
                            plugin.removeDebugEventListener((IDebugEventSetListener)this);
                            plugin.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        StepIntoSelectionUtils.doStepIn(editor, frame, method);
                                    }
                                    catch (DebugException e) {
                                        StepIntoSelectionUtils.showErrorMessage(editor, e.getStatus().getMessage());
                                    }
                                }
                            });
                        }
                    }
                    catch (DebugException debugException) {
                        return;
                    }
                }
            }

            private boolean isExpectedFrame(IJavaStackFrame frame) throws DebugException {
                return frame != null && line == frame.getLineNumber() && frame.getReceivingTypeName().equals(typeName);
            }

            private void handleTerminateEvent(DebugEvent event) {
                Object source = event.getSource();
                if (thread.getDebugTarget() == source) {
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(listener);
        try {
            runToLineAction.runToLine((IWorkbenchPart)editor, (ISelection)textSelection, (ISuspendResume)thread);
        }
        catch (CoreException e) {
            DebugPlugin.getDefault().removeDebugEventListener(listener);
            StepIntoSelectionUtils.showErrorMessage(editor, ActionMessages.StepIntoSelectionActionDelegate_4);
            JDIDebugUIPlugin.log(e.getStatus());
        }
    }

    static void doStepIn(IEditorPart editor, IJavaStackFrame frame, IMethod method) throws DebugException {
        IStackFrame tos = frame.getThread().getTopStackFrame();
        if (tos == null) {
            return;
        }
        if (!tos.equals(frame)) {
            StepIntoSelectionUtils.showErrorMessage(editor, ActionMessages.StepIntoSelectionActionDelegate_Step_into_selection_only_available_in_top_stack_frame__3);
            return;
        }
        StepIntoSelectionHandler handler = new StepIntoSelectionHandler((IJavaThread)frame.getThread(), frame, method);
        handler.step();
    }

    static void showErrorMessage(IEditorPart editor, String message) {
        IEditorStatusLine statusLine;
        if (editor != null && (statusLine = (IEditorStatusLine)editor.getAdapter(IEditorStatusLine.class)) != null) {
            statusLine.setMessage(true, message, null);
        }
    }

    static IType getType(ITextSelection textSelection) {
        IMember member = ActionDelegateHelper.getDefault().getCurrentMember(textSelection);
        IType type = null;
        if (member instanceof IType) {
            type = (IType)member;
        } else if (member != null) {
            type = member.getDeclaringType();
        }
        return type;
    }

    static String stripInnerNamesAndParameterType(String fullyQualifiedName) {
        String sig = fullyQualifiedName;
        int index = sig.indexOf(36);
        if (index > 0) {
            sig = sig.substring(0, index);
        }
        if ((index = sig.indexOf(60)) > 0) {
            sig = sig.substring(0, index);
        }
        return sig;
    }
}

