/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml.internal.mojo;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.editor.xml.mojo.IMojoParameterMetadata;
import org.eclipse.m2e.editor.xml.mojo.MojoParameter;
import org.eclipse.m2e.editor.xml.mojo.PlexusConfigHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMojoParameterMetadata
implements IMojoParameterMetadata {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<MojoParameter> loadMojoParameters(PluginDescriptor desc, MojoDescriptor mojo, PlexusConfigHelper helper, IProgressMonitor monitor) throws CoreException {
        Class clazz;
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        try {
            clazz = mojo.getImplementationClass();
            if (clazz == null) {
                clazz = desc.getClassRealm().loadClass(mojo.getImplementation());
            }
        }
        catch (ClassNotFoundException | TypeNotPresentException ex) {
            this.log.warn(ex.getMessage());
            return Collections.emptyList();
        }
        List ps = mojo.getParameters();
        Map<String, Type> properties = helper.getClassProperties(clazz);
        ArrayList<MojoParameter> parameters = new ArrayList<MojoParameter>();
        if (ps != null) {
            for (Parameter p : ps) {
                Type type;
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                if (!p.isEditable() || (type = properties.get(p.getName())) == null) continue;
                helper.addParameter(desc.getClassRealm(), clazz, type, p.getName(), p.getAlias(), parameters, p.isRequired(), p.getExpression(), p.getDescription(), p.getDefaultValue(), monitor);
            }
        }
        return parameters;
    }
}

